/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc;

import gov.nasa.giss.data.nc.NcCoordinateVarType;
import gov.nasa.giss.data.nc.NcDataNode;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcGroup;
import gov.nasa.giss.data.nc.NcStructure;
import gov.nasa.giss.data.nc.NcVarClass;
import gov.nasa.giss.data.nc.NcVarUtils;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.ui.NcDataTreeTableModel;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Group;
import ucar.nc2.Variable;
import ucar.nc2.dataset.StructureDS;
import ucar.nc2.dataset.VariableDS;

public abstract class NcDataGrouping
extends NcDataNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected NcDataset ncdataset_;
    protected Group njgroup_;
    private ArrayList<NcVariable> allChildVars_;
    private NcVariable[] cvars_;

    public NcDataGrouping(NcDataset ncd) {
        this.ncdataset_ = ncd;
    }

    protected void setGrouping(Group g) {
        this.njgroup_ = g;
    }

    protected void initChildren() {
        String fname;
        this.clear();
        if (this.allChildVars_ == null) {
            this.allChildVars_ = new ArrayList(20);
        } else {
            this.allChildVars_.clear();
        }
        if (this.ncdataset_ == null || this.njgroup_ == null) {
            return;
        }
        this.childNameList_.clear();
        for (Group group : this.njgroup_.getGroups()) {
            fname = group.getFullName();
            this.childNameList_.add(fname);
        }
        for (Variable variable : this.njgroup_.getVariables()) {
            fname = variable.getFullName();
            this.childNameList_.add(fname);
        }
        for (Group group : this.njgroup_.getGroups()) {
            try {
                this.addSorted(new NcGroup(this.ncdataset_, group));
            }
            catch (Exception exc) {
                LOGGER.error("Could not create NCGroup");
                if (!LOGGER.isTraceEnabled()) continue;
                exc.printStackTrace();
            }
        }
        NcVarClass vclass = this.getVisibleVarClass();
        for (Variable o : this.njgroup_.getVariables()) {
            try {
                if (o instanceof VariableDS) {
                    VariableDS njvarDS = (VariableDS)o;
                    NcVariable ncv = new NcVariable(this.ncdataset_, this, njvarDS);
                    this.allChildVars_.add(ncv);
                    if (vclass != NcVarClass.ALL && !ncv.isGriddable2DGeo() && (vclass != NcVarClass.GRIDDABLE || !ncv.isGriddable2D())) continue;
                    this.addSorted(ncv);
                    continue;
                }
                if (o instanceof StructureDS) {
                    this.addSorted(new NcStructure(this.ncdataset_, (StructureDS)o));
                    continue;
                }
                LOGGER.warn("Unrecognized data class {}", (Object)o.getClass());
            }
            catch (Exception exc) {
                LOGGER.error("(Variables)");
                if (!LOGGER.isTraceEnabled()) continue;
                exc.printStackTrace();
            }
        }
        this.scanForCoordinateVars();
    }

    @Override
    public void setVisibleVarClass(NcDataTreeTableModel model, NcVarClass vclass) {
        super.setVisibleVarClass(model, vclass);
        if (this.njgroup_ == null) {
            LOGGER.warn("Backing NJ Group is not set.");
            return;
        }
        TreeTableNode[] children = this.getChildren();
        if (vclass == NcVarClass.GEOREFERENCED || vclass == NcVarClass.GRIDDABLE) {
            for (int i = children.length - 1; i >= 0; --i) {
                NcVariable ncv;
                NcDataNode node = (NcDataNode)children[i];
                if (!(node instanceof NcVariable) || (ncv = (NcVariable)node).isGriddable2DGeo() || ncv.isTrajectory() || vclass == NcVarClass.GRIDDABLE && ncv.isGriddable()) continue;
                this.remove(node);
                if (model == null) continue;
                model.nodeRemoved(this, i, node);
            }
        }
        if (vclass == NcVarClass.ALL || vclass == NcVarClass.GRIDDABLE) {
            for (Variable o : this.njgroup_.getVariables()) {
                try {
                    NcVariable node;
                    if (!(o instanceof VariableDS)) continue;
                    VariableDS njvarDS = (VariableDS)o;
                    if (vclass != NcVarClass.ALL && (vclass != NcVarClass.GRIDDABLE || !NcVarUtils.isGriddable(njvarDS)) || this.isChild(node = new NcVariable(this.ncdataset_, this, njvarDS))) continue;
                    int index = this.addSorted(node);
                    if (model == null) continue;
                    model.nodeInserted(this, index, node);
                }
                catch (Exception exc) {
                    LOGGER.error(exc.toString());
                    if (!LOGGER.isTraceEnabled()) continue;
                    exc.printStackTrace();
                }
            }
        }
    }

    public NcVariable[] getCoordinateVars() {
        LOGGER.trace("");
        if (this.cvars_ == null) {
            this.scanForCoordinateVars();
        }
        return this.cvars_;
    }

    private void scanForCoordinateVars() {
        ArrayList<NcVariable> cvarList = new ArrayList<NcVariable>(50);
        for (NcVariable ncvar : this.allChildVars_) {
            NcCoordinateVarType cvarType = ncvar.getCoordinateVarType();
            if (cvarType == NcCoordinateVarType.NONE || cvarType == NcCoordinateVarType.OTHER) continue;
            cvarList.add(ncvar);
        }
        this.cvars_ = cvarList.toArray(new NcVariable[0]);
    }
}

