/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc;

import gov.nasa.giss.data.nc.NcDataGrouping;
import gov.nasa.giss.data.nc.NcDataNode;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcFilenameFilter;
import gov.nasa.giss.data.nc.NcGeometryType;
import gov.nasa.giss.data.nc.NcGroup;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.text.StringUtils;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EnumSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NCdumpW;
import ucar.nc2.NetcdfFile;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.CoordSysBuilderIF;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis2D;
import ucar.nc2.dataset.DatasetUrl;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.iosp.IOServiceProvider;

public class NcDataset
extends NcDataGrouping {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private NetcdfDataset njdEnhanced_;
    private NetcdfDataset njdUnenhanced_;
    private NetcdfDataset njDataset_;
    private NetcdfFile njfile_;
    private URL url_;
    private String name_;
    private NcGeometryType geometry_;
    private EnumSet<NetcdfDataset.Enhance> enhancement_;

    public NcDataset(File f) throws IOException, FileNotFoundException, MalformedURLException {
        this(f.toURI().toURL());
    }

    public NcDataset(URL url) throws IOException, FileNotFoundException {
        this(url, true);
    }

    public NcDataset(URL url, boolean enhanced) throws IOException, FileNotFoundException {
        block22: {
            super(null);
            this.geometry_ = NcGeometryType.GRIDDED;
            this.ncdataset_ = this;
            this.url_ = url;
            this.name_ = url.getFile();
            int lastSep = this.name_.lastIndexOf(47);
            if (lastSep > -1) {
                this.name_ = this.name_.substring(lastSep + 1);
            }
            String location = this.url_.toString();
            if (enhanced) {
                this.njdEnhanced_ = this.acquireNjDataset(location, true);
                LOGGER.debug("Acquired NJ dataset (enhanced) at {}", (Object)location);
            }
            boolean isLocal = this.url_.getProtocol().equalsIgnoreCase("file");
            boolean isNcml = this.name_.toLowerCase().endsWith(".ncml");
            if (isLocal || isNcml) {
                this.njdUnenhanced_ = this.acquireNjDataset(location, false);
                LOGGER.debug("Acquired NJ dataset (unenhanced) at {}", (Object)location);
            }
            this.njDataset_ = this.njdEnhanced_ == null ? this.njdUnenhanced_ : this.njdEnhanced_;
            try {
                this.njfile_ = NetcdfFile.open(this.url_.toString());
                LOGGER.debug("Opened backing NJ file at {}", (Object)this.url_);
            }
            catch (Exception exc) {
                if (isNcml) break block22;
                LOGGER.warn("Exception opening backing NJ 'file':");
                LOGGER.warn("{}", (Object)exc.toString());
                if (!LOGGER.isTraceEnabled()) break block22;
                exc.printStackTrace();
            }
        }
        if (this.njfile_ == null) {
            LOGGER.trace("Calling getReferencedFile to get underlying file");
            this.njfile_ = this.njDataset_.getReferencedFile();
        }
        if (LOGGER.isDebugEnabled()) {
            IOServiceProvider iosp = this.njDataset_.getIosp();
            LOGGER.trace("Dataset {}", (Object)this.name_);
            if (iosp == null) {
                LOGGER.trace("== IOSP is null");
            } else {
                LOGGER.trace("== IOSP ftype {}", (Object)this.njDataset_.getIosp().getFileTypeDescription());
                LOGGER.trace("== IOSP class {}", (Object)this.njDataset_.getIosp().getClass());
            }
            LOGGER.trace("== Convention {}", (Object)this.njDataset_.getConventionUsed());
        }
        String fts = this.getNjStringAttribute("featureType");
        LOGGER.trace("== featureType {}", (Object)fts);
        if (fts == null) {
            fts = this.getNjStringAttribute("cdm_data_type");
            LOGGER.trace("== cdm_data_type {}", (Object)fts);
        }
        if (fts != null) {
            if ("trajectory".equalsIgnoreCase(fts)) {
                this.geometry_ = NcGeometryType.TRAJECTORY;
            } else if ("trajectoryProfile".equalsIgnoreCase(fts)) {
                this.geometry_ = NcGeometryType.TRAJECTORY_PROFILE;
            } else if ("timeSeries".equalsIgnoreCase(fts)) {
                this.geometry_ = NcGeometryType.TIME_SERIES;
            } else if ("point".equalsIgnoreCase(fts)) {
                this.geometry_ = NcGeometryType.POINT;
            } else if ("profile".equalsIgnoreCase(fts)) {
                this.geometry_ = NcGeometryType.PROFILE;
            } else if ("timeSeriesProfile".equalsIgnoreCase(fts)) {
                this.geometry_ = NcGeometryType.TIME_SERIES_PROFILE;
            }
            LOGGER.trace("== FT geometry {}", (Object)this.geometry_);
        }
        this.setGrouping(this.njDataset_.getRootGroup());
        this.initChildren();
    }

    private NetcdfDataset acquireNjDataset(String location, boolean enhanced) throws IOException {
        NetcdfDataset result = null;
        try {
            DatasetUrl durl = DatasetUrl.findDatasetUrl(location);
            if (enhanced) {
                if (this.enhancement_ == null) {
                    Set<NetcdfDataset.Enhance> dfltMode = NetcdfDataset.getDefaultEnhanceMode();
                    this.enhancement_ = EnumSet.copyOf(dfltMode);
                    this.enhancement_.add(NetcdfDataset.Enhance.IncompleteCoordSystems);
                }
                result = NetcdfDataset.acquireDataset(durl, this.enhancement_, null);
            } else {
                result = NetcdfDataset.acquireDataset(durl, enhanced, null);
            }
            LOGGER.debug("Acquired NJ dataset at {}", (Object)location);
        }
        catch (IOException ioe) {
            LOGGER.warn("IOException acquiring {}, enhance {}", (Object)location, (Object)enhanced);
            if (LOGGER.isTraceEnabled()) {
                ioe.printStackTrace();
            }
            String msg = ioe.toString();
            msg = msg.replaceFirst(".*Could not find a table for GRIB file with ", "No GRIB table is available for ");
            throw new IOException(msg);
        }
        catch (Exception exc) {
            LOGGER.warn("Exception acquiring {}, enhance {}", (Object)location, (Object)enhanced);
            LOGGER.warn("Exception is {}", (Object)exc.toString());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            String msg = exc.toString();
            msg = msg.replaceFirst(".*Could not find a table for GRIB file with ", "No GRIB table is available for ");
            throw new IOException(msg);
        }
        return result;
    }

    public String getNcFileTypeID() {
        return this.njDataset_.getFileTypeId();
    }

    public URL getURL() {
        return this.url_;
    }

    public NetcdfDataset getNjDataset() {
        return this.njDataset_;
    }

    public boolean isEnhanced() {
        return this.njdEnhanced_ != null;
    }

    public NcGeometryType getGeometry() {
        if (this.geometry_ == null) {
            LOGGER.trace("Geometry has somehow become null.");
            this.geometry_ = NcGeometryType.GRIDDED;
        }
        return this.geometry_;
    }

    public Dimension getNjDimension(String name) {
        return this.njDataset_.findDimension(name);
    }

    public String getNjStringAttribute(String name) {
        Attribute a = this.njDataset_.findGlobalAttribute(name);
        if (a == null || a.isArray() || !a.isString()) {
            return null;
        }
        return a.getStringValue();
    }

    public Integer getNjIntegerAttribute(String name) {
        Attribute a = this.njDataset_.findGlobalAttribute(name);
        if (a == null || a.isArray()) {
            return null;
        }
        Number nn = a.getNumericValue();
        if (nn == null) {
            return null;
        }
        return nn.intValue();
    }

    public NcVariable getVariable(String path) {
        VariableDS njvar = this.getNjVariable(path);
        if (njvar == null) {
            throw new NcException("Found no variable matching name '" + path + "'");
        }
        return new NcVariable(this, null, njvar);
    }

    public VariableDS getNjVariable(String fullName) {
        return (VariableDS)this.njDataset_.findVariable(fullName);
    }

    public VariableDS getNjVariableUnenhanced(String fullName) {
        if (this.njdUnenhanced_ == null) {
            return null;
        }
        return (VariableDS)this.njdUnenhanced_.findVariable(fullName);
    }

    public VariableDS getNjCoordinateVariable(Dimension d) {
        String dname = d.getFullName();
        if (dname == null) {
            return null;
        }
        VariableDS varDS = this.getNjVariable(dname);
        if (varDS != null) {
            return varDS;
        }
        for (TreeTableNode node : this.getChildren()) {
            Dimension d2;
            NcVariable ncv;
            NcDataNode ncn = (NcDataNode)node;
            if (!(ncn instanceof NcVariable) || !(ncv = (NcVariable)ncn).getName().equalsIgnoreCase(dname) || !(d2 = (varDS = ncv.getNjVariable()).getDimension(0)).equals(d)) continue;
            return varDS;
        }
        return null;
    }

    public CoordinateAxis createNjCoordinateAxis(VariableDS cv, AxisType axtype) {
        if (cv == null) {
            return null;
        }
        int rank = cv.getRank();
        CoordinateAxis ca = null;
        if (rank == 1) {
            ca = new CoordinateAxis1D(this.njDataset_, cv);
        } else if (rank == 2) {
            ca = new CoordinateAxis2D(this.njDataset_, cv);
        } else {
            return null;
        }
        if (axtype != null) {
            ca.setAxisType(axtype);
        }
        return ca;
    }

    public void close() throws IOException {
        if (this.njdEnhanced_ != null) {
            this.njdEnhanced_.close();
        }
        if (this.njdUnenhanced_ != null) {
            this.njdUnenhanced_.close();
        }
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public Object getObject() {
        return this;
    }

    @Override
    public String getName() {
        return this.name_;
    }

    @Override
    public String getNcType() {
        String s = this.url_.toString().toLowerCase();
        if (s.startsWith("file:")) {
            return "Local File";
        }
        if (s.startsWith("http:") || s.startsWith("https:") || s.startsWith("ftp:")) {
            return "Remote File";
        }
        return "-";
    }

    @Override
    public String getLongName() {
        return this.getName();
    }

    @Override
    public String getDetail(boolean enhanced) {
        StringBuilder sb = new StringBuilder(256);
        sb.append("<html>");
        sb.append("<head>");
        this.appendDetailStyle(sb);
        sb.append("</head>").append("<body>");
        sb.append("<h2>File \"").append(this.getName()).append("\"</h2>\n");
        sb.append("<p>File type: ");
        if (enhanced || this.njdUnenhanced_ == null && this.njfile_ == null) {
            sb.append(this.njDataset_.getFileTypeDescription());
        } else if (this.njdUnenhanced_ == null) {
            sb.append(this.njfile_.getFileTypeDescription());
        } else {
            sb.append(this.njDataset_.getFileTypeDescription());
        }
        sb.append("</p>\n");
        if (enhanced || this.njdUnenhanced_ == null && this.njfile_ == null) {
            String convention;
            int lastDot;
            sb.append("<p><b>");
            if (!enhanced) {
                sb.append("Unable to acquire unenhanced dataset. ");
            }
            sb.append("Showing enhanced mode description.</b></p>").append("<p>");
            IOServiceProvider iosp = this.njDataset_.getIosp();
            if (iosp != null) {
                sb.append("IOSP file type: ").append(iosp.getFileTypeDescription()).append("<br>");
                String ss = iosp.getClass().toString();
                if (!LOGGER.isDebugEnabled() && (lastDot = ss.lastIndexOf(46)) > -1) {
                    ss = ss.substring(lastDot + 1);
                }
                sb.append("IOSP class: ").append(ss).append("<br>");
            }
            if ((convention = this.njDataset_.getConventionUsed()) != null && !convention.isEmpty()) {
                if (!LOGGER.isDebugEnabled() && (lastDot = convention.lastIndexOf(46)) > -1) {
                    convention = convention.substring(lastDot + 1);
                }
                sb.append("Convention: ").append(convention).append("<br>");
            }
            if (LOGGER.isDebugEnabled()) {
                try {
                    CoordSysBuilderIF builder = CoordSysBuilder.factory(this.njDataset_, null);
                    if (builder != null) {
                        int lastDot2;
                        String ss = builder.getClass().toString();
                        if (!LOGGER.isDebugEnabled() && (lastDot2 = ss.lastIndexOf(46)) > -1) {
                            ss = ss.substring(lastDot2 + 1);
                        }
                        sb.append("Coordinate system builder: ").append(ss).append("<br>");
                    }
                }
                catch (Exception ignore) {
                    LOGGER.debug("Could not extract coordinate system builder");
                }
            }
            sb.append("</p>");
            if (LOGGER.isDebugEnabled() && iosp != null) {
                sb.append("<hr>").append("IOSP detail:").append("<br>").append("<pre>").append(iosp.getDetailInfo()).append("</pre>");
            }
        }
        sb.append("<hr>").append("<pre>");
        if (enhanced || this.njdUnenhanced_ == null && this.njfile_ == null) {
            sb.append(StringUtils.escapeHtmlSimplistic(this.njDataset_.toString()));
        } else if (this.njdUnenhanced_ == null) {
            sb.append(StringUtils.escapeHtmlSimplistic(this.njfile_.toString()));
        } else {
            sb.append(StringUtils.escapeHtmlSimplistic(this.njDataset_.toString()));
        }
        sb.append('\n').append("</pre>").append("</body>").append("</html>");
        return sb.toString();
    }

    @Override
    public String getDetailType() {
        return "text/html";
    }

    public String getNameRoot() {
        String[] extensions = NcFilenameFilter.getExtensionsArray();
        String lcname = this.name_.toLowerCase();
        for (String s : extensions) {
            if (!lcname.endsWith("." + s.toLowerCase())) continue;
            return this.name_.substring(0, this.name_.length() - s.length() - 1);
        }
        return this.name_;
    }

    public boolean isHdfeos() {
        for (TreeTableNode node : this.getChildren()) {
            NcGroup ndg;
            NcDataNode ncn = (NcDataNode)node;
            if (!(ncn instanceof NcGroup) || !"HDFEOS".equalsIgnoreCase((ndg = (NcGroup)ncn).getName()) && !"HDFEOS_INFORMATION".equalsIgnoreCase(ndg.getName())) continue;
            return true;
        }
        Attribute a = this.njDataset_.findGlobalAttribute("HDFEOSVersion");
        return a != null && a.isString();
    }

    public void printCdl(File f) throws IOException {
        PrintWriter writer = new PrintWriter(f);
        NCdumpW.print(this.njDataset_.getReferencedFile(), (Writer)writer, true, false, false, true, "", null);
        writer.close();
    }
}

