/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Objects;

public class NcFilenameFilter
implements FilenameFilter {
    private static final String[] NC_EXTENSIONS = new String[]{"nc", "nc3", "nc4", "ncdf", "ncml", "netcdf"};
    private static final String[] HDF_EXTENSIONS = new String[]{"hdf", "eos", "h5", "hd4", "hd5", "hdf4", "hdf5", "hdfeos", "he4", "he5"};
    private static final String[] GRIB_EXTENSIONS = new String[]{"grib", "gb2", "gr2", "grb", "grb1", "grb2", "grib2"};
    private static final String[] GEMPAK_EXTENSIONS = new String[]{"gem", "gempak"};
    private static final String[] COMPRESSION_EXTENSIONS = new String[]{"bz2", "gz", "gzip", "z"};
    private static String[] NC_PLUS_EXTENSIONS;
    private static String[] HDF_PLUS_EXTENSIONS;
    private static String[] GEMPAK_PLUS_EXTENSIONS;
    private static String[] GRIB_PLUS_EXTENSIONS;
    private static String[] ALL_PLUS_EXTENSIONS;
    private FilterType type_;

    public NcFilenameFilter() {
        this(FilterType.NETCDF);
    }

    public NcFilenameFilter(FilterType type) {
        this.type_ = type;
    }

    public static String getExtensions(FilterType type) {
        String[] array = null;
        switch (type) {
            case NETCDF: {
                array = NC_EXTENSIONS;
                break;
            }
            case HDF: {
                array = HDF_EXTENSIONS;
                break;
            }
            case GRIB: {
                array = GRIB_EXTENSIONS;
                break;
            }
            case GEMPAK: {
                array = GEMPAK_EXTENSIONS;
                break;
            }
            default: {
                return null;
            }
        }
        String ext = array[0];
        for (int i = 0; i < array.length; ++i) {
            ext = ext.concat(",").concat(array[i]);
        }
        return ext;
    }

    public static String[] getExtensionsArray() {
        return NcFilenameFilter.getExtensionsArray(FilterType.ALL);
    }

    public static String[] getExtensionsArray(FilterType type) {
        switch (type) {
            case NETCDF: {
                return NC_PLUS_EXTENSIONS;
            }
            case GEMPAK: {
                return GEMPAK_PLUS_EXTENSIONS;
            }
            case GRIB: {
                return GRIB_PLUS_EXTENSIONS;
            }
            case HDF: {
                return HDF_PLUS_EXTENSIONS;
            }
        }
        return ALL_PLUS_EXTENSIONS;
    }

    @Override
    public boolean accept(File dir, String name) {
        if (NcFilenameFilter.accept(this.type_, name)) {
            return true;
        }
        return new File(dir, name).isDirectory();
    }

    public static boolean accept(File f) {
        Objects.requireNonNull(f, "File is null.");
        return NcFilenameFilter.accept(FilterType.ALL, f.getName());
    }

    public static boolean accept(FilterType type, File f) {
        Objects.requireNonNull(f, "File is null.");
        return NcFilenameFilter.accept(type, f.getName());
    }

    public static boolean accept(String fname) {
        return NcFilenameFilter.accept(FilterType.ALL, fname);
    }

    public static boolean accept(FilterType type, String fname) {
        Objects.requireNonNull(fname, "File name is null.");
        String lcname = fname.toLowerCase();
        switch (type) {
            case NETCDF: {
                for (String extension : NC_PLUS_EXTENSIONS) {
                    if (!lcname.endsWith("." + extension)) continue;
                    return true;
                }
                break;
            }
            case GEMPAK: {
                for (String extension : GEMPAK_PLUS_EXTENSIONS) {
                    if (!lcname.endsWith("." + extension)) continue;
                    return true;
                }
                break;
            }
            case GRIB: {
                for (String extension : GRIB_PLUS_EXTENSIONS) {
                    if (!lcname.endsWith("." + extension)) continue;
                    return true;
                }
                break;
            }
            case HDF: {
                for (String extension : HDF_PLUS_EXTENSIONS) {
                    if (!lcname.endsWith("." + extension)) continue;
                    return true;
                }
                break;
            }
            default: {
                for (String extension : ALL_PLUS_EXTENSIONS) {
                    if (!lcname.endsWith("." + extension)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    static {
        ArrayList<String> ncExtensions = new ArrayList<String>(25);
        ArrayList<String> hdfExtensions = new ArrayList<String>(50);
        ArrayList<String> gempakExtensions = new ArrayList<String>(25);
        ArrayList<String> gribExtensions = new ArrayList<String>(25);
        ArrayList<String> allExtensions = new ArrayList<String>(100);
        for (String s1 : NC_EXTENSIONS) {
            ncExtensions.add(s1);
            allExtensions.add(s1);
            for (String s2 : COMPRESSION_EXTENSIONS) {
                ncExtensions.add(s1 + "." + s2);
                allExtensions.add(s1 + "." + s2);
            }
        }
        for (String s1 : GEMPAK_EXTENSIONS) {
            gempakExtensions.add(s1);
            allExtensions.add(s1);
            for (String s2 : COMPRESSION_EXTENSIONS) {
                gempakExtensions.add(s1 + "." + s2);
                allExtensions.add(s1 + "." + s2);
            }
        }
        for (String s1 : GRIB_EXTENSIONS) {
            gribExtensions.add(s1);
            allExtensions.add(s1);
            for (String s2 : COMPRESSION_EXTENSIONS) {
                gribExtensions.add(s1 + "." + s2);
                allExtensions.add(s1 + "." + s2);
            }
        }
        for (String s1 : HDF_EXTENSIONS) {
            hdfExtensions.add(s1);
            allExtensions.add(s1);
            for (String s2 : COMPRESSION_EXTENSIONS) {
                hdfExtensions.add(s1 + "." + s2);
                allExtensions.add(s1 + "." + s2);
            }
        }
        NC_PLUS_EXTENSIONS = ncExtensions.toArray(new String[0]);
        GEMPAK_PLUS_EXTENSIONS = gempakExtensions.toArray(new String[0]);
        GRIB_PLUS_EXTENSIONS = gribExtensions.toArray(new String[0]);
        HDF_PLUS_EXTENSIONS = hdfExtensions.toArray(new String[0]);
        ALL_PLUS_EXTENSIONS = allExtensions.toArray(new String[0]);
    }

    public static enum FilterType {
        NETCDF,
        GEMPAK,
        GRIB,
        HDF,
        ALL;

    }
}

