/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc;

import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcVarUtils;
import gov.nasa.giss.time.AbsoluteTime;
import gov.nasa.giss.time.JulianTime;
import gov.nasa.giss.time.JulianType;
import gov.nasa.giss.time.PatternTime;
import gov.nasa.giss.time.TimeFormatter;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Variable;

public class NcTimeAxis
extends NcAxis {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private TimeFormatter handler_;

    public NcTimeAxis(NcDataset ncd, Variable dimvar) {
        super(NcAxisType.TIME, ncd, dimvar);
        this.initMe();
    }

    private final void initMe() {
        block16: {
            String unitsStr = this.getUnitsString();
            if (unitsStr == null) {
                return;
            }
            if (unitsStr.contains(" since ")) {
                try {
                    this.handler_ = NcVarUtils.getRelativeTimeHandler(this.dataset_, this.njaxisvar_);
                }
                catch (Exception exc) {
                    this.handler_ = null;
                }
            } else {
                if ("Julian Date".equalsIgnoreCase(unitsStr) || "Julian Day".equalsIgnoreCase(unitsStr) || "True Julian Date".equalsIgnoreCase(unitsStr) || "True Julian Day".equalsIgnoreCase(unitsStr)) {
                    try {
                        this.handler_ = new JulianTime();
                    }
                    catch (Exception exc) {
                        this.handler_ = null;
                        if (LOGGER.isTraceEnabled()) {
                            exc.printStackTrace();
                        }
                        break block16;
                    }
                }
                if ("Modified Julian Date".equalsIgnoreCase(unitsStr) || "Modified Julian Day".equalsIgnoreCase(unitsStr)) {
                    try {
                        this.handler_ = new JulianTime(JulianType.MODIFIED);
                    }
                    catch (Exception exc) {
                        this.handler_ = null;
                        if (LOGGER.isTraceEnabled()) {
                            exc.printStackTrace();
                        }
                        break block16;
                    }
                }
                if (unitsStr.indexOf(" as ") > 0) {
                    try {
                        this.handler_ = new AbsoluteTime(NcVarUtils.getUnitsString(this.njaxisvar_));
                    }
                    catch (Exception exc) {
                        this.handler_ = null;
                        if (!LOGGER.isTraceEnabled()) break block16;
                        exc.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    public boolean isPatternTime() {
        return this.handler_ != null && this.handler_ instanceof PatternTime;
    }

    public boolean isFormattedTime() {
        return this.handler_ != null;
    }

    public TimeFormatter getFormatter() {
        return this.handler_;
    }

    @Override
    public String getUnitsString() {
        return super.getUnitsString();
    }

    public String formatValue(double value) {
        if (this.handler_ == null) {
            return null;
        }
        return this.handler_.format(value);
    }

    public String formattedValueAt(int index) {
        if (this.handler_ == null) {
            return null;
        }
        return this.handler_.format(this.valueAt(index));
    }

    public String[] formattedBoundsAt(int index) {
        if (this.handler_ == null) {
            return new String[]{null, null};
        }
        double[] bounds = this.boundsAt(index);
        return new String[]{this.handler_.format(bounds[0]), this.handler_.format(bounds[1])};
    }

    public String formattedBoundsAt(int index1, int index2) {
        if (this.handler_ == null) {
            return null;
        }
        return this.handler_.format(this.boundsAt(index1, index2));
    }
}

