/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc;

import gov.nasa.giss.data.nc.NcException;
import java.lang.invoke.MethodHandles;
import java.util.Hashtable;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.units.Unit;
import ucar.units.UnitFormat;
import ucar.units.UnitFormatManager;

public final class NcUnitUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final UnitFormat FORMATTER = UnitFormatManager.instance();
    private static boolean altEnabled_;
    private static Hashtable<String, String> alternatives_;

    public static boolean isAltEnabled() {
        return altEnabled_;
    }

    public static void setAltEnabled(boolean enabled) {
        LOGGER.trace("{}", (Object)enabled);
        altEnabled_ = enabled;
    }

    public static Unit parse(String unitsStr) throws NcException {
        String goodUnitStr;
        if (unitsStr == null || unitsStr.isEmpty()) {
            return null;
        }
        if ("nounits".equals(unitsStr.toLowerCase())) {
            return null;
        }
        String xunitsStr = unitsStr;
        if (altEnabled_ && (goodUnitStr = alternatives_.get(unitsStr)) != null) {
            LOGGER.trace("replace {} with {}", (Object)xunitsStr, (Object)goodUnitStr);
            xunitsStr = goodUnitStr;
        }
        try {
            return FORMATTER.parse(xunitsStr);
        }
        catch (Exception exc) {
            LOGGER.debug("Could not parse unit string {}", (Object)xunitsStr);
            throw new NcException(exc.toString());
        }
    }

    public static void addAlternative(String altStr, String forStr) {
        Objects.requireNonNull(altStr, "Alternative units string cannot be null.");
        Objects.requireNonNull(forStr, "UDUNITS compatible string cannot be null.");
        try {
            FORMATTER.parse(forStr);
        }
        catch (Exception exc) {
            throw new NcException(exc.toString());
        }
        LOGGER.trace("{}, {}", (Object)altStr, (Object)forStr);
        alternatives_.put(altStr, forStr);
    }

    public static String removeAlternative(String altStr) {
        return alternatives_.remove(altStr);
    }

    public static boolean isDegreesEast(String unitsStr) {
        if (unitsStr == null || unitsStr.isEmpty()) {
            return false;
        }
        return "degrees_east".equalsIgnoreCase(unitsStr) || "degree_east".equalsIgnoreCase(unitsStr) || "degrees_E".equals(unitsStr) || "degree_E".equals(unitsStr) || "degreesE".equals(unitsStr) || "degreeE".equals(unitsStr) || "deg_east".equalsIgnoreCase(unitsStr) || "deg_e".equalsIgnoreCase(unitsStr);
    }

    public static boolean isDegreesNorth(String unitsStr) {
        if (unitsStr == null || unitsStr.isEmpty()) {
            return false;
        }
        return "degrees_north".equalsIgnoreCase(unitsStr) || "degree_north".equalsIgnoreCase(unitsStr) || "degrees_N".equals(unitsStr) || "degree_N".equals(unitsStr) || "degreesN".equals(unitsStr) || "degreeN".equals(unitsStr) || "deg_north".equalsIgnoreCase(unitsStr) || "deg_n".equalsIgnoreCase(unitsStr);
    }

    public static boolean isDegreesSouth(String unitsStr) {
        if (unitsStr == null || unitsStr.isEmpty()) {
            return false;
        }
        return "degrees_south".equalsIgnoreCase(unitsStr) || "degree_south".equalsIgnoreCase(unitsStr) || "degrees_S".equals(unitsStr) || "degree_S".equals(unitsStr) || "degreesS".equals(unitsStr) || "degreeS".equals(unitsStr) || "deg_south".equalsIgnoreCase(unitsStr) || "deg_S".equalsIgnoreCase(unitsStr);
    }

    private NcUnitUtils() {
    }

    static {
        alternatives_ = new Hashtable(5);
    }
}

