/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array;

import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcStringUtils;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArray2D;
import gov.nasa.giss.data.nc.gridder.NcGridder;
import gov.nasa.giss.data.nc.gridder.NcGridderLatVert;
import gov.nasa.giss.text.PrintfFormat;
import java.util.Objects;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.VariableDS;

public class NcArrayLatVert
extends NcArray2D {
    public NcArrayLatVert(NcVariable ncvar) throws NcException {
        super(ncvar);
        this.setAxes();
        this.measureAxes();
    }

    private final void setAxes() {
        NcDataset ncd = this.getDataset();
        CoordinateAxis x = this.getNjCoordinateAxis(NcAxisType.LAT);
        CoordinateAxis y = this.getNjCoordinateAxis(NcAxisType.VERT);
        if (x == null) {
            VariableDS cv = this.getCoordinateVar(NcAxisType.LAT);
            if (cv != null) {
                this.xAxis_ = new NcAxis(NcAxisType.LAT, ncd, cv);
                this.xDimNum_ = this.findDimensionIndex(cv);
            }
        } else {
            this.xAxis_ = new NcAxis(ncd, x);
            this.xDimNum_ = this.findDimensionIndex(x);
        }
        if (y != null) {
            this.yAxis_ = new NcAxis(this.getDataset(), y);
            this.yDimNum_ = this.findDimensionIndex(y);
        }
        if (this.xAxis_ == null) {
            throw new NcException("Got null retrieving LAT axis coordinate variable");
        }
        if (this.yAxis_ == null) {
            throw new NcException("Got null retrieving VERT axis coordinate variable");
        }
        if (this.xDimNum_ == -1) {
            throw new NcException("Unable to determine din num for LAT axis");
        }
        if (this.yDimNum_ == -1) {
            throw new NcException("Unable to determine din num for VERT axis");
        }
        CoordinateAxis a = this.getNjCoordinateAxis(NcAxisType.LON);
        if (a != null) {
            this.setAveDimIndex(this.findDimensionIndex(a));
        }
    }

    @Override
    public NcGridder getGridder() {
        return new NcGridderLatVert();
    }

    @Override
    public void describeCell(StringBuilder sb, PrintfFormat valFormat, int ... index) {
        Objects.requireNonNull(index, "Cell index cannot be null.");
        int col = index[0];
        int row = index[1];
        if (row < 0 || col < 0) {
            sb.append("Pt apparently outside data bounds");
            return;
        }
        int colDisplay = col + 1;
        int rowDisplay = row + 1;
        double lat = this.getXAxis().valueAt(col);
        double yy = this.getYAxis().valueAt(row);
        double value = this.valueAt(col, row);
        sb.append("Cell [").append(colDisplay).append(", ").append(rowDisplay).append("] at [").append(NcStringUtils.formatLatitude(lat)).append(", ").append(PrintfFormat.PFORMAT_7G.sprintg(yy));
        if (this.getYAxis().getUnitsString() != null) {
            sb.append(' ').append(this.getYAxis().getUnitsString());
        }
        sb.append("], value = ").append(valFormat.sprintf((Object)value));
        if (Double.isNaN(value)) {
            return;
        }
        String unitsStr = this.getUnitsString();
        if (unitsStr != null && !unitsStr.isEmpty() && !unitsStr.equals("1")) {
            sb.append(' ').append(unitsStr);
        }
    }
}

