/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array;

import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcDataGrouping;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcStringUtils;
import gov.nasa.giss.data.nc.NcVarUtils;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArray2D;
import gov.nasa.giss.data.nc.array.NcArrayLonLat;
import gov.nasa.giss.data.nc.array.NcArrayLonLatAuxiliary;
import gov.nasa.giss.data.nc.gridder.NcGridder;
import gov.nasa.giss.data.nc.gridder.NcGridderLonLatAuxiliary;
import gov.nasa.giss.data.nc.gridder.NcGridderUtils;
import gov.nasa.giss.math.PointLL;
import gov.nasa.giss.text.PrintfFormat;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.Index;
import ucar.nc2.Dimension;
import ucar.nc2.dataset.VariableDS;

public class NcArrayLonLatAuxiliary3D
extends NcArray2D
implements NcArrayLonLat,
NcArrayLonLatAuxiliary {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private VariableDS lonVarDS_;
    private VariableDS latVarDS_;
    private Array lonArray_;
    private Array latArray_;
    private Index lonIndex_;
    private Index latIndex_;
    protected int otherDimNum_ = -1;
    protected int otherCoordOffset_;
    private int numXs_;
    private int numYs_;

    public NcArrayLonLatAuxiliary3D(NcVariable ncvar) throws NcException {
        super(ncvar);
        this.setAxes();
        this.measureAxes();
        this.initMe();
        LOGGER.trace("rows {}", (Object)this.getRowCount());
        LOGGER.trace("cols {}", (Object)this.getColumnCount());
    }

    private final void setAxes() {
        VariableDS[] gridvars = NcArrayLonLatAuxiliary.getCoordinateVars(this.dataset_, this.ncvar_.getGrouping(), this.njvarDS_, 3);
        if (gridvars == null) {
            throw new NcException("Got null retrieving LON/LAT coordinate variable(s).");
        }
        this.lonVarDS_ = gridvars[0];
        this.latVarDS_ = gridvars[1];
        int[] gridVarIndices = NcArrayLonLatAuxiliary.getGridVarDimIndices3D(this.dataset_, this.lonVarDS_);
        if (gridVarIndices == null) {
            throw new NcException("Could not isolate the auxiliary grid's 'other' dimension.");
        }
        int yCoordDimNum = Math.min(gridVarIndices[0], gridVarIndices[1]);
        int xCoordDimNum = Math.max(gridVarIndices[0], gridVarIndices[1]);
        int oCoordDimNum = gridVarIndices[2];
        LOGGER.trace("coord y {}, x {}, o {}", yCoordDimNum, xCoordDimNum, oCoordDimNum);
        Dimension ydim = this.lonVarDS_.getDimension(yCoordDimNum);
        Dimension xdim = this.lonVarDS_.getDimension(xCoordDimNum);
        Dimension odim = this.lonVarDS_.getDimension(oCoordDimNum);
        LOGGER.trace("lonVarDS_ {}", (Object)this.lonVarDS_);
        LOGGER.trace("latVarDS_ {}", (Object)this.latVarDS_);
        String yname = ydim.getShortName();
        String xname = xdim.getShortName();
        String oname = odim.getShortName();
        LOGGER.trace("names y {}, x {}, o {}", yname, xname, oname);
        this.xDimNum_ = NcVarUtils.findDimensionIndex(this.njvarDS_, xdim);
        this.yDimNum_ = NcVarUtils.findDimensionIndex(this.njvarDS_, ydim);
        this.otherDimNum_ = NcVarUtils.findDimensionIndex(this.njvarDS_, odim);
        LOGGER.trace("dim x {}, y {}, b {}", this.xDimNum_, this.yDimNum_, this.otherDimNum_);
        if (this.xDimNum_ < 0) {
            throw new NcException("Could not find dimension " + xname);
        }
        if (this.yDimNum_ < 0) {
            throw new NcException("Could not find dimension " + yname);
        }
        if (this.otherDimNum_ < 0) {
            throw new NcException("Could not find other dimension " + oname);
        }
        this.numXs_ = xdim.getLength();
        this.numYs_ = ydim.getLength();
        int numBs = odim.getLength();
        this.xAxis_ = new NcAxis(NcAxisType.GEOX, xname, this.numXs_);
        this.yAxis_ = new NcAxis(NcAxisType.GEOY, yname, this.numYs_);
    }

    private final void initMe() {
        if (this.lonVarDS_ == null) {
            throw new NcException("Auxiliary grid has null lon var");
        }
        if (this.latVarDS_ == null) {
            throw new NcException("Auxiliary grid has null lat var");
        }
        try {
            this.lonArray_ = this.lonVarDS_.read();
            this.lonIndex_ = this.lonArray_.getIndex();
            int vrank = this.lonVarDS_.getRank();
            int arank = this.lonArray_.getRank();
            int irank = this.lonIndex_.getRank();
            if (vrank != 3 || arank != 3 || irank != 3) {
                throw new NcException("Lon coordinates variable/array does not have rank 3.");
            }
        }
        catch (Exception exc) {
            throw new NcException("Could not read lon axis array");
        }
        try {
            this.latArray_ = this.latVarDS_.read();
            this.latIndex_ = this.latArray_.getIndex();
        }
        catch (Exception exc) {
            throw new NcException("Could not read lat axis array");
        }
    }

    @Override
    public void setSliceIndex(int dimNum, int index) {
        if (dimNum == this.otherDimNum_) {
            this.otherCoordOffset_ = index;
        }
        super.setSliceIndex(dimNum, index);
    }

    @Override
    public double longitudeAt(int col, int row) {
        try {
            switch (this.otherDimNum_) {
                case 0: {
                    this.lonIndex_.set(this.otherCoordOffset_, row, col);
                    break;
                }
                case 1: {
                    this.lonIndex_.set(row, this.otherCoordOffset_, col);
                    break;
                }
                default: {
                    this.lonIndex_.set(row, col, this.otherCoordOffset_);
                    break;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException exc) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("lonindex shape {}", (Object)this.lonIndex_.getShape());
                switch (this.otherDimNum_) {
                    case 0: {
                        LOGGER.trace("Requested b {}, row {}, col {}", this.otherCoordOffset_, row, col);
                        break;
                    }
                    case 1: {
                        LOGGER.trace("Requested row {}, b {}, col {}", row, this.otherCoordOffset_, col);
                        break;
                    }
                    default: {
                        LOGGER.trace("Requested row {}, col {}, b", row, col, this.otherCoordOffset_);
                    }
                }
            }
            throw new RuntimeException("Encountered array index out of bounds reading longitude coordinates.");
        }
        catch (Exception exc) {
            throw exc;
        }
        return this.lonArray_.getDouble(this.lonIndex_);
    }

    @Override
    public double latitudeAt(int col, int row) {
        try {
            switch (this.otherDimNum_) {
                case 0: {
                    this.latIndex_.set(this.otherCoordOffset_, row, col);
                    break;
                }
                case 1: {
                    this.latIndex_.set(row, this.otherCoordOffset_, col);
                    break;
                }
                default: {
                    this.latIndex_.set(row, col, this.otherCoordOffset_);
                    break;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException exc) {
            throw new RuntimeException("Encountered array index out of bounds reading latitude coordinates.");
        }
        catch (Exception exc) {
            throw exc;
        }
        double lat = this.latArray_.getDouble(this.latIndex_);
        if (NcArrayLonLat.isBadLatitude(lat)) {
            return Double.NaN;
        }
        return lat;
    }

    public PointLL lonLatAt(int col, int row) {
        if (col < 0 || row < 0 || col >= this.numXs_ || row >= this.numYs_) {
            return null;
        }
        return new PointLL(this.longitudeAt(col, row), this.latitudeAt(col, row));
    }

    @Override
    public boolean doCellsAbut(int col1, int row1, int col2, int row2) {
        double[][] cx1 = this.getCellCornerLonLats(col1, row1);
        if (cx1 == null) {
            return false;
        }
        double[][] cx2 = this.getCellCornerLonLats(col2, row2);
        if (cx2 == null) {
            return false;
        }
        double lon11 = cx1[0][0];
        double lon12 = cx1[1][0];
        double lon13 = cx1[2][0];
        double lon14 = cx1[3][0];
        double lon21 = cx2[0][0];
        double lon22 = cx2[1][0];
        double lon23 = cx2[2][0];
        double lon24 = cx2[3][0];
        if (lon21 - 90.0 > lon11) {
            lon21 -= 360.0;
            lon22 -= 360.0;
            lon23 -= 360.0;
            lon24 -= 360.0;
        } else if (lon11 - 90.0 > lon21) {
            lon21 += 360.0;
            lon22 += 360.0;
            lon23 += 360.0;
            lon24 += 360.0;
        }
        if (Math.abs(lon11 - lon21) > 30.0) {
            return false;
        }
        double lat11 = cx1[0][1];
        double lat12 = cx1[1][1];
        double lat13 = cx1[2][1];
        double lat14 = cx1[3][1];
        double lat21 = cx2[0][1];
        double lat22 = cx2[1][1];
        double lat23 = cx2[2][1];
        double lat24 = cx2[3][1];
        double eps = 0.001 * Math.max(Math.abs(lon11 - 0.25 * (lon11 + lon12 + lon13 + lon14)), Math.abs(lat11 - 0.25 * (lat11 + lat12 + lat13 + lat14)));
        if (NcArrayLonLatAuxiliary3D.dequals(lon11, lon22, eps) && NcArrayLonLatAuxiliary3D.dequals(lat11, lat22, eps) && NcArrayLonLatAuxiliary3D.dequals(lon14, lon23, eps) && NcArrayLonLatAuxiliary3D.dequals(lat14, lat23, eps)) {
            return true;
        }
        if (NcArrayLonLatAuxiliary3D.dequals(lon11, lon24, eps) && NcArrayLonLatAuxiliary3D.dequals(lat11, lat24, eps) && NcArrayLonLatAuxiliary3D.dequals(lon12, lon23, eps) && NcArrayLonLatAuxiliary3D.dequals(lat12, lat23, eps)) {
            return true;
        }
        if (NcArrayLonLatAuxiliary3D.dequals(lon13, lon22, eps) && NcArrayLonLatAuxiliary3D.dequals(lat13, lat22, eps) && NcArrayLonLatAuxiliary3D.dequals(lon14, lon21, eps) && NcArrayLonLatAuxiliary3D.dequals(lat14, lat21, eps)) {
            return true;
        }
        return NcArrayLonLatAuxiliary3D.dequals(lon13, lon24, eps) && NcArrayLonLatAuxiliary3D.dequals(lat13, lat24, eps) && NcArrayLonLatAuxiliary3D.dequals(lon12, lon21, eps) && NcArrayLonLatAuxiliary3D.dequals(lat12, lat21, eps);
    }

    @Override
    public boolean doCellsShareCorner(int col1, int row1, int col2, int row2) {
        double[][] b1 = this.getCellCornerLonLats(col1, row1);
        double[][] b2 = this.getCellCornerLonLats(col2, row2);
        if (b1 == null || b2 == null) {
            return false;
        }
        double tolerance = 0.25 * Math.max(Math.max(Math.abs(b1[0][0] - b1[2][0]), Math.abs(b1[0][1] - b1[2][1])), Math.max(Math.abs(b1[1][0] - b1[2][0]), Math.abs(b1[1][1] - b1[2][1])));
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                double absDiff = Math.abs(b1[i][0] - b2[j][0]);
                if (!(absDiff < tolerance) && !(Math.abs(absDiff - 360.0) < tolerance) || !(Math.abs(b1[i][1] - b2[j][1]) < tolerance)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public double[][] getCellCornerLonLats(int col, int row) {
        double lat00;
        double lon00 = this.longitudeAt(col, row);
        if (NcArrayLonLat.isBadLonLat(lon00, lat00 = this.latitudeAt(col, row))) {
            return null;
        }
        if (lon00 > 180.0) {
            lon00 -= 360.0;
        }
        if (lon00 < -180.0) {
            lon00 += 360.0;
        }
        int i = col;
        int j = row;
        int im1 = Math.max(i - 1, 0);
        int ip1 = Math.min(i + 1, this.numXs_ - 1);
        int jm1 = Math.max(j - 1, 0);
        int jp1 = Math.min(j + 1, this.numYs_ - 1);
        double lonMM = this.longitudeAt(im1, jm1);
        double lon0M = this.longitudeAt(i, jm1);
        double lonPM = this.longitudeAt(ip1, jm1);
        double lonP0 = this.longitudeAt(ip1, j);
        double lonPP = this.longitudeAt(ip1, jp1);
        double lon0P = this.longitudeAt(i, jp1);
        double lonMP = this.longitudeAt(im1, jp1);
        double lonM0 = this.longitudeAt(im1, j);
        double latMM = this.latitudeAt(im1, jm1);
        double lat0M = this.latitudeAt(i, jm1);
        double latPM = this.latitudeAt(ip1, jm1);
        double latP0 = this.latitudeAt(ip1, j);
        double latPP = this.latitudeAt(ip1, jp1);
        double lat0P = this.latitudeAt(i, jp1);
        double latMP = this.latitudeAt(im1, jp1);
        double latM0 = this.latitudeAt(im1, j);
        if (NcArrayLonLat.isBadLonLat(lonM0, latM0)) {
            lonM0 = lon00;
            latM0 = lat00;
        }
        if (NcArrayLonLat.isBadLonLat(lonMM, latMM)) {
            lonMM = lon00;
            latMM = lat00;
        }
        if (NcArrayLonLat.isBadLonLat(lon0M, lat0M)) {
            lon0M = lon00;
            lat0M = lat00;
        }
        if (NcArrayLonLat.isBadLonLat(lonPM, latPM)) {
            lonPM = lon00;
            latPM = lat00;
        }
        if (NcArrayLonLat.isBadLonLat(lonP0, latP0)) {
            lonP0 = lon00;
            latP0 = lat00;
        }
        if (NcArrayLonLat.isBadLonLat(lonPP, latPP)) {
            lonPP = lon00;
            latPP = lat00;
        }
        if (NcArrayLonLat.isBadLonLat(lon0P, lat0P)) {
            lon0P = lon00;
            lat0P = lat00;
        }
        if (NcArrayLonLat.isBadLonLat(lonMP, latMP)) {
            lonMP = lon00;
            latMP = lat00;
        }
        if (lon00 - lonMM > 45.0) {
            lonMM += 360.0;
        }
        if (lon00 - lon0M > 45.0) {
            lon0M += 360.0;
        }
        if (lon00 - lonPM > 45.0) {
            lonPM += 360.0;
        }
        if (lon00 - lonP0 > 45.0) {
            lonP0 += 360.0;
        }
        if (lon00 - lonPP > 45.0) {
            lonPP += 360.0;
        }
        if (lon00 - lon0P > 45.0) {
            lon0P += 360.0;
        }
        if (lon00 - lonMP > 45.0) {
            lonMP += 360.0;
        }
        if (lon00 - lonM0 > 45.0) {
            lonM0 += 360.0;
        }
        if (lonMM - lon00 > 45.0) {
            lonMM -= 360.0;
        }
        if (lon0M - lon00 > 45.0) {
            lon0M -= 360.0;
        }
        if (lonPM - lon00 > 45.0) {
            lonPM -= 360.0;
        }
        if (lonP0 - lon00 > 45.0) {
            lonP0 -= 360.0;
        }
        if (lonPP - lon00 > 45.0) {
            lonPP -= 360.0;
        }
        if (lon0P - lon00 > 45.0) {
            lon0P -= 360.0;
        }
        if (lonMP - lon00 > 45.0) {
            lonMP -= 360.0;
        }
        if (lonM0 - lon00 > 45.0) {
            lonM0 -= 360.0;
        }
        if (lonM0 == lon00 && latM0 == lat00) {
            lonMM = lon0M - (lonPM - lon0M);
            latMM = lat0M - (latPM - lat0M);
            lonM0 = lon00 - (lonP0 - lon00);
            latM0 = lat00 - (latP0 - lat00);
            lonMP = lon0P - (lonPP - lon0P);
            latMP = lat0P - (latPP - lat0P);
        } else if (lonP0 == lon00 && latP0 == lat00) {
            lonPM = lon0M + (lon0M - lonMM);
            latPM = lat0M + (lat0M - latMM);
            lonP0 = lon00 + (lon00 - lonM0);
            latP0 = lat00 + (lat00 - latM0);
            lonPP = lon0P + (lon0P - lonMP);
            latPP = lat0P + (lat0P - latMP);
        }
        if (lon0M == lon00 && lat0M == lat00) {
            lonMM = lonM0 - (lonMP - lonM0);
            latMM = latM0 - (latMP - latM0);
            lon0M = lon00 - (lon0P - lon00);
            lat0M = lat00 - (lat0P - lat00);
            lonPM = lonP0 - (lonPP - lonP0);
            latPM = latP0 - (latPP - latP0);
        } else if (lon0P == lon00 && lat0P == lat00) {
            lonMP = lonM0 + (lonM0 - lonMM);
            latMP = latM0 + (latM0 - latMM);
            lon0P = lon00 + (lon00 - lon0M);
            lat0P = lat00 + (lat00 - lat0M);
            lonPP = lonP0 + (lonP0 - lonPM);
            latPP = latP0 + (latP0 - latPM);
        }
        double[] cornerMM = this.aveFourLL(lon00, lat00, lon0M, lat0M, lonMM, latMM, lonM0, latM0);
        double[] cornerPM = this.aveFourLL(lon00, lat00, lon0M, lat0M, lonPM, latPM, lonP0, latP0);
        double[] cornerPP = this.aveFourLL(lon00, lat00, lon0P, lat0P, lonPP, latPP, lonP0, latP0);
        double[] cornerMP = this.aveFourLL(lon00, lat00, lon0P, lat0P, lonMP, latMP, lonM0, latM0);
        return new double[][]{cornerMM, cornerPM, cornerPP, cornerMP};
    }

    @Override
    public int[] getEnclosingCell(double lon, double lat) {
        double mindist = Double.POSITIVE_INFINITY;
        double cosLat = Math.cos(lat * (Math.PI / 180));
        double sinLat = Math.sin(lat * (Math.PI / 180));
        int col = -1;
        int row = -1;
        for (int i = 0; i < this.numXs_; ++i) {
            for (int j = 0; j < this.numYs_; ++j) {
                double lat1;
                double lon1;
                try {
                    lon1 = this.longitudeAt(i, j);
                    lat1 = this.latitudeAt(i, j);
                }
                catch (Exception exc) {
                    continue;
                }
                if (Double.isNaN(lon1) || Double.isNaN(lat1)) continue;
                double dlon = lon1 - lon;
                double cosLat1 = Math.cos(lat1 * (Math.PI / 180));
                double sinLat1 = Math.sin(lat1 * (Math.PI / 180));
                double cosAngle = cosLat * cosLat1 * Math.cos(dlon * (Math.PI / 180)) + sinLat * sinLat1;
                double angle = Math.acos(cosAngle);
                if (angle == 0.0) {
                    return new int[]{i, j};
                }
                if (!(angle < mindist)) continue;
                mindist = angle;
                col = i;
                row = j;
            }
        }
        if (col < 0) {
            return null;
        }
        LOGGER.trace("lon,lat {},{}", (Object)lon, (Object)lat);
        LOGGER.trace("col,row {},{}", (Object)col, (Object)row);
        double[][] corners = this.getCellCornerLonLats(col, row);
        if (corners == null) {
            return null;
        }
        if (NcGridderUtils.isPointInQuadrilateral(lon, lat, corners[0][0], corners[0][1], corners[1][0], corners[1][1], corners[2][0], corners[2][1], corners[3][0], corners[3][1])) {
            LOGGER.trace("appears to be within quad bound by");
            LOGGER.trace("A {}, {}", (Object)corners[0][0], (Object)corners[0][1]);
            LOGGER.trace("B {}, {}", (Object)corners[1][0], (Object)corners[1][1]);
            LOGGER.trace("C {}, {}", (Object)corners[2][0], (Object)corners[2][1]);
            LOGGER.trace("D {}, {}", (Object)corners[3][0], (Object)corners[3][1]);
            return new int[]{col, row};
        }
        LOGGER.trace("appears to be outside quad");
        return null;
    }

    @Override
    public NcGridder getGridder() {
        return new NcGridderLonLatAuxiliary();
    }

    @Override
    public void describeCell(StringBuilder sb, PrintfFormat valFormat, int ... index) {
        Objects.requireNonNull(index, "Cell index cannot be null.");
        int col = index[0];
        int row = index[1];
        if (col < 0 || row < 0) {
            sb.append("Pt apparently outside data bounds");
            return;
        }
        PointLL ll = this.lonLatAt(col, row);
        double lon = ll.getLon();
        double lat = ll.getLat();
        double gv = this.valueAt(col, row);
        sb.append("Cell [").append(col + 1).append(',').append(row + 1).append(']').append(" at [").append(NcStringUtils.formatLongitude(lon)).append(' ').append(NcStringUtils.formatLatitude(lat)).append("] ").append(", value = ").append(valFormat.sprintf((Object)gv));
        if (Double.isNaN(gv)) {
            return;
        }
        String unitsStr = this.getUnitsString();
        if (unitsStr != null && !unitsStr.isEmpty() && !unitsStr.equals("1")) {
            sb.append(' ').append(unitsStr);
        }
    }

    public static boolean canGridVariable(NcVariable ncvar) {
        NcDataset ncd = ncvar.getDataset();
        NcDataGrouping ncg = ncvar.getGrouping();
        VariableDS varDS = (VariableDS)ncvar.getObject();
        return NcArrayLonLatAuxiliary3D.canGridVariable(ncd, ncg, varDS);
    }

    public static boolean canGridVariable(NcDataset ncd, NcDataGrouping ncg, VariableDS varDS) {
        LOGGER.trace("{}", (Object)varDS.getShortName());
        VariableDS[] gridvars = NcArrayLonLatAuxiliary.getCoordinateVars(ncd, ncg, varDS, 3);
        boolean canGrid = gridvars != null;
        LOGGER.trace("{}", (Object)canGrid);
        return canGrid;
    }
}

