/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array;

import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcStringUtils;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArray2D;
import gov.nasa.giss.data.nc.array.NcArrayLonLat;
import gov.nasa.giss.data.nc.gridder.NcGridder;
import gov.nasa.giss.data.nc.gridder.NcGridderLonLatCartesian;
import gov.nasa.giss.map.LonLatBounds;
import gov.nasa.giss.text.PrintfFormat;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.VariableDS;

public class NcArrayLonLatCartesian
extends NcArray2D
implements NcArrayLonLat {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public NcArrayLonLatCartesian(NcVariable ncvar) throws NcException {
        super(ncvar);
        this.setAxes();
        this.measureAxes();
    }

    private final void setAxes() {
        VariableDS cv;
        NcDataset ncd = this.getDataset();
        CoordinateAxis x = this.getNjCoordinateAxis(NcAxisType.LON);
        CoordinateAxis y = this.getNjCoordinateAxis(NcAxisType.LAT);
        if (x == null) {
            cv = this.getCoordinateVar(NcAxisType.LON);
            if (cv != null) {
                this.xAxis_ = new NcAxis(NcAxisType.LON, ncd, cv);
                this.xDimNum_ = this.findDimensionIndex(cv);
            }
        } else {
            this.xAxis_ = new NcAxis(ncd, x);
            this.xDimNum_ = this.findDimensionIndex(x);
        }
        if (y == null) {
            cv = this.getCoordinateVar(NcAxisType.LAT);
            if (cv != null) {
                this.yAxis_ = new NcAxis(NcAxisType.LAT, ncd, cv);
                this.yDimNum_ = this.findDimensionIndex(cv);
            }
        } else {
            this.yAxis_ = new NcAxis(ncd, y);
            this.yDimNum_ = this.findDimensionIndex(y);
        }
        if (this.xAxis_ == null) {
            throw new NcException("Got null retrieving LON axis coordinate variable");
        }
        if (this.yAxis_ == null) {
            throw new NcException("Got null retrieving LAT axis coordinate variable");
        }
        if (this.xDimNum_ == -1) {
            throw new NcException("Unable to determine dim num for LON axis");
        }
        if (this.yDimNum_ == -1) {
            throw new NcException("Unable to determine dim num for LAT axis");
        }
    }

    @Override
    public NcGridder getGridder() {
        return new NcGridderLonLatCartesian();
    }

    @Override
    public void describeCell(StringBuilder sb, PrintfFormat valFormat, int ... index) {
        Objects.requireNonNull(index, "Cell index cannot be null.");
        int col = index[0];
        int row = index[1];
        if (col < 0 || row < 0) {
            sb.append("Pt apparently outside data bounds");
            return;
        }
        int colDisplay = col + 1;
        int rowDisplay = row + 1;
        double lon = this.xAxis_.valueAt(col);
        double lat = this.yAxis_.valueAt(row);
        double gv = this.valueAt(col, row);
        sb.append("Cell  [").append(colDisplay).append(',').append(rowDisplay).append(']').append(" at [").append(NcStringUtils.formatLongitude(lon)).append(' ').append(NcStringUtils.formatLatitude(lat)).append("], value = ").append(valFormat.sprintf((Object)gv));
        if (Double.isNaN(gv)) {
            return;
        }
        String unitsStr = this.getUnitsString();
        if (unitsStr != null && !unitsStr.isEmpty() && !unitsStr.equals("1")) {
            sb.append(' ').append(unitsStr);
        }
    }

    @Override
    public LonLatBounds getLonLatBounds() {
        double[][] xBounds = this.getXAxis().getBounds();
        double[][] yBounds = this.getYAxis().getBounds();
        double west = Math.min(xBounds[0][0], xBounds[xBounds.length - 1][1]);
        double east = Math.max(xBounds[0][0], xBounds[xBounds.length - 1][1]);
        double north = Math.max(yBounds[0][0], yBounds[yBounds.length - 1][1]);
        double south = Math.min(yBounds[0][0], yBounds[yBounds.length - 1][1]);
        LOGGER.trace("W {}, N {}, E {}, S {}", west, north, east, south);
        return new LonLatBounds(west, north, east, south);
    }
}

