/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array;

import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcStringUtils;
import gov.nasa.giss.data.nc.NcUnitUtils;
import gov.nasa.giss.data.nc.NcVarUtils;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArray2D;
import gov.nasa.giss.data.nc.array.NcArrayLonLat;
import gov.nasa.giss.data.nc.array.NcLonLatProjection;
import gov.nasa.giss.data.nc.gridder.NcGridder;
import gov.nasa.giss.data.nc.gridder.NcGridderLonLatProjected;
import gov.nasa.giss.map.LonLatBounds;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.math.PointLL;
import gov.nasa.giss.text.PrintfFormat;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.VariableDS;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.units.Unit;

public abstract class NcArrayLonLatProjected
extends NcArray2D
implements NcArrayLonLat {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String MAP_VAR_NOT_FOUND_STR = "Grid mapping variable was not found";
    public static final String VAR_HAS_NO_MAP_NAME_STR = "Grid mapping variable has no mapping name";
    protected static final double PI = Math.PI;
    protected static final double PI_OVER_2 = 1.5707963267948966;
    private static final double DEFAULT_RADIUS = 6371.229;
    private final NcLonLatProjection projectionType_;
    protected VariableDS mappingVarDS_;
    protected String mappingName_;
    protected double radius_ = 6371.229;
    protected double semimajor_ = Double.NaN;
    protected double semiminor_ = Double.NaN;
    protected double invFlattening_ = Double.NaN;
    protected double eccentricity_ = Double.NaN;
    protected double oneOverR_ = 1.0 / this.radius_;
    protected double sfactor_ = 1.0;
    protected double rS_;
    protected double oneOverRS_;
    protected double lambdaC_;
    protected double phiC_;
    protected double falseEasting_;
    protected double falseNorthing_;
    protected double lBound_;
    protected double tBound_;
    protected double rBound_;
    protected double bBound_;

    public NcArrayLonLatProjected(NcVariable ncvar, NcLonLatProjection ptype) throws NcException {
        super(ncvar);
        this.projectionType_ = ptype;
        this.setAxes();
        this.measureAxes();
        double[][] xBounds = this.getXAxis().getBounds();
        double[][] yBounds = this.getYAxis().getBounds();
        this.lBound_ = xBounds[0][0];
        this.tBound_ = yBounds[0][0];
        this.rBound_ = xBounds[xBounds.length - 1][1];
        this.bBound_ = yBounds[yBounds.length - 1][1];
    }

    public NcLonLatProjection getProjectType() {
        return this.projectionType_;
    }

    protected String getGridMappingName() {
        this.mappingVarDS_ = NcVarUtils.findGridMappingVariable(this.dataset_, this.njvarDS_);
        if (this.mappingVarDS_ == null) {
            throw new NcException(MAP_VAR_NOT_FOUND_STR);
        }
        this.mappingName_ = NcVarUtils.getGridMappingName(this.mappingVarDS_);
        if (this.mappingName_ == null) {
            throw new NcException(VAR_HAS_NO_MAP_NAME_STR);
        }
        return this.mappingName_;
    }

    protected void initCenter() {
        Attribute lonA = this.mappingVarDS_.findAttribute("longitude_of_projection_origin");
        Attribute latA = this.mappingVarDS_.findAttribute("latitude_of_projection_origin");
        if (lonA == null) {
            lonA = this.mappingVarDS_.findAttribute("straight_vertical_longitude_from_pole");
        }
        if (lonA == null) {
            lonA = this.mappingVarDS_.findAttribute("longitude_of_central_meridian");
        }
        if (lonA != null) {
            this.lambdaC_ = MapUtils.normalizeMP180(lonA.getNumericValue().doubleValue());
        }
        if (latA != null) {
            this.phiC_ = latA.getNumericValue().doubleValue();
        }
        LOGGER.trace("lambdaC {}, phiC {}", (Object)this.lambdaC_, (Object)this.phiC_);
    }

    protected void initRadiusEastingAndNorthing() {
        double d;
        double d2;
        Attribute eastingA = this.mappingVarDS_.findAttribute("false_easting");
        Attribute northingA = this.mappingVarDS_.findAttribute("false_northing");
        if (eastingA != null && !Double.isNaN(d2 = eastingA.getNumericValue().doubleValue())) {
            this.falseEasting_ = d2;
        }
        if (northingA != null && !Double.isNaN(d2 = northingA.getNumericValue().doubleValue())) {
            this.falseNorthing_ = d2;
        }
        LOGGER.trace("easting {}, northing {}", (Object)this.falseEasting_, (Object)this.falseNorthing_);
        Attribute radiusA = this.mappingVarDS_.findAttribute("earth_radius");
        Attribute semimajorA = this.mappingVarDS_.findAttribute("semi_major_axis");
        Attribute semiminorA = this.mappingVarDS_.findAttribute("semi_minor_axis");
        Attribute invFlattenA = this.mappingVarDS_.findAttribute("inverse_flattening");
        if (radiusA != null) {
            LOGGER.trace("Found single-valued earth_radius.");
            d = radiusA.getNumericValue().doubleValue();
            if (!Double.isNaN(d)) {
                this.radius_ = d;
            }
        } else if (semimajorA == null) {
            LOGGER.trace("No radius or semi-major axis defined. Using default.");
            this.radius_ = 6371.229;
        } else if (semiminorA == null && invFlattenA == null) {
            LOGGER.trace("Semi-major axis found, but no semi-minor or flattening.");
            d = semimajorA.getNumericValue().doubleValue();
            if (!Double.isNaN(d)) {
                this.radius_ = d;
            }
        } else {
            double smajor = semimajorA.getNumericValue().doubleValue();
            double sminor = semiminorA != null ? semiminorA.getNumericValue().doubleValue() : Double.NaN;
            double invf = invFlattenA != null ? invFlattenA.getNumericValue().doubleValue() : Double.NaN;
            double fflat = 0.0;
            if (Double.isNaN(sminor)) {
                LOGGER.trace("Calculating semi-minor axis from semi-major axis and from flattening.");
                fflat = 1.0 / invf;
                sminor = smajor * (1.0 - fflat);
            } else if (Double.isNaN(invf)) {
                LOGGER.trace("Calculating inverse flattening from semi-major and semi-minor axes.");
                if (smajor == sminor) {
                    LOGGER.trace("Semi-major and semi-minor axes are same value. Flattening is 0.");
                    fflat = 0.0;
                    invf = 0.0;
                } else {
                    fflat = (smajor - sminor) / smajor;
                    invf = 1.0 / invf;
                }
            } else {
                fflat = 1.0 / invf;
                double xsminor = smajor * (1.0 - fflat);
                if (Math.abs(sminor - xsminor) > 1.0E-7) {
                    LOGGER.trace("Found semi-major and semi-minor axes and flattening, but values are not consistent.");
                    LOGGER.trace("Ignoring the semi-minor axis value.");
                }
                sminor = xsminor;
            }
            double ee = fflat == 0.0 ? 0.0 : Math.sqrt((smajor * smajor - sminor * sminor) / (smajor * smajor));
            LOGGER.trace("smajor {}", (Object)smajor);
            LOGGER.trace("sminor {}", (Object)sminor);
            LOGGER.trace("fflat  {}", (Object)fflat);
            LOGGER.trace("1./f {}", (Object)invf);
            LOGGER.trace("e    {}", (Object)ee);
            this.semimajor_ = smajor;
            this.semiminor_ = sminor;
            this.invFlattening_ = invf;
            this.eccentricity_ = ee;
            this.radius_ = (2.0 * this.semimajor_ + this.semiminor_) / 3.0;
        }
        String radiusUnits = this.radius_ < 10000.0 ? "km" : "m";
        LOGGER.trace("radius {} {}", (Object)this.radius_, (Object)radiusUnits);
        String xUnits = this.xAxis_ != null ? this.xAxis_.getUnitsString() : null;
        LOGGER.trace("xAxis {}", (Object)this.xAxis_);
        if (xUnits == null || xUnits.isEmpty()) {
            LOGGER.trace("False easting variable has null/no units!");
            LOGGER.trace("I will assume radius units need no adjustment.");
        } else {
            try {
                Unit drUnit = NcUnitUtils.parse(radiusUnits);
                Unit feUnit = NcUnitUtils.parse(xUnits);
                LOGGER.trace("r units {}, fe units {}", (Object)drUnit, (Object)feUnit);
                this.radius_ = drUnit.convertTo(this.radius_, feUnit);
                radiusUnits = xUnits;
            }
            catch (Exception drUnit) {
                // empty catch block
            }
        }
        LOGGER.trace("adj radius {} {}", (Object)this.radius_, (Object)radiusUnits);
        this.oneOverR_ = 1.0 / this.radius_;
        Attribute sfactorA = this.mappingVarDS_.findAttribute("scale_factor_at_projection_origin");
        if (sfactorA != null) {
            this.setScalingFactor(sfactorA.getNumericValue().doubleValue());
        } else {
            this.setScalingFactor(1.0);
        }
    }

    protected void setScalingFactor(double sfactor) {
        this.sfactor_ = sfactor;
        this.rS_ = this.radius_ * this.sfactor_;
        LOGGER.trace("S {}; R*S {}", (Object)this.sfactor_, (Object)this.rS_);
        this.oneOverRS_ = 1.0 / this.rS_;
    }

    protected void setAxes() {
        CoordinateAxis x = this.getNjCoordinateAxis(NcAxisType.GEOX);
        CoordinateAxis y = this.getNjCoordinateAxis(NcAxisType.GEOY);
        if (x == null || y == null) {
            LOGGER.trace("GEOX or GEOY axis not found");
            for (int i = 0; i < this.rank_; ++i) {
                Dimension d = this.njvarDS_.getDimension(i);
                String lssname = d.getShortName().toLowerCase();
                String dname = d.getFullName();
                if (dname == null) continue;
                String lcname = dname.toLowerCase();
                VariableDS dimvar = this.getDataset().getNjVariable(dname);
                if (dimvar == null) continue;
                if (lssname.charAt(0) == 'x' || lcname.contains("xdim") || lcname.contains("cols")) {
                    x = this.dataset_.createNjCoordinateAxis(dimvar, AxisType.GeoX);
                    continue;
                }
                if (lssname.charAt(0) == 'y' || lcname.contains("ydim") || lcname.contains("rows")) {
                    y = this.dataset_.createNjCoordinateAxis(dimvar, AxisType.GeoY);
                    continue;
                }
                Attribute standardA = dimvar.findAttribute("standard_name");
                if (standardA == null) continue;
                String lcStandard = standardA.getStringValue().toLowerCase();
                if ("projection_x_coordinate".equals(lcStandard)) {
                    x = this.dataset_.createNjCoordinateAxis(dimvar, AxisType.GeoX);
                    continue;
                }
                if (!"projection_y_coordinate".equals(lcStandard)) continue;
                y = this.dataset_.createNjCoordinateAxis(dimvar, AxisType.GeoY);
            }
        }
        if (x == null || y == null) {
            LOGGER.trace("GEOX or GEOY axis still not found");
        }
        if (x == null) {
            throw new NcException("Got null retrieving GEOX axis coordinate variable");
        }
        if (y == null) {
            throw new NcException("Got null retrieving GEOY axis coordinate variable");
        }
        this.xAxis_ = new NcAxis(this.getDataset(), x);
        this.yAxis_ = new NcAxis(this.getDataset(), y);
        this.xDimNum_ = this.findDimensionIndex(x);
        this.yDimNum_ = this.findDimensionIndex(y);
        if (this.xDimNum_ == -1) {
            throw new NcException("Unable to determine dim num for GEOX axis");
        }
        if (this.yDimNum_ == -1) {
            throw new NcException("Unable to determine dim num for GEOY axis");
        }
    }

    public abstract Point2D.Double transformLL2XY(double var1, double var3);

    public abstract PointLL transformXY2LL(double var1, double var3);

    public double[] getBounds() {
        return new double[]{this.lBound_, this.tBound_, this.rBound_, this.bBound_};
    }

    @Override
    public int[] getEnclosingCell(double lon, double lat) {
        double halfdiff2;
        double diff2;
        double diff1;
        Point2D.Double altXY = this.transformLL2XY(lon, lat);
        double x = altXY.x;
        double y = altXY.y;
        double[] xValues = this.getXAxis().getValues();
        double[] yValues = this.getYAxis().getValues();
        int imax = xValues.length - 1;
        int jmax = yValues.length - 1;
        int col = -1;
        int row = -1;
        if (NcArrayLonLatProjected.isBetween(x, xValues[0], xValues[imax])) {
            for (int i = 0; i < imax; ++i) {
                if (!NcArrayLonLatProjected.isBetween(x, xValues[i], xValues[i + 1])) continue;
                diff1 = Math.abs(x - xValues[i]);
                col = diff1 <= (diff2 = Math.abs(x - xValues[i + 1])) ? i : i + 1;
                break;
            }
        } else {
            double halfdiff1 = 0.5 * (xValues[1] - xValues[0]);
            halfdiff2 = 0.5 * (xValues[imax] - xValues[imax - 1]);
            if (NcArrayLonLatProjected.isBetween(x, xValues[0], xValues[0] - halfdiff1)) {
                col = 0;
            }
            if (NcArrayLonLatProjected.isBetween(x, xValues[imax], xValues[imax] + halfdiff2)) {
                col = imax;
            }
        }
        if (NcArrayLonLatProjected.isBetween(y, yValues[0], yValues[jmax])) {
            for (int j = 0; j < jmax; ++j) {
                if (!NcArrayLonLatProjected.isBetween(y, yValues[j], yValues[j + 1])) continue;
                diff1 = Math.abs(y - yValues[j]);
                row = diff1 <= (diff2 = Math.abs(y - yValues[j + 1])) ? j : j + 1;
                break;
            }
        } else {
            double halfdiff1 = 0.5 * (yValues[1] - yValues[0]);
            halfdiff2 = 0.5 * (yValues[jmax] - yValues[jmax - 1]);
            if (NcArrayLonLatProjected.isBetween(y, yValues[0], yValues[0] - halfdiff1)) {
                row = 0;
            }
            if (NcArrayLonLatProjected.isBetween(y, yValues[jmax], yValues[jmax] + halfdiff2)) {
                row = jmax;
            }
        }
        if (col == -1 || row == -1) {
            return null;
        }
        return new int[]{col, row};
    }

    private static boolean isBetween(double value, double range1, double range2) {
        return value >= range1 && value <= range2 || value <= range1 && value >= range2;
    }

    @Override
    public NcGridder getGridder() {
        return new NcGridderLonLatProjected();
    }

    @Override
    public void describeCell(StringBuilder sb, PrintfFormat valFormat, int ... index) {
        Objects.requireNonNull(index, "Cell index cannot be null.");
        int col = index[0];
        int row = index[1];
        if (col < 0 || row < 0) {
            sb.append("Pt apparently outside data bounds");
            return;
        }
        double x = this.getXAxis().valueAt(col);
        double y = this.getYAxis().valueAt(row);
        PointLL ll2 = this.transformXY2LL(x, y);
        double lon = ll2.getLon();
        double lat = ll2.getLat();
        double gv = this.valueAt(col, row);
        sb.append("Cell ").append('[').append(col + 1).append(',').append(row + 1).append(']').append(" at [").append(NcStringUtils.formatLongitude(lon)).append(' ').append(NcStringUtils.formatLatitude(lat)).append(']').append(" (alt [").append(PrintfFormat.PFORMAT_7G.sprintg(this.getXAxis().valueAt(col))).append(',').append(PrintfFormat.PFORMAT_7G.sprintg(this.getYAxis().valueAt(row))).append("]),");
        sb.append(" value = ").append(valFormat.sprintf((Object)gv));
        if (Double.isNaN(gv)) {
            return;
        }
        String unitsStr = this.getUnitsString();
        if (unitsStr != null && !unitsStr.isEmpty() && !unitsStr.equals("1")) {
            sb.append(' ').append(unitsStr);
        }
    }

    protected static Point2D.Double transformNjLL2XY(ProjectionImpl njproj, double lon, double lat) {
        if (NcArrayLonLat.isBadLatitude(lat)) {
            return null;
        }
        LatLonPointImpl njll = new LatLonPointImpl(lat, lon);
        ProjectionPoint xy = njproj.latLonToProj(njll);
        return new Point2D.Double(xy.getX(), xy.getY());
    }

    protected static PointLL transformNjXY2LL(ProjectionImpl njproj, double x, double y) {
        LatLonPoint njll = njproj.projToLatLon(x, y);
        if (njll == null) {
            return null;
        }
        return new PointLL(njll.getLongitude(), njll.getLatitude());
    }

    @Override
    public LonLatBounds getLonLatBounds() {
        LOGGER.warn("Not yet implemented.");
        return null;
    }
}

