/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array.projected;

import gov.nasa.giss.data.nc.NcAltGridding;
import gov.nasa.giss.data.nc.NcAltGriddingVarType;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcVarType;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArrayLonLat;
import gov.nasa.giss.data.nc.array.NcArrayLonLatProjected;
import gov.nasa.giss.data.nc.array.NcLonLatProjection;
import gov.nasa.giss.map.LonLatBounds;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Attribute;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.Mercator;

public class NcArrayLonLatMercator
extends NcArrayLonLatProjected {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final boolean USE_NJ_PROJ = false;
    private ProjectionImpl njProj_;
    private static final double SMALL_VALUE = 0.001;
    public static final double HALF_PI = 1.5707963267948966;
    private double phi1_;
    private double rS_;
    private double oneOverRS_;
    private double left_;
    private double right_;

    public NcArrayLonLatMercator(NcVariable ncvar) throws NcException {
        super(ncvar, NcLonLatProjection.MERCATOR);
        this.initMe();
    }

    private final void initMe() {
        NcVarType vtype = this.ncvar_.getVarType();
        if (!(vtype instanceof NcAltGriddingVarType)) {
            throw new NcException("Variable is not on a projected grid.");
        }
        if (!((NcAltGriddingVarType)vtype).isGrid(NcAltGridding.MERCATOR)) {
            throw new NcException("Variable is not projected type Mercator.");
        }
        this.initGissProj();
    }

    private final void initUnidataProj() {
        VariableDS njvarDS = (VariableDS)this.ncvar_.getObject();
        List<CoordinateSystem> csList = njvarDS.getCoordinateSystems();
        if (csList.isEmpty()) {
            throw new NcException("No coordinate systems found.");
        }
        CoordinateSystem cs = csList.get(0);
        ProjectionImpl pj = cs.getProjection();
        if (!(pj instanceof Mercator)) {
            throw new NcException("CoordinateSystem returned " + pj.getClass() + " instead of Mercator");
        }
        this.njProj_ = pj;
    }

    private final void initGissProj() {
        this.getGridMappingName();
        if (!this.mappingName_.equalsIgnoreCase("mercator")) {
            throw new NcException("Mapping name is not mercator");
        }
        this.initCenter();
        this.initRadiusEastingAndNorthing();
        Attribute parallelA = this.mappingVarDS_.findAttribute("standard_parallel");
        if (parallelA == null) {
            this.phi1_ = 0.0;
            this.rS_ = this.radius_;
        } else {
            this.phi1_ = parallelA.getNumericValue().doubleValue();
            double phi1Rad = Math.toRadians(this.phi1_);
            this.rS_ = this.radius_ * Math.cos(phi1Rad);
        }
        this.oneOverRS_ = 1.0 / this.rS_;
        double[][] xBounds = this.getXAxis().getBounds();
        double[][] yBounds = this.getYAxis().getBounds();
        this.left_ = xBounds[0][0];
        this.right_ = xBounds[xBounds.length - 1][1];
    }

    @Override
    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (NcArrayLonLat.isBadLatitude(lat)) {
            return null;
        }
        if (90.0 - Math.abs(lat) < 0.001) {
            return new Point2D.Double(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        }
        double dlon = MapUtils.normalizeMP180(lon - this.lambdaC_);
        double lambdaRad = Math.toRadians(dlon);
        double phiRad = Math.toRadians(lat);
        double x = lambdaRad;
        double y = Math.log(Math.tan(0.5 * (1.5707963267948966 + phiRad)));
        x = x * this.rS_ + this.falseEasting_;
        y = y * this.rS_ + this.falseNorthing_;
        if (x < this.left_) {
            x += Math.PI * 2 * this.rS_;
        }
        if (x > this.right_) {
            x -= Math.PI * 2 * this.rS_;
        }
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double x, double y) {
        double xx = x - this.falseEasting_;
        double yy = y - this.falseNorthing_;
        double phiRad = 2.0 * Math.atan(Math.exp(yy * this.oneOverRS_)) - 1.5707963267948966;
        double lambdaRad = xx * this.oneOverRS_;
        return new PointLL(this.lambdaC_ + Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
    }

    @Override
    public LonLatBounds getLonLatBounds() {
        LOGGER.warn("Not yet implemented.");
        return null;
    }
}

