/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array.projected;

import gov.nasa.giss.data.nc.NcAltGridding;
import gov.nasa.giss.data.nc.NcAltGriddingVarType;
import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcUnitUtils;
import gov.nasa.giss.data.nc.NcVarType;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArrayLonLatProjected;
import gov.nasa.giss.data.nc.array.NcLonLatProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.util.List;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.TransverseMercator;
import ucar.unidata.geoloc.projection.proj4.TransverseMercatorProjection;
import ucar.units.Converter;
import ucar.units.Unit;

public class NcArrayLonLatTransverseMercator
extends NcArrayLonLatProjected {
    private ProjectionImpl njProj_;
    private Converter toProjUnits_;
    private Converter fromProjUnits_;

    public NcArrayLonLatTransverseMercator(NcVariable ncvar) throws NcException {
        super(ncvar, NcLonLatProjection.TRANSVERSE_MERCATOR);
        this.initMe();
    }

    private final void initMe() {
        NcVarType vtype = this.ncvar_.getVarType();
        if (!(vtype instanceof NcAltGriddingVarType)) {
            throw new NcException("Variable is not on a projected grid.");
        }
        if (!((NcAltGriddingVarType)vtype).isGrid(NcAltGridding.TRANSVERSE_MERCATOR)) {
            throw new NcException("Variable is not projected type transverse Mercator.");
        }
        this.initUnidataProj();
    }

    private final void initUnidataProj() {
        VariableDS njvarDS = (VariableDS)this.ncvar_.getObject();
        List<CoordinateSystem> csList = njvarDS.getCoordinateSystems();
        if (csList.isEmpty()) {
            throw new NcException("No coordinate systems found.");
        }
        CoordinateSystem cs = csList.get(0);
        ProjectionImpl pj = cs.getProjection();
        if (pj == null) {
            throw new NcException("Got null projection");
        }
        if (!(pj instanceof TransverseMercator) && !(pj instanceof TransverseMercatorProjection)) {
            throw new NcException("CoordinateSystem returned " + pj.getClass() + " instead of TransverseMercator");
        }
        this.njProj_ = pj;
        String xUnits = this.getNjCoordinateAxis(NcAxisType.GEOX).getUnitsString();
        try {
            Unit projUnit = NcUnitUtils.parse("km");
            Unit eastUnit = NcUnitUtils.parse(xUnits);
            this.toProjUnits_ = eastUnit.getConverterTo(projUnit);
            this.fromProjUnits_ = projUnit.getConverterTo(eastUnit);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Point2D.Double transformLL2XY(double lon, double lat) {
        Point2D.Double xy = NcArrayLonLatTransverseMercator.transformNjLL2XY(this.njProj_, lon, lat);
        if (xy == null) {
            return null;
        }
        if (this.fromProjUnits_ != null) {
            xy.x = this.fromProjUnits_.convert(xy.x);
            xy.y = this.fromProjUnits_.convert(xy.y);
        }
        return xy;
    }

    @Override
    public PointLL transformXY2LL(double x, double y) {
        double xx = this.toProjUnits_ == null ? x : this.toProjUnits_.convert(x);
        double yy = this.toProjUnits_ == null ? y : this.toProjUnits_.convert(y);
        return NcArrayLonLatTransverseMercator.transformNjXY2LL(this.njProj_, xx, yy);
    }
}

