/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.gridder;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.array.NcArray2D;
import gov.nasa.giss.data.nc.gridder.NcAxisMethod;
import gov.nasa.giss.data.nc.gridder.NcGridderUtils;
import gov.nasa.giss.data.nc.gridder.NcGridderXY;
import ucar.units.Converter;
import ucar.units.Unit;

public class NcGridderLatVert
extends NcGridderXY {
    @Override
    public void setXAxisMethod(NcAxisMethod method) {
        if (method != NcAxisMethod.SCALAR) {
            throw new UnsupportedOperationException("X axis method not supported for lat-vert gridding.");
        }
    }

    @Override
    public void setXAxisUcarUnits(Unit unit) {
        throw new UnsupportedOperationException("X axis units not supported for lat-vert gridding.");
    }

    @Override
    protected Converter getXAxisUnitsConverter(NcArray2D nca2D) {
        return null;
    }

    @Override
    public void regridInterpolate(NcArray nca, double[] target) {
        this.prepareGridAxes();
        NcArray2D nca2D = (NcArray2D)nca;
        Converter yAxisUnitsConverter = this.getYAxisUnitsConverter(nca2D);
        boolean hasBad = nca2D.hasBadValues();
        NcAxis xAxis = nca2D.getXAxis();
        NcAxis yAxis = nca2D.getYAxis();
        double[] xVals = xAxis.getValues();
        double[] yVals = yAxis.getValues();
        double[][] xBounds = xAxis.getBounds();
        int numXs = xVals.length;
        int numYs = yVals.length;
        int lastY = numYs - 1;
        int lastX = numXs - 1;
        boolean northToSouth = xVals[0] > xVals[1];
        int northX = northToSouth ? 0 : lastX;
        int southX = northToSouth ? lastX : 0;
        double northXVal = xVals[northX];
        double southXVal = xVals[southX];
        double northEdge = northToSouth ? xBounds[0][0] : xBounds[lastX][1];
        double southEdge = northToSouth ? xBounds[lastX][1] : xBounds[0][0];
        double npExtend = northXVal + (northEdge - northXVal) * 1.75;
        double spExtend = southXVal + (southEdge - southXVal) * 1.75;
        int[] srcRow = new int[this.gridHeight_];
        int[] srcCol = new int[this.gridWidth_];
        block0: for (int j = 0; j < this.gridHeight_; ++j) {
            srcRow[j] = -1;
            for (int jj = 0; jj < lastY; ++jj) {
                double ynext;
                double ythis;
                if (this.yaxisMethod_ == NcAxisMethod.INDEX) {
                    ythis = (double)jj + 0.5;
                    ynext = (double)jj + 1.5;
                } else {
                    ythis = yVals[jj];
                    ynext = yVals[jj + 1];
                    if (yAxisUnitsConverter != null) {
                        ythis = yAxisUnitsConverter.convert(ythis);
                        ynext = yAxisUnitsConverter.convert(ynext);
                    }
                    if (this.yaxisMethod_ == NcAxisMethod.LOG10) {
                        if (!(ythis > 0.0)) continue;
                        ythis = Math.log10(ythis);
                        if (!(ynext > 0.0)) continue;
                        ynext = Math.log10(ynext);
                    }
                }
                if (!(this.rowYY_[j] >= ythis && this.rowYY_[j] < ynext) && (!(this.rowYY_[j] <= ythis) || !(this.rowYY_[j] > ynext))) continue;
                srcRow[j] = jj;
                continue block0;
            }
        }
        block2: for (int i = 0; i < this.gridWidth_; ++i) {
            srcCol[i] = -1;
            if (this.colXX_[i] >= northXVal && this.colXX_[i] <= npExtend) {
                srcCol[i] = -9000;
                continue;
            }
            if (this.colXX_[i] <= southXVal && this.colXX_[i] >= spExtend) {
                srcCol[i] = -8000;
                continue;
            }
            for (int ii = 0; ii < numXs - 1; ++ii) {
                if (!(this.colXX_[i] >= xVals[ii] && this.colXX_[i] < xVals[ii + 1]) && (!(this.colXX_[i] <= xVals[ii]) || !(this.colXX_[i] > xVals[ii + 1]))) continue;
                srcCol[i] = ii;
                continue block2;
            }
        }
        for (int j = 0; j < this.gridHeight_; ++j) {
            double ynext;
            double ythis;
            int rowJ = srcRow[j];
            int rowJP1 = srcRow[j] + 1;
            if (rowJ < 0) continue;
            if (this.yaxisMethod_ == NcAxisMethod.INDEX) {
                ythis = (double)rowJ + 0.5;
                ynext = (double)rowJP1 + 0.5;
            } else {
                ythis = yVals[rowJ];
                ynext = yVals[rowJP1];
                if (yAxisUnitsConverter != null) {
                    ythis = yAxisUnitsConverter.convert(ythis);
                    ynext = yAxisUnitsConverter.convert(ynext);
                }
                if (this.yaxisMethod_ == NcAxisMethod.LOG10) {
                    ythis = Math.log10(ythis);
                    ynext = Math.log10(ynext);
                }
            }
            double yPct = (this.rowYY_[j] - ythis) / (ynext - ythis);
            for (int i = 0; i < this.gridWidth_; ++i) {
                double valBR;
                double valBL;
                double valTR;
                double valTL;
                double xPct;
                int colI = srcCol[i];
                int colIP1 = srcCol[i] + 1;
                if (colI >= 0) {
                    xPct = (this.colXX_[i] - xVals[colI]) / (xVals[colIP1] - xVals[colI]);
                    valTL = nca2D.valueAt(colI, rowJ);
                    valTR = nca2D.valueAt(colIP1, rowJ);
                    valBL = nca2D.valueAt(colI, rowJP1);
                    valBR = nca2D.valueAt(colIP1, rowJP1);
                } else if (colI == -9000) {
                    xPct = 0.5;
                    valTR = valTL = nca2D.valueAt(northX, rowJ);
                    valBR = valBL = nca2D.valueAt(northX, rowJP1);
                } else {
                    if (colI != -8000) continue;
                    xPct = 0.5;
                    valTR = valTL = nca2D.valueAt(southX, rowJ);
                    valBR = valBL = nca2D.valueAt(southX, rowJP1);
                }
                if (hasBad) {
                    if (nca2D.isMissingOrInvalid(valTL)) {
                        valTL = Double.NaN;
                    }
                    if (nca2D.isMissingOrInvalid(valTR)) {
                        valTR = Double.NaN;
                    }
                    if (nca2D.isMissingOrInvalid(valBL)) {
                        valBL = Double.NaN;
                    }
                    if (nca2D.isMissingOrInvalid(valBR)) {
                        valBR = Double.NaN;
                    }
                }
                double value = NcGridderUtils.bilinearInterpolate(xPct, yPct, valTL, valTR, valBL, valBR);
                this.setValue(target, i, j, value);
            }
        }
    }
}

