/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map;

import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.text.PrintfFormat;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LonLatBounds {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final LonLatBounds ENTIRE_GLOBE = new LonLatBounds(-180.0, 90.0, 180.0, -90.0);
    private static final PrintfFormat XFORMAT = new PrintfFormat("%.7f");
    private double north_;
    private double south_;
    private double west_;
    private double east_;

    public LonLatBounds(double west, double north, double east, double south) {
        if (west == east && north == south) {
            this.north_ = north;
            if (this.north_ > 90.0) {
                this.north_ = 90.0;
            }
            if (this.south_ < -90.0) {
                this.north_ = -90.0;
            }
            this.south_ = this.north_;
            if (Math.abs(west) > 7200.0) {
                LOGGER.error("unreasonable lon :: west {}", (Object)west);
                throw new IllegalArgumentException("Lons should be specified with reasonable values.");
            }
            this.east_ = this.west_ = MapUtils.normalizeMP180(west);
        }
        if (north < -90.0) {
            throw new IllegalArgumentException("North lat cannot be at south pole.");
        }
        if (south > 90.0) {
            throw new IllegalArgumentException("South lat cannot be at north pole.");
        }
        if (south > north) {
            throw new IllegalArgumentException("South lat must be less than north.");
        }
        this.north_ = north;
        this.south_ = south;
        if (this.north_ > 90.0) {
            this.north_ = 90.0;
        }
        if (this.south_ < -90.0) {
            this.south_ = -90.0;
        }
        if (Math.abs(west) > 7200.0 || Math.abs(east) > 7200.0) {
            LOGGER.error("unreasonable lon :: west {}, east {}", (Object)west, (Object)east);
            throw new IllegalArgumentException("Lons should be specified with reasonable values.");
        }
        double dlon = east - west;
        if (Math.abs(dlon) > 360.0) {
            throw new IllegalArgumentException("East and west lons must be within 360 deg.");
        }
        this.west_ = MapUtils.normalizeMP180(west);
        this.east_ = dlon < 0.0 ? this.west_ + dlon + 360.0 : this.west_ + dlon;
    }

    public double getWest() {
        return this.west_;
    }

    public double getNorth() {
        return this.north_;
    }

    public double getEast() {
        return this.east_;
    }

    public double getSouth() {
        return this.south_;
    }

    public double[] asArray() {
        return new double[]{this.west_, this.north_, this.east_, this.south_};
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("");
        sb.append("[West: ").append(XFORMAT.sprintg(this.west_)).append(", North: ").append(XFORMAT.sprintg(this.north_)).append(", East: ").append(XFORMAT.sprintg(this.east_)).append(", South: ").append(XFORMAT.sprintg(this.south_)).append("]");
        return sb.toString();
    }
}

