/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.landmarks;

import gov.nasa.giss.map.landmarks.Landmark;
import gov.nasa.giss.map.landmarks.LandmarkEvent;
import gov.nasa.giss.map.landmarks.LandmarksListener;
import gov.nasa.giss.util.EasyXmlParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.event.EventListenerList;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LandmarkList
extends ArrayList<Landmark> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LandmarkList.class);
    private static final long serialVersionUID = 181L;
    private double oblate_;
    private Object address_;
    private final EventListenerList listenerList_ = new EventListenerList();

    private LandmarkList() {
    }

    public LandmarkList(File f) throws FileNotFoundException, IOException, JDOMException {
        super(50);
        this.address_ = f;
        this.build();
    }

    public LandmarkList(URL urlBase, String fname) throws IOException, JDOMException, MalformedURLException {
        this(new URL(urlBase, fname));
    }

    public LandmarkList(URL url) throws IOException, JDOMException {
        super(50);
        this.address_ = url;
        this.build();
    }

    public LandmarkList(InputStream istream) throws IOException, JDOMException {
        super(50);
        this.address_ = istream;
        this.build();
    }

    public void reset() throws IOException, JDOMException {
        if (this.address_ instanceof InputStream) {
            throw new IllegalArgumentException("Cannot rebuild from an InputStream.");
        }
        this.clear();
        this.build();
        this.fireLandmarksReset();
    }

    private void build() throws IOException, JDOMException {
        if (this.address_ == null) {
            throw new IllegalArgumentException("Address is null");
        }
        if (this.address_ instanceof File) {
            try (FileInputStream fstream = new FileInputStream((File)this.address_);){
                this.buildFromStream(fstream);
            }
        } else if (this.address_ instanceof URL) {
            try (InputStream istream = ((URL)this.address_).openStream();){
                this.buildFromStream(istream);
            }
        } else if (this.address_ instanceof InputStream) {
            this.buildFromStream((InputStream)this.address_);
        } else {
            throw new IllegalArgumentException("Address is unknown type");
        }
    }

    private void buildFromStream(InputStream istream) throws IOException, JDOMException {
        Document document = EasyXmlParser.parseDocument(istream);
        Element root = document.getRootElement();
        if (!root.getName().equals("landmarklist")) {
            throw new IllegalArgumentException("File root element is not 'landmarklist'.");
        }
        for (Element child : root.getChildren()) {
            Attribute value;
            String childName = child.getName();
            if ("version".equals(childName)) {
                value = child.getAttribute("value");
                if (value == null) continue;
            }
            if (!"oblate".equals(childName) || (value = child.getAttribute("value")) == null) continue;
            try {
                this.oblate_ = value.getDoubleValue();
            }
            catch (Exception exc) {
                throw new IllegalArgumentException("Bad longitude data in oblateness field " + value.getValue());
            }
        }
        for (Element child : root.getChildren()) {
            String childName = child.getName();
            if (!"landmark".equals(childName)) continue;
            try {
                this.add(new Landmark(this, child, this.oblate_));
            }
            catch (Exception exc) {
                LOGGER.warn("Landmark error : {}", (Object)exc.toString());
            }
        }
        this.sortByName();
    }

    public int count() {
        return this.size();
    }

    public void sortByMarked() {
        this.sort((o1, o2) -> o1.compareByMark((Landmark)o2));
        this.fireLandmarksReset();
    }

    public void sortByType() {
        this.sort((o1, o2) -> o1.compareByType((Landmark)o2));
        this.fireLandmarksReset();
    }

    public void sortByCode() {
        this.sort((o1, o2) -> o1.compareByCode((Landmark)o2));
        this.fireLandmarksReset();
    }

    public void sortByName() {
        this.sort((o1, o2) -> o1.compareByName((Landmark)o2));
        this.fireLandmarksReset();
    }

    public void sortByLongitude() {
        this.sort((o1, o2) -> o1.compareByLongitude((Landmark)o2));
        this.fireLandmarksReset();
    }

    public void sortByLatitude() {
        this.sort((o1, o2) -> o1.compareByLatitude((Landmark)o2));
        this.fireLandmarksReset();
    }

    public Landmark findByName(String lname) {
        for (int i = 0; i < this.count(); ++i) {
            Landmark l = (Landmark)this.get(i);
            if (lname.indexOf(l.getName()) <= -1) continue;
            return l;
        }
        return null;
    }

    public Landmark findByCode(String lcode) {
        for (int i = 0; i < this.count(); ++i) {
            Landmark l = (Landmark)this.get(i);
            if (!lcode.equals(l.getCode())) continue;
            return l;
        }
        return null;
    }

    void landmarkChanged(Landmark l) {
        this.fireLandmarkChanged(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLandmarksListener(LandmarksListener l) {
        EventListenerList eventListenerList = this.listenerList_;
        synchronized (eventListenerList) {
            this.listenerList_.add(LandmarksListener.class, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLandmarksListener(LandmarksListener l) {
        EventListenerList eventListenerList = this.listenerList_;
        synchronized (eventListenerList) {
            this.listenerList_.remove(LandmarksListener.class, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LandmarksListener[] getLandmarkListeners() {
        LandmarksListener[] listeners;
        EventListenerList eventListenerList = this.listenerList_;
        synchronized (eventListenerList) {
            listeners = (LandmarksListener[])this.listenerList_.getListeners(LandmarksListener.class);
        }
        return listeners;
    }

    private void fireLandmarkChanged(Landmark landmark) {
        LandmarksListener[] listeners;
        int index = -1;
        for (int i = 0; i < this.count(); ++i) {
            Landmark lx = (Landmark)this.get(i);
            if (lx != landmark) continue;
            index = i;
            break;
        }
        LandmarkEvent e = new LandmarkEvent(this, index, 3);
        for (LandmarksListener l : listeners = this.getLandmarkListeners()) {
            l.landmarkChanged(e);
        }
    }

    private void fireLandmarksReset() {
        LandmarksListener[] listeners;
        LandmarkEvent e = new LandmarkEvent(this, -1, 4);
        for (LandmarksListener l : listeners = this.getLandmarkListeners()) {
            l.landmarkChanged(e);
        }
    }
}

