/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.overlay;

import gov.nasa.giss.map.overlay.OutlineArea;
import gov.nasa.giss.map.overlay.OutlineOverlay;
import gov.nasa.giss.map.overlay.OutlineSegment;
import gov.nasa.giss.math.PointLL;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class GissBOverlay
extends OutlineOverlay {
    public GissBOverlay(File f) throws FileNotFoundException, IOException {
        super(f);
    }

    public GissBOverlay(URL url) throws IOException {
        super(url);
    }

    public GissBOverlay(byte[] bytes, String id) throws IOException {
        super(bytes, id);
    }

    @Override
    protected boolean readHeader(InputStream istream) throws IOException {
        try (DataInputStream dstream = new DataInputStream(istream);){
            byte[] b = new byte[8];
            int bytesRead = dstream.read(b);
            if (bytesRead < 8) {
                boolean bl = false;
                return bl;
            }
            String eight = new String(b);
            if (!"GISSCNOB".equals(eight)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    @Override
    protected void readFullContent(InputStream istream) throws IOException {
        try (DataInputStream dstream = new DataInputStream(istream);){
            byte[] b = new byte[8];
            int bytesRead = dstream.read(b);
            if (bytesRead < 8) {
                throw new IOException("Does not seem to be a CNOB file.");
            }
            String eight = new String(b);
            if (!"GISSCNOB".equals(eight)) {
                throw new IOException("Does not seem to be a CNOB file.");
            }
            this.readMyContent(dstream);
        }
        this.setContentRead();
    }

    private void readMyContent(DataInputStream dstream) throws IOException {
        OutlineArea area = new OutlineArea();
        OutlineSegment segment = new OutlineSegment(OutlineSegment.SegmentType.SHAPES);
        int MAXBYTES = 262144;
        boolean lastReadWasLon = false;
        byte[] bytes = new byte[262144];
        int boffset = 0;
        int lon1000 = 0;
        int lat1000 = 0;
        while (dstream.available() > 0) {
            int bAvail = dstream.available();
            int bTry = Math.min(262144 - boffset, bAvail);
            int bRead = dstream.read(bytes, boffset, bTry);
            bRead += boffset;
            int offset = 0;
            while (offset + 4 <= bRead) {
                byte a = bytes[offset];
                byte b = bytes[offset + 1];
                byte c = bytes[offset + 2];
                byte d = bytes[offset + 3];
                int i = (a & 0xFF) << 24 | (b & 0xFF) << 16 | (c & 0xFF) << 8 | d & 0xFF;
                if (i == 999999) {
                    if (segment.size() > 1) {
                        area.addSegment(segment);
                    }
                    if (area.size() > 0) {
                        this.addArea(area);
                    }
                    area = new OutlineArea();
                    segment = new OutlineSegment(OutlineSegment.SegmentType.SHAPES);
                    lastReadWasLon = false;
                } else if (lastReadWasLon) {
                    lat1000 = i;
                    lastReadWasLon = false;
                    double lon = 0.001 * (double)lon1000;
                    double lat = 0.001 * (double)lat1000;
                    PointLL p = new PointLL(lon, lat);
                    segment.addPoint(p);
                } else {
                    lon1000 = i;
                    lastReadWasLon = true;
                }
                offset += 4;
            }
            boffset = bRead - offset;
            if (boffset <= 0) continue;
            for (int ii = 0; ii < boffset; ++ii) {
                bytes[ii] = bytes[ii + offset];
            }
        }
        if (segment.size() > 1) {
            area.addSegment(segment);
        }
        if (area.size() > 0) {
            this.addArea(area);
        }
    }
}

