/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.overlay;

import gov.nasa.giss.math.PointLL;
import java.util.ArrayList;

public class OutlineSegment {
    protected ArrayList<PointLL> points_;
    private final SegmentType stype_;

    public OutlineSegment(SegmentType stype) {
        this.stype_ = stype;
        this.points_ = new ArrayList(5000);
    }

    public boolean isPoints() {
        return this.stype_ == SegmentType.POINTS;
    }

    public boolean isShapes() {
        return this.stype_ == SegmentType.SHAPES;
    }

    public SegmentType getType() {
        return this.stype_;
    }

    public int size() {
        return this.points_.size();
    }

    void addPoint(PointLL pt) {
        this.points_.add(pt);
    }

    public PointLL getPoint(int index) {
        return this.points_.get(index);
    }

    public PointLL[] getPoints() {
        return this.points_.toArray(new PointLL[0]);
    }

    public static enum SegmentType {
        POINTS,
        SHAPES;

    }
}

