/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.LonLatRotator;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.map.proj.ProjectionUtils;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class AitoffOblique
extends AbstractProjection {
    public static final String PROJECTION_NAME = "Aitoff Oblique";
    public static final int PROPERTIES = 0xA00020;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 1.5707963267948966;
    private LonLatRotator rotMatrices_;
    private ProjDoubleParameter rotateParam_;
    private double thirdRotation_;

    public AitoffOblique(int width, int height) {
        this(width, height, 0, 0);
    }

    public AitoffOblique(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public AitoffOblique(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0xA00020, width, height, xmargin, ymargin, Math.PI, 1.5707963267948966);
        this.rotMatrices_ = new LonLatRotator(this.lambdaC_, this.phiC_);
        this.rotateParam_ = new ProjDoubleParameter("Third (plagal) rotation", "Third rotation", "\u00b0 ", this.thirdRotation_, -360.0, 360.0, true, true);
        this.addParameter(this.rotateParam_);
        this.autoscale();
    }

    @Override
    public void setCenter(double lon, double lat) {
        super.setCenter(lon, lat);
        if (this.rotMatrices_ != null) {
            this.rotMatrices_.setAngles(lon, lat, this.thirdRotation_);
        }
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        super.parameterChanged(e);
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p != null && p != this.rotateParam_) {
            throw new IllegalArgumentException("Unknown parameter");
        }
        this.setXRotation(this.rotateParam_.getValue());
    }

    public void setXRotation(double angle) {
        this.thirdRotation_ = angle;
        this.rotMatrices_.setAngles(this.lambdaC_, this.phiC_, this.thirdRotation_);
        this.autoscale();
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double[] llP = this.rotMatrices_.rotate(lon, lat);
        double halfLambdaPRad = 0.5 * Math.toRadians(llP[0]);
        double phiPRad = Math.toRadians(llP[1]);
        double cosPhiP = Math.cos(phiPRad);
        double cosAlpha = cosPhiP * Math.cos(halfLambdaPRad);
        double alphaRad = Math.acos(cosAlpha);
        if (Math.abs(alphaRad) < 1.0E-5) {
            return new Point2D.Double(this.outCenterX_, this.outCenterY_);
        }
        double sinAlpha = Math.sin(alphaRad);
        double cosBeta = Math.sin(phiPRad) / sinAlpha;
        double sinBeta = cosPhiP * Math.sin(halfLambdaPRad) / sinAlpha;
        double x = 2.0 * alphaRad * sinBeta;
        double y = alphaRad * cosBeta;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double lambdaPRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        if (x == 0.0 && y == 0.0) {
            return new PointLL(this.lambdaC_, this.phiC_);
        }
        double alphaRad = Math.hypot(0.5 * x, y) * this.invRS_;
        double sinPhiP = y * this.invRS_ * Math.sin(alphaRad) / alphaRad;
        double phiPRad = Math.asin(sinPhiP);
        if (Math.abs(phiPRad) > 1.5707963267948966) {
            return null;
        }
        double d = lambdaPRad = phiPRad == 1.5707963267948966 ? 0.0 : 2.0 * Math.acos(Math.cos(alphaRad) / Math.cos(phiPRad));
        if (lambdaPRad > Math.PI) {
            return null;
        }
        if (x < 0.0) {
            lambdaPRad = 0.0 - lambdaPRad;
        }
        double phiP = Math.toDegrees(phiPRad);
        double lambdaP = Math.toDegrees(lambdaPRad);
        double[] ll = this.rotMatrices_.inverse(lambdaP, phiP);
        return new PointLL(ll[0], ll[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        AitoffOblique aitoffOblique = this;
        synchronized (aitoffOblique) {
            block3: for (int iy = 0; iy < this.dyMax_; ++iy) {
                double x;
                double alphaRad;
                double sinPhiP;
                double phiPRad;
                double y = (double)iy + 0.5;
                for (int ix = 0; ix < this.dxMax_ && !(Math.abs(phiPRad = Math.asin(sinPhiP = y * this.invRS_ * Math.sin(alphaRad = Math.hypot(0.5 * (x = (double)ix + 0.5), y) * this.invRS_) / alphaRad)) > 1.5707963267948966); ++ix) {
                    double lambdaPRad;
                    double d = lambdaPRad = phiPRad == 1.5707963267948966 ? 0.0 : 2.0 * Math.acos(Math.cos(alphaRad) / Math.cos(phiPRad));
                    if (lambdaPRad > Math.PI) continue block3;
                    double lambdaP = Math.toDegrees(lambdaPRad);
                    double phiP = Math.toDegrees(phiPRad);
                    double[] llTR = this.rotMatrices_.inverse(lambdaP, phiP);
                    double[] llBR = this.rotMatrices_.inverse(lambdaP, -phiP);
                    double[] llBL = this.rotMatrices_.inverse(-lambdaP, -phiP);
                    double[] llTL = this.rotMatrices_.inverse(-lambdaP, phiP);
                    this.setPoint(ix, iy, llTR[0], llTR[1]);
                    this.setPoint(ix, -iy - 1, llBR[0], llBR[1]);
                    this.setPoint(-ix - 1, -iy - 1, llBL[0], llBL[1]);
                    this.setPoint(-ix - 1, iy, llTL[0], llTL[1]);
                }
            }
        }
    }

    private void setPoint(int ix, int iy, double dlambda, double phi) {
        int srcX;
        int row = this.outCenterY_ - iy - 1;
        int col = this.outCenterX_ + ix;
        if (row < 0 || row >= this.outHeight_ || col < 0 || col >= this.outWidth_) {
            return;
        }
        double lon = dlambda;
        int index = row * this.outWidth_ + col;
        this.invArrayLon_[index] = MapUtils.normalize360(lon);
        this.invArrayLat_[index] = phi;
        int srcY = this.getSrcPixelY(phi);
        if (srcY > -1 && (srcX = this.getSrcPixelX(lon)) > -1) {
            this.invArray_[index] = srcY * this.srcWidth_ + srcX;
        }
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        double absPhiC = Math.abs(this.phiC_);
        if (Math.abs(lat) < 1.0E-5 && absPhiC < 1.0E-5 && (Math.abs(this.thirdRotation_) == 90.0 || Math.abs(this.thirdRotation_) == 270.0)) {
            Point2D.Double p1 = this.transformLL2XYIgnoreMargins(this.lambdaC_ + -89.99999, 0.0);
            Point2D.Double p2 = this.transformLL2XYIgnoreMargins(this.lambdaC_ + 89.99999, 0.0);
            if (p1 != null && p2 != null) {
                GraphicUtils.drawLine(g2d, p1, p2);
            }
        } else {
            super.drawParallel(g2d, lat, label);
        }
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        double absPhiC = Math.abs(this.phiC_);
        if (absPhiC > 89.99999) {
            double rotlon;
            double d = rotlon = this.phiC_ > 0.0 ? MapUtils.normalizeMP180(lon - this.lambdaC_ + this.thirdRotation_) : MapUtils.normalizeMP180(lon - this.lambdaC_ - this.thirdRotation_);
            if (rotlon % 90.0 == 0.0) {
                double phiCC = this.phiC_ > 0.0 ? 89.99999 : -89.99999;
                Point2D.Double p1 = null;
                Point2D.Double p2 = null;
                if (rotlon % 180.0 == 0.0) {
                    p1 = this.transformLL2XYIgnoreMargins(lon, phiCC);
                    p2 = this.transformLL2XYIgnoreMargins(lon, 1.0E-5);
                } else {
                    p1 = this.transformLL2XYIgnoreMargins(lon, phiCC);
                    p2 = this.transformLL2XYIgnoreMargins(lon, -phiCC);
                }
                GraphicUtils.drawLine(g2d, p1, p2);
                return;
            }
        }
        double absLambda = Math.abs(MapUtils.normalizeMP180(lon - this.lambdaC_));
        if (this.thirdRotation_ % 90.0 == 0.0 && absLambda > 179.99999) {
            return;
        }
        if (absLambda < 1.0E-5 && this.thirdRotation_ % 90.0 == 0.0) {
            Point2D.Double p2;
            Point2D.Double p1;
            double modulus360 = MapUtils.normalize360(this.thirdRotation_) % 360.0;
            if (modulus360 == 0.0 || modulus360 == 180.0) {
                if (this.phiC_ == 0.0) {
                    p1 = this.transformLL2XYIgnoreMargins(lon, -89.99999);
                    p2 = this.transformLL2XYIgnoreMargins(lon, 89.99999);
                } else if (this.phiC_ > 0.0) {
                    p1 = this.transformLL2XYIgnoreMargins(lon, -90.0 + this.phiC_ + 1.0E-5);
                    p2 = this.transformLL2XYIgnoreMargins(lon + 180.0, 90.0 - this.phiC_ + 1.0E-5);
                } else {
                    p1 = this.transformLL2XYIgnoreMargins(lon, 90.0 + this.phiC_ + 1.0E-5);
                    p2 = this.transformLL2XYIgnoreMargins(lon + 180.0, -90.0 - this.phiC_ + 1.0E-5);
                }
            } else {
                p1 = this.transformLL2XYIgnoreMargins(lon + 180.0, 0.0 - this.phiC_ + 1.0E-5);
                p2 = this.transformLL2XYIgnoreMargins(lon + 180.0, 0.0 - this.phiC_ - 1.0E-5);
            }
            if (p1 != null && p2 != null) {
                GraphicUtils.drawLine(g2d, p1, p2);
            }
        } else {
            super.drawMeridian(g2d, lon, label);
        }
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        ProjectionUtils.drawEllipse(g2d, this.outCenterX_, this.outCenterY_, this.xmRS_, this.ymRS_);
    }
}

