/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.map.proj.ProjBooleanParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.map.proj.ProjectionUtils;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class Apian2
extends GlobalPseudocylindric {
    public static final String PROJECTION_NAME = "Apian II";
    public static final int PROPERTIES = 0x4000008;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 1.5707963267948966;
    private ProjBooleanParameter globalParam_ = new ProjBooleanParameter("Show full globe rather than hemisphere", "Global", true);

    public Apian2(int width, int height) {
        this(width, height, 0, 0);
    }

    public Apian2(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Apian2(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x4000008, width, height, xmargin, ymargin, Math.PI, 1.5707963267948966);
        this.addParameter(this.globalParam_);
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        super.parameterChanged(e);
        this.setGlobal(this.globalParam_.isSelected());
    }

    public void setGlobal(boolean b) {
        this.global_ = b;
        this.autoscale();
    }

    @Override
    protected void prepareScaling() {
        if (this.global_) {
            this.setSizeFactors(Math.PI, 1.5707963267948966);
        } else {
            this.setSizeFactors(1.5707963267948966, 1.5707963267948966);
        }
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double absLambdaRad = Math.abs(lambdaRad);
        if (absLambdaRad > Math.PI || !this.global_ && absLambdaRad > 1.5707963267948966) {
            return null;
        }
        double phiRad = Math.toRadians(lat);
        double x = 0.3183098861837907 * lambdaRad * Math.sqrt(Math.PI * Math.PI - 4.0 * phiRad * phiRad);
        double y = phiRad;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double phiRad = y * this.invRS_;
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = x * Math.PI * this.invRS_ / Math.sqrt(Math.PI * Math.PI - 4.0 * phiRad * phiRad);
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        if (!this.global_ && Math.abs(lambdaRad) > 1.5707963267948966) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Apian2 apian2 = this;
        synchronized (apian2) {
            double y;
            double phiRad;
            for (int iy = 0; iy < this.dyMax_ && !((phiRad = (y = (double)iy + 0.5) * this.invRS_) > 1.5707963267948966); ++iy) {
                double x;
                double lambdaRad;
                double phi = Math.toDegrees(phiRad);
                double xFactor = Math.PI * this.invRS_ / Math.sqrt(Math.PI * Math.PI - 4.0 * phiRad * phiRad);
                for (int ix = 0; !(ix >= this.dxMax_ || (lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI || !this.global_ && lambdaRad > 1.5707963267948966); ++ix) {
                    this.set4SymmetricPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        ProjectionUtils.drawEllipse(g2d, this.outCenterX_, this.outCenterY_, this.xmRS_, this.ymRS_);
    }
}

