/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class CantersPseudocylindricW15
extends GlobalPseudocylindric {
    public static final String PROJECTION_NAME = "Canters Pseudocylindric W15";
    private static final double C10 = 0.792;
    private static final double C12 = -0.0978;
    private static final double C14 = 0.0059;
    private static final double CP01 = 1.0304;
    private static final double CP03 = 0.0127;
    private static final double CP05 = -0.025;
    private static final double THREE_CP03 = 0.038099999999999995;
    private static final double FIVE_CP05 = -0.125;
    private static final double WIDTH_FACTOR = 2.4881413816431164;
    private static final double HEIGHT_FACTOR = 1.4286931206209363;

    public CantersPseudocylindricW15(int width, int height) {
        this(width, height, 0, 0);
    }

    public CantersPseudocylindricW15(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public CantersPseudocylindricW15(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, 2.4881413816431164, 1.4286931206209363);
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        double phiRad2 = phiRad * phiRad;
        double x = lambdaRad * (0.792 + phiRad2 * (-0.0978 + phiRad2 * 0.0059));
        double y = phiRad * (1.0304 + phiRad2 * (0.0127 + phiRad2 * -0.025));
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        if (Math.abs(y) > this.ymRS_) {
            return null;
        }
        double yOverRS = y * this.invRS_;
        double phiRad = 1.5707963267948966 * y / this.ymRS_;
        for (int iter = 0; iter < 33; ++iter) {
            double phiRad2 = phiRad * phiRad;
            double func = phiRad * (1.0304 + phiRad2 * (0.0127 + phiRad2 * -0.025)) - yOverRS;
            double dfunc = 1.0304 + phiRad2 * (0.038099999999999995 + phiRad2 * -0.125);
            double dphiRad = -func / dfunc;
            phiRad += dphiRad;
            if (Math.abs(dphiRad) < 1.0E-5) break;
        }
        if (phiRad > 1.5707963267948966) {
            return null;
        }
        double phiRad2 = phiRad * phiRad;
        double xFactor = this.invRS_ / (0.792 + phiRad2 * (-0.0978 + phiRad2 * 0.0059));
        double lambdaRad = x * xFactor;
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        CantersPseudocylindricW15 cantersPseudocylindricW15 = this;
        synchronized (cantersPseudocylindricW15) {
            double y;
            double phiRad = 0.0;
            for (int iy = 0; iy < this.dyMax_ && !((y = (double)iy + 0.5) > this.ymRS_); ++iy) {
                double x;
                double lambdaRad;
                double phiRad2;
                double yOverRS = y * this.invRS_;
                phiRad += 1.0E-5;
                for (int iter = 0; iter < 33; ++iter) {
                    phiRad2 = phiRad * phiRad;
                    double func = phiRad * (1.0304 + phiRad2 * (0.0127 + phiRad2 * -0.025)) - yOverRS;
                    double dfunc = 1.0304 + phiRad2 * (0.038099999999999995 + phiRad2 * -0.125);
                    double dphiRad = -func / dfunc;
                    phiRad += dphiRad;
                    if (Math.abs(dphiRad) < 1.0E-5) break;
                }
                if (phiRad > 1.5707963267948966) break;
                double phi = Math.toDegrees(phiRad);
                phiRad2 = phiRad * phiRad;
                double xFactor = this.invRS_ / (0.792 + phiRad2 * (-0.0978 + phiRad2 * 0.0059));
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                    this.set4SymmetricPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }
}

