/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.QuadSymmetricProjection;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConcavePoleProjection
extends QuadSymmetricProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public ConcavePoleProjection(String name, int properties, int width, int height, int xmargin, int ymargin, double widthFactor, double heightFactor) {
        super(name, properties, width, height, xmargin, ymargin, widthFactor, heightFactor);
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        Bezier[] curves = this.makeOuterBezier();
        if (curves != null) {
            if (curves[0] != null) {
                curves[0].draw(g2d);
            }
            if (curves[1] != null) {
                curves[1].draw(g2d);
            }
        }
        if ((curves = this.makePoleBezier()) != null) {
            if (curves[0] != null) {
                curves[0].draw(g2d);
            }
            if (curves[1] != null) {
                curves[1].draw(g2d);
            }
        }
    }

    protected Bezier[] makeOuterBezier() {
        double edgeLon = this.lambdaC_ + 179.99999;
        int np = 105;
        double fact = 0.8571428571428571;
        Point2D.Double[] dotsE = new Point2D.Double[211];
        Point2D.Double[] dotsW = new Point2D.Double[211];
        for (int j = 0; j <= 105; ++j) {
            double jj = 0.8571428571428571 * (double)j;
            Point2D.Double dot = this.transformLL2XY(edgeLon, jj);
            if (dot == null) {
                LOGGER.warn("Null outer border point");
                return null;
            }
            dotsE[105 - j] = new Point2D.Double(dot.x, dot.y);
            dotsE[105 + j] = new Point2D.Double(dot.x, 2.0 * (double)this.outCenterY_ - dot.y);
            dotsW[105 - j] = new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, dot.y);
            dotsW[105 + j] = new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, 2.0 * (double)this.outCenterY_ - dot.y);
        }
        Bezier[] curves = new Bezier[]{new Bezier(false, dotsE), new Bezier(false, dotsW)};
        return curves;
    }

    protected Bezier[] makePoleBezier() {
        int np = 45;
        double npfact = 4.0;
        Point2D.Double[] dotsN = new Point2D.Double[91];
        Point2D.Double[] dotsS = new Point2D.Double[91];
        for (int i = 0; i <= 45; ++i) {
            Point2D.Double dot;
            double ii = 4.0 * (double)i;
            if (i == 45) {
                ii -= 0.1;
            }
            if ((dot = this.transformLL2XY(this.lambdaC_ + ii, 90.0)) == null) {
                LOGGER.warn("Null pole border point");
                return null;
            }
            dotsN[45 - i] = new Point2D.Double(dot.x, dot.y);
            dotsN[45 + i] = new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, dot.y);
            dotsS[45 - i] = new Point2D.Double(dot.x, 2.0 * (double)this.outCenterY_ - dot.y);
            dotsS[45 + i] = new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, 2.0 * (double)this.outCenterY_ - dot.y);
        }
        Bezier[] curves = new Bezier[]{new Bezier(false, dotsN), new Bezier(false, dotsS)};
        return curves;
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        double absLambda = Math.abs(MapUtils.normalizeMP180(lon - this.lambdaC_));
        if (absLambda > 179.99999) {
            return;
        }
        super.drawMeridian(g2d, lon, label);
    }
}

