/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.LonLatBounds;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.BiSymmetricProjection;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.math.PointLL;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConicProjection
extends BiSymmetricProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final int PROPERTIES = 0x200010;
    protected static final double DEFAULT_PHI1 = 60.0;
    protected static final double DEFAULT_PHI2 = 30.0;
    protected static final double DEFAULT_HEIGHT = Math.abs(30.0);
    protected double phi1_ = 60.0;
    protected double phi2_ = 30.0;
    protected double phiHeight_ = 1.5 * Math.abs(30.0);
    private double lMargin_;
    private double rMargin_;
    private double tMargin_;
    private double bMargin_;
    private Point2D.Double coneTip_ = new Point2D.Double();
    private double coneOrientation_;
    private final Arc2D.Double arc_ = new Arc2D.Double();
    private final Line2D.Double line_ = new Line2D.Double();
    private final Rectangle2D.Double mapRect_ = new Rectangle2D.Double();
    private ProjDoubleParameter phi1Param_ = new ProjDoubleParameter("Latitude of first standard parallel", "Std. Par. 1", "\u00b0N", 60.0, -90.0, 90.0, true, true);
    private ProjDoubleParameter phi2Param_ = new ProjDoubleParameter("Latitude of second standard parallel", "Std. Par. 2", "\u00b0N", 30.0, -90.0, 90.0, true, true);
    private ProjDoubleParameter hghtParam_ = new ProjDoubleParameter("Angular distance between top and bottom center of map", "Height", "\u00b0", DEFAULT_HEIGHT, 0.002, 180.0, true, true);

    public ConicProjection(String name, int properties, int width, int height, int xmargin, int ymargin, double widthFactor, double heightFactor) {
        super(name, properties, width, height, xmargin, ymargin, widthFactor, heightFactor);
        this.addParameter(this.phi1Param_);
        this.addParameter(this.phi2Param_);
        this.addParameter(this.hghtParam_);
        this.autoscale();
    }

    public ProjDoubleParameter getHeightParameter() {
        return this.hghtParam_;
    }

    @Override
    public void setCenter(double lon, double lat) {
        super.setCenter(lon, lat);
        this.autoscale();
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null) {
            this.setStandardParallels(this.phi1Param_.getValue(), this.phi2Param_.getValue());
            this.setHeight(this.hghtParam_.getValue());
        } else if (p == this.phi1Param_ || p == this.phi2Param_) {
            this.setStandardParallels(this.phi1Param_.getValue(), this.phi2Param_.getValue());
        } else if (p == this.hghtParam_) {
            this.setHeight(this.hghtParam_.getValue());
        } else {
            LOGGER.trace("Param not handled by ConicProjection");
        }
    }

    public void setStandardParallels(double lat1, double lat2) {
        this.phi1_ = lat1;
        this.phi2_ = lat2;
        if (Math.abs(this.phi2_) > Math.abs(this.phi1_)) {
            double phiTemp = this.phi1_;
            this.phi1_ = this.phi2_;
            this.phi2_ = phiTemp;
        } else if (this.phi1_ + this.phi2_ == 0.0) {
            this.phi2_ *= 0.9999;
        }
        this.autoscale();
    }

    public void setHeight(double h) {
        this.phiHeight_ = h;
        this.autoscale();
    }

    private void setRect() {
        Insets ins = this.getInsets();
        this.lMargin_ = ins.left;
        this.rMargin_ = this.outWidth_ - ins.left;
        this.tMargin_ = ins.top;
        this.bMargin_ = this.outHeight_ - ins.top;
        this.mapRect_.setFrameFromDiagonal(this.lMargin_, this.tMargin_, this.rMargin_, this.bMargin_);
    }

    @Override
    protected final void finishScaling() {
        this.findConeTip();
        this.findConeOrientation();
    }

    @Override
    public void drawGrid(Graphics2D g2d, BasicStroke stroke, Color color) {
        if (this.coneOrientation_ == 0.0) {
            return;
        }
        this.setRect();
        super.drawGrid(g2d, stroke, color);
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        this.drawParallelX(g2d, lat);
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        double absLambda = Math.abs(MapUtils.normalizeMP180(lon - this.lambdaC_));
        if (absLambda > 179.99999) {
            return;
        }
        this.drawMeridianX(g2d, lon);
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        if (this.coneOrientation_ == 0.0) {
            return;
        }
        this.setRect();
        ArrayList<Point2D.Double> clip1 = this.drawParallelX(g2d, 90.0);
        ArrayList<Point2D.Double> clip2 = this.drawParallelX(g2d, -90.0);
        this.drawMeridianX(g2d, this.lambdaC_ + 179.99999);
        ArrayList<Point2D.Double> clip3 = this.drawMeridianX(g2d, this.lambdaC_ - 179.995);
        ArrayList<Point2D.Double> clipPts = new ArrayList<Point2D.Double>(24);
        if (clip1 != null) {
            clipPts.addAll(clip1);
        }
        if (clip2 != null) {
            clipPts.addAll(clip2);
        }
        if (clip3 != null) {
            clipPts.addAll(clip3);
        }
        for (int jj = 0; jj < 2; ++jj) {
            double ymargin = jj == 0 ? this.tMargin_ : this.bMargin_;
            Point2D.Double pt1 = null;
            Point2D.Double pt2 = null;
            PointLL ll = this.transformXY2LL(this.lMargin_, ymargin);
            if (ll != null) {
                pt1 = new Point2D.Double(this.lMargin_, ymargin);
            }
            for (int i = clipPts.size() - 1; i >= 0; --i) {
                Point2D.Double pt = (Point2D.Double)clipPts.get(i);
                if (pt.y != ymargin) continue;
                if (pt1 == null) {
                    pt1 = pt;
                    clipPts.remove(i);
                    continue;
                }
                pt2 = pt;
                clipPts.remove(i);
                break;
            }
            if (pt1 != null && pt2 != null) {
                this.line_.setLine(pt1, pt2);
                g2d.draw(this.line_);
                pt1.x = (double)this.outCenterX_ + ((double)this.outCenterX_ - pt1.x);
                pt2.x = (double)this.outCenterX_ + ((double)this.outCenterX_ - pt2.x);
                this.line_.setLine(pt1, pt2);
                g2d.draw(this.line_);
                continue;
            }
            if (pt1 == null) continue;
            pt2 = new Point2D.Double((double)this.outCenterX_ + ((double)this.outCenterX_ - pt1.x), pt1.y);
            this.line_.setLine(pt1, pt2);
            g2d.draw(this.line_);
        }
        Point2D.Double pt1 = null;
        Point2D.Double pt2 = null;
        PointLL ll = this.transformXY2LL(this.lMargin_, this.tMargin_);
        if (ll != null) {
            pt1 = new Point2D.Double(this.lMargin_, this.tMargin_);
        }
        for (int i = clipPts.size() - 1; i >= 0; --i) {
            Point2D.Double pt = (Point2D.Double)clipPts.get(i);
            if (pt1 != null) {
                pt2 = pt;
                clipPts.remove(i);
                break;
            }
            pt1 = pt;
            clipPts.remove(i);
        }
        if (pt1 != null && pt2 != null) {
            this.line_.setLine(pt1, pt2);
            g2d.draw(this.line_);
            pt1.x = this.rMargin_;
            pt2.x = this.rMargin_;
            this.line_.setLine(pt1, pt2);
            g2d.draw(this.line_);
        } else if (pt1 != null) {
            pt2 = new Point2D.Double(this.lMargin_, this.bMargin_);
            this.line_.setLine(pt1, pt2);
            g2d.draw(this.line_);
            pt1.x = this.rMargin_;
            pt2.x = this.rMargin_;
            this.line_.setLine(pt1, pt2);
            g2d.draw(this.line_);
        }
    }

    private ArrayList<Point2D.Double> drawMeridianX(Graphics2D g2d, double lon) {
        Point2D.Double np = this.transformLL2XYIgnoreMargins(lon, 90.0);
        Point2D.Double sp = this.transformLL2XYIgnoreMargins(lon, -90.0);
        if (np == null) {
            np = this.transformLL2XYIgnoreMargins(lon, 89.99999);
        }
        if (sp == null) {
            sp = this.transformLL2XYIgnoreMargins(lon, -89.99999);
        }
        if (np == null || sp == null) {
            return null;
        }
        this.line_.setLine(np, sp);
        if (!this.line_.intersects(this.mapRect_)) {
            return null;
        }
        ArrayList<Point2D.Double> clipPts = new ArrayList<Point2D.Double>(12);
        Point2D.Double[] pts = new Point2D.Double[]{np, sp};
        double dx = pts[1].x - pts[0].x;
        if (dx == 0.0) {
            for (int k = 0; k < 2; ++k) {
                if (pts[k].y < this.tMargin_) {
                    pts[k].y = this.tMargin_;
                    clipPts.add(new Point2D.Double(pts[k].x, pts[k].y));
                }
                if (!(pts[k].y > this.bMargin_)) continue;
                pts[k].y = this.bMargin_;
                clipPts.add(new Point2D.Double(pts[k].x, pts[k].y));
            }
        } else {
            double dy = pts[1].y - pts[0].y;
            double slope = dy / dx;
            for (int k = 0; k < 2; ++k) {
                double dyy;
                double dxx;
                if (pts[k].x < this.lMargin_) {
                    dxx = this.lMargin_ - pts[k].x;
                    pts[k].x = this.lMargin_;
                    pts[k].y += slope * dxx;
                    clipPts.add(new Point2D.Double(pts[k].x, pts[k].y));
                } else if (pts[k].x > this.rMargin_) {
                    dxx = this.rMargin_ - pts[k].x;
                    pts[k].x = this.rMargin_;
                    pts[k].y += slope * dxx;
                    clipPts.add(new Point2D.Double(pts[k].x, pts[k].y));
                }
                if (pts[k].y < this.tMargin_) {
                    dyy = this.tMargin_ - pts[k].y;
                    pts[k].x += dyy / slope;
                    pts[k].y = this.tMargin_;
                    clipPts.add(new Point2D.Double(pts[k].x, pts[k].y));
                    continue;
                }
                if (!(pts[k].y > this.bMargin_)) continue;
                dyy = this.bMargin_ - pts[k].y;
                pts[k].x += dyy / slope;
                pts[k].y = this.bMargin_;
                clipPts.add(new Point2D.Double(pts[k].x, pts[k].y));
            }
        }
        if (Math.abs(pts[1].x - pts[0].x) < 1.0E-5 && Math.abs(pts[1].y - pts[0].y) < 1.0E-5) {
            return null;
        }
        this.line_.setLine(pts[0], pts[1]);
        g2d.draw(this.line_);
        for (int i = clipPts.size() - 1; i >= 0; --i) {
            Point2D.Double pt2 = clipPts.get(i);
            if (!(pt2.x < this.lMargin_) && !(pt2.y < this.tMargin_) && !(pt2.y > this.bMargin_)) continue;
            clipPts.remove(i);
        }
        return clipPts;
    }

    private ArrayList<Point2D.Double> drawParallelX(Graphics2D g2d, double lat) {
        Point2D.Double pt2;
        double dxx;
        double dyy;
        double baseRotate;
        Point2D.Double pt = this.transformLL2XYIgnoreMargins(this.lambdaC_, lat);
        if (pt == null) {
            return null;
        }
        double radius = Math.abs(pt.y - this.coneTip_.y);
        if (radius < 1.0E-5) {
            return null;
        }
        Point2D.Double coneTipZ = new Point2D.Double(this.coneTip_.x, this.coneTip_.y);
        if (this.coneOrientation_ < 0.0) {
            coneTipZ.y = (double)this.outCenterY_ + ((double)this.outCenterY_ - coneTipZ.y);
        }
        if (coneTipZ.y + radius <= this.tMargin_) {
            return null;
        }
        double dx = coneTipZ.x - this.lMargin_;
        double dyb = this.bMargin_ - coneTipZ.y;
        double dx2 = dx * dx;
        double dyb2 = dyb * dyb;
        double radius2 = radius * radius;
        if (coneTipZ.y <= this.tMargin_ && radius2 > dx2 + dyb2) {
            return null;
        }
        pt = this.transformLL2XYIgnoreMargins(this.lambdaC_ - 180.0, lat);
        if (this.coneOrientation_ < 0.0) {
            pt.y = (double)this.outCenterY_ + ((double)this.outCenterY_ - pt.y);
        }
        if (pt.y > this.bMargin_) {
            return null;
        }
        ArrayList<Point2D.Double> clipPts = new ArrayList<Point2D.Double>(12);
        double dyt = this.tMargin_ - coneTipZ.y;
        double dyt2 = dyt * dyt;
        if (pt.y < this.tMargin_) {
            double dxx2 = Math.sqrt(radius2 - dyt2);
            pt.x = coneTipZ.x - dxx2;
            pt.y = this.tMargin_;
            clipPts.add(new Point2D.Double(pt.x, pt.y));
        }
        if (pt.y < coneTipZ.y && pt.x <= this.lMargin_) {
            pt.x = coneTipZ.x - radius;
            pt.y = coneTipZ.y;
            clipPts.add(new Point2D.Double(pt.x, pt.y));
        }
        double startAngle = 180.0;
        double d = baseRotate = this.coneOrientation_ < 0.0 ? 90.0 : 270.0;
        if (pt.y >= coneTipZ.y) {
            if (radius2 > dx2 + dyb2) {
                return null;
            }
            if (pt.x < this.lMargin_) {
                dyy = Math.sqrt(radius2 - dx2);
                pt.x = this.lMargin_;
                pt.y = coneTipZ.y + dyy;
                clipPts.add(new Point2D.Double(pt.x, pt.y));
                startAngle = Math.toDegrees(Math.asin(dx / radius));
            } else {
                dxx = coneTipZ.x - pt.x;
                startAngle = Math.toDegrees(Math.asin(dxx / radius));
            }
        } else {
            startAngle = 180.0 - Math.toDegrees(Math.asin((coneTipZ.x - pt.x) / radius));
            if (coneTipZ.x - radius < this.lMargin_) {
                dyy = Math.sqrt(radius2 - dx2);
                double anAngle = Math.toDegrees(Math.asin(dx / radius));
                double breakAngle = 180.0 - anAngle;
                this.arc_.setArcByCenter(this.coneTip_.x, this.coneTip_.y, radius, baseRotate - startAngle, startAngle - breakAngle, 0);
                g2d.draw(this.arc_);
                this.arc_.setArcByCenter(this.coneTip_.x, this.coneTip_.y, radius, baseRotate + breakAngle, startAngle - breakAngle, 0);
                g2d.draw(this.arc_);
                pt.x = this.lMargin_;
                pt.y = coneTipZ.y - dyy;
                clipPts.add(new Point2D.Double(pt.x, pt.y));
                pt.x = this.lMargin_;
                pt.y = coneTipZ.y + dyy;
                clipPts.add(new Point2D.Double(pt.x, pt.y));
                startAngle = anAngle;
            }
        }
        if (pt.y < this.bMargin_) {
            if (dyb < radius) {
                dxx = Math.sqrt(radius2 - dyb2);
                pt.x = coneTipZ.x - dxx;
                pt.y = this.bMargin_;
                clipPts.add(new Point2D.Double(pt.x, pt.y));
                double breakAngle = Math.toDegrees(Math.acos(dyb / radius));
                this.arc_.setArcByCenter(this.coneTip_.x, this.coneTip_.y, radius, baseRotate - startAngle, startAngle - breakAngle, 0);
                g2d.draw(this.arc_);
                this.arc_.setArcByCenter(this.coneTip_.x, this.coneTip_.y, radius, baseRotate + breakAngle, startAngle - breakAngle, 0);
                g2d.draw(this.arc_);
            } else {
                this.arc_.setArcByCenter(this.coneTip_.x, this.coneTip_.y, radius, baseRotate - startAngle, 2.0 * startAngle, 0);
                g2d.draw(this.arc_);
            }
        }
        if (this.coneOrientation_ < 0.0) {
            for (int i = clipPts.size() - 1; i >= 0; --i) {
                pt2 = clipPts.get(i);
                clipPts.remove(i);
                pt2.y = (double)this.outCenterY_ + ((double)this.outCenterY_ - pt2.y);
                clipPts.add(i, pt2);
            }
        }
        for (int i = clipPts.size() - 1; i >= 0; --i) {
            pt2 = clipPts.get(i);
            if (!(pt2.x < this.lMargin_) && !(pt2.y < this.tMargin_) && !(pt2.y > this.bMargin_)) continue;
            clipPts.remove(i);
        }
        return clipPts;
    }

    private void findConeOrientation() {
        double phiSum = this.phi1_ + this.phi2_;
        this.coneOrientation_ = phiSum > 0.0 ? 90.0 : (phiSum < 0.0 ? -90.0 : 0.0);
    }

    private void findConeTip() {
        double sideB;
        this.findConeOrientation();
        if (this.coneOrientation_ == 0.0) {
            this.coneTip_ = null;
            return;
        }
        Point2D.Double ptA = this.transformLL2XYIgnoreMargins(this.lambdaC_, this.coneOrientation_);
        Point2D.Double ptB = this.transformLL2XYIgnoreMargins(this.lambdaC_ - 180.0, this.coneOrientation_);
        double dxB = Math.abs(ptB.x - ptA.x);
        double dyB = Math.abs(ptB.y - ptA.y);
        if (dxB < 1.0E-5 && dyB < 1.0E-5) {
            this.coneTip_ = ptA;
            return;
        }
        if (dxB < 1.0E-5) {
            this.coneTip_.x = ptA.x;
            this.coneTip_.y = this.coneOrientation_ > 0.0 ? ptA.y - 0.5 * dyB : ptA.y + 0.5 * dyB;
            return;
        }
        if (dyB < 1.0E-5) {
            this.coneTip_.x = ptA.x;
            this.coneTip_.y = this.coneOrientation_ > 0.0 ? ptA.y - dxB : ptA.y + dxB;
            return;
        }
        double sideA = 2.0 * Math.abs(dxB);
        double sideC = sideB = Math.hypot(dxB, dyB);
        double s = 0.5 * (sideA + sideB + sideC);
        double angleARad = 2.0 * Math.asin((s - sideB) / sideB);
        double radius = 0.5 * sideA / Math.sin(angleARad);
        this.coneTip_.x = ptA.x;
        this.coneTip_.y = this.coneOrientation_ > 0.0 ? ptA.y - radius : ptA.y + radius;
    }

    @Override
    public LonLatBounds getBounds() {
        double llRight;
        double llLeft;
        int ix;
        PointLL ll;
        int w = this.outWidth_;
        int h = this.outHeight_;
        int wOver2 = w / 2;
        int hOver2 = h / 2;
        try {
            ll = this.transformXY2LL((double)wOver2, (double)hOver2);
            if (ll == null) {
                return LonLatBounds.ENTIRE_GLOBE;
            }
        }
        catch (Exception exc) {
            return LonLatBounds.ENTIRE_GLOBE;
        }
        Insets ins = this.getInsets();
        double xright = this.outWidth_ - ins.right;
        double ytop = ins.top;
        double ybottom = this.outHeight_ - ins.bottom;
        double tLat = Double.NaN;
        double bLat = Double.NaN;
        Point2D.Double xy = this.transformLL2XY(this.lambdaC_, 90.0);
        if (xy != null && xy.y > 0.0 && xy.y < (double)h) {
            tLat = 90.0;
        }
        if (Double.isNaN(tLat)) {
            ix = wOver2;
            while ((double)ix < xright) {
                ll = this.transformXY2LL((double)ix, ytop + 1.0);
                if (ll == null) {
                    if (ix == wOver2) {
                        break;
                    }
                } else {
                    double lat = ll.getLat();
                    if (Double.isNaN(tLat) || lat > tLat) {
                        tLat = lat;
                    }
                }
                ++ix;
            }
            if (Double.isNaN(tLat)) {
                tLat = 90.0;
            }
        }
        if ((xy = this.transformLL2XY(this.lambdaC_, -90.0)) != null && xy.y > 0.0 && xy.y < (double)h) {
            bLat = -90.0;
        }
        if (Double.isNaN(bLat)) {
            ix = wOver2;
            while ((double)ix < xright) {
                ll = this.transformXY2LL((double)ix, ybottom - 1.0);
                if (ll == null) {
                    if (ix == wOver2) {
                        break;
                    }
                } else {
                    double lat = ll.getLat();
                    if (Double.isNaN(bLat) || lat < bLat) {
                        bLat = lat;
                    }
                }
                ++ix;
            }
            if (Double.isNaN(bLat)) {
                bLat = -90.0;
            }
        }
        if (tLat > 89.0 || bLat < -89.0) {
            return LonLatBounds.ENTIRE_GLOBE;
        }
        double llTop = tLat + 1.0;
        double llBottom = bLat - 1.0;
        double dlon = -9999.0;
        if (ybottom - ytop < 10.0) {
            dlon = 180.0;
        } else {
            int jy = (int)ytop + 1;
            while ((double)jy < ybottom - 1.0) {
                ll = this.transformXY2LL(xright - 1.0, (double)jy);
                if (ll == null) {
                    dlon = 180.0;
                    break;
                }
                double xlon = ll.getLon();
                if (xlon < this.lambdaC_) {
                    xlon += 360.0;
                }
                dlon = Math.max(dlon, xlon - this.lambdaC_);
                ++jy;
            }
        }
        if (dlon < 0.0) {
            dlon = 180.0;
        }
        if ((dlon += 1.0) > 180.0) {
            dlon = 180.0;
        }
        if (2.0 * dlon > 300.0) {
            llLeft = -180.0;
            llRight = 180.0;
        } else {
            llLeft = this.lambdaC_ - dlon;
            llRight = this.lambdaC_ + dlon;
        }
        return new LonLatBounds(llLeft, llTop, llRight, llBottom);
    }
}

