/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalCylindric;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class Equirectangular
extends GlobalCylindric {
    public static final String PROJECTION_NAME = "Equirectangular";
    private static final double DEFAULT_PHITS = 0.0;
    private static final double DEFAULT_WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 1.5707963267948966;
    private double cosPhiTS_ = Math.cos(Math.toRadians(0.0));
    private ProjDoubleParameter phi1Param_ = new ProjDoubleParameter("Latitude of standard parallel", "Std. Parallel", "\u00b0N", 0.0, 0.0, 85.0, true, true);

    public Equirectangular(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Equirectangular(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4, width, height, xmargin, ymargin, Math.PI, 1.5707963267948966);
        this.addParameter(this.phi1Param_);
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p != null && p != this.phi1Param_) {
            throw new IllegalArgumentException("Unknown parameter");
        }
        this.setStandardParallel(this.phi1Param_.getValue());
    }

    public void setStandardParallel(double lat) {
        this.cosPhiTS_ = Math.cos(Math.toRadians(lat));
        this.autoscale();
    }

    @Override
    protected void prepareScaling() {
        double wf = this.cosPhiTS_ * Math.PI;
        this.setSizeFactors(wf, 1.5707963267948966);
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double x = this.cosPhiTS_ * this.lonToLambdaRad(lon);
        double y = -Math.toRadians(lat);
        return new Point2D.Double((double)this.outCenterX_ + x * this.rS_, (double)this.outCenterY_ + y * this.rS_);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double phiRad = y * this.invRS_;
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = x * this.invRS_ / this.cosPhiTS_;
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Equirectangular equirectangular = this;
        synchronized (equirectangular) {
            double y;
            double phiRad;
            double invRScosPhiTS_ = this.invRS_ / this.cosPhiTS_;
            for (int iy = 0; iy < this.dyMax_ && !((phiRad = (y = (double)iy + 0.5) * this.invRS_) > 1.5707963267948966); ++iy) {
                double x;
                double lambdaRad;
                double phi = Math.toDegrees(phiRad);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * invRScosPhiTS_) > Math.PI); ++ix) {
                    this.set4SymmetricPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }
}

