/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class Fahey
extends GlobalPseudocylindric {
    public static final String PROJECTION_NAME = "Fahey";
    private static final double COS35 = Math.cos(Math.toRadians(35.0));
    private static final double ONE_PLUS_COS35 = 1.0 + COS35;
    private static final double WIDTH_FACTOR = Math.PI * COS35;
    private static final double HEIGHT_FACTOR = ONE_PLUS_COS35;

    public Fahey(int width, int height) {
        this(width, height, 0, 0);
    }

    public Fahey(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Fahey(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, WIDTH_FACTOR, HEIGHT_FACTOR);
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double y;
        double x;
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        if (lat == 0.0) {
            x = COS35 * this.lonToLambdaRad(lon);
            y = 0.0;
        } else if (lat == 90.0) {
            x = 0.0;
            y = ONE_PLUS_COS35;
        } else if (lat == -90.0) {
            x = 0.0;
            y = -ONE_PLUS_COS35;
        } else {
            double halfPhiRad = 0.5 * Math.toRadians(lat);
            double tanHalfPhiRad = Math.tan(halfPhiRad);
            x = COS35 * this.lonToLambdaRad(lon) * Math.sqrt(1.0 - tanHalfPhiRad * tanHalfPhiRad);
            y = ONE_PLUS_COS35 * tanHalfPhiRad;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double yOverRS = y * this.invRS_;
        double tanHalfPhiRad = yOverRS / ONE_PLUS_COS35;
        double phiRad = 2.0 * Math.atan(tanHalfPhiRad);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double xOverRS = x * this.invRS_;
        double lambdaRad = xOverRS / COS35 / Math.sqrt(1.0 - tanHalfPhiRad * tanHalfPhiRad);
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Fahey fahey = this;
        synchronized (fahey) {
            double y;
            double yOverRS;
            double tanHalfPhiRad;
            double phiRad;
            for (int iy = 0; iy < this.dyMax_ && !((phiRad = 2.0 * Math.atan(tanHalfPhiRad = (yOverRS = (y = (double)iy + 0.5) * this.invRS_) / ONE_PLUS_COS35)) > 1.5707963267948966); ++iy) {
                double phi = Math.toDegrees(phiRad);
                double xFactor = this.invRS_ / COS35 / Math.sqrt(1.0 - tanHalfPhiRad * tanHalfPhiRad);
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double lambdaRad = x * xFactor;
                    if (lambdaRad > Math.PI) continue;
                    this.set4SymmetricPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }
}

