/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.AzimuthalProjection;
import java.awt.Dimension;

public class GottMugnoloAzimuthal
extends AzimuthalProjection {
    public static final String PROJECTION_NAME = "Gott-Mugnolo Azimuthal";
    private static final double CONST_A = 0.446;
    private static final double INV_A = 2.242152466367713;
    private static final double DEFAULT_RADIUS = 90.0;
    private static final double MAX_RADIUS = 180.0;

    public GottMugnoloAzimuthal(int width, int height) {
        this(width, height, 0, 0);
    }

    public GottMugnoloAzimuthal(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public GottMugnoloAzimuthal(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x200040, width, height, xmargin, ymargin, 1.0, 1.0);
        this.addEdgeRadiusParameter(90.0, 180.0, true);
        this.addFillParameter();
        this.autoscale();
    }

    @Override
    public void setEdgeRadius(double r) {
        this.radiusDeg_ = r;
        this.radiusRad_ = Math.toRadians(this.radiusDeg_);
        this.autoscale();
    }

    @Override
    protected void prepareScaling() {
        double rhoMaxOverR = Math.sin(0.446 * this.radiusRad_);
        this.setSizeFactor(rhoMaxOverR);
    }

    @Override
    protected final void finishScaling() {
        if (this.fillCorners_) {
            double rhoBOverR = Math.sin(1.4011503235010478);
            this.rhoBorder_ = rhoBOverR * this.rS_;
        } else {
            this.rhoBorder_ = this.xmRS_;
        }
        this.rhoBorder2_ = this.rhoBorder_ * this.rhoBorder_;
    }

    @Override
    protected double getKForCosZ(double cosZ) {
        double z = Math.acos(cosZ);
        return Math.sin(0.446 * z) / Math.sin(z);
    }

    @Override
    protected double getZForRhoRS(double rhoRS) {
        return 2.242152466367713 * Math.asin(rhoRS * this.invRS_);
    }
}

