/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.BiSymmetricProjection;
import gov.nasa.giss.map.proj.ProjectionUtils;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HexafoliateEquaArea
extends BiSymmetricProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Hexafoliate Equal-Area";
    public static final int PROPERTIES = 16793602;
    private static final double JOIN_LAT = 0.0;
    private static final double JOIN_LAT_RAD = Math.toRadians(0.0);
    private static final double JOIN_COLAT_RAD = 1.5707963267948966 - JOIN_LAT_RAD;
    private static final double COS_JOIN = Math.cos(JOIN_LAT_RAD);
    private static final double SIN_JOIN = Math.sin(JOIN_LAT_RAD);
    private static final double SEC_JOIN = 1.0 / COS_JOIN;
    private static final double K_JOIN = Math.sqrt(2.0 / (1.0 + SIN_JOIN));
    private static final double RHO_JOIN = K_JOIN * COS_JOIN;
    private static final double COS_HALF_J_COLAT = Math.cos(0.5 * JOIN_COLAT_RAD);
    private static final int NUM_LOBES = 6;
    private static final double LOBE_WIDTH = 60.0;
    private static final double HALF_LOBE_WIDTH = 30.0;
    private static final double LOBE_WIDTH_RAD = Math.toRadians(60.0);
    private static final double HALF_LOBE_WIDTH_RAD = 0.5 * LOBE_WIDTH_RAD;
    private static final double COS_HALF_LOBE_WIDTH = Math.cos(HALF_LOBE_WIDTH_RAD);
    private static final double SIN_HALF_LOBE_WIDTH = Math.sin(HALF_LOBE_WIDTH_RAD);
    private static final double COS_LOBE_WIDTH = Math.cos(LOBE_WIDTH_RAD);
    private static final double SIN_LOBE_WIDTH = Math.sin(LOBE_WIDTH_RAD);
    private static final double LOBE_SCALING = RHO_JOIN / JOIN_COLAT_RAD;
    private static final double INV_LOBE_SCALING = 1.0 / LOBE_SCALING;
    private static final double MER_SCALING = COS_HALF_J_COLAT * SEC_JOIN;
    private static final double INV_MER_SCALING = 1.0 / MER_SCALING;
    private static final double PAR_SCALING = JOIN_COLAT_RAD * SEC_JOIN;
    private static final double INV_PAR_SCALING = 1.0 / PAR_SCALING;
    private static final double WIDTH_FACTOR = LOBE_SCALING * (JOIN_COLAT_RAD + MER_SCALING * (1.5707963267948966 + JOIN_LAT_RAD));
    private static final double HEIGHT_FACTOR = WIDTH_FACTOR * COS_HALF_LOBE_WIDTH;
    private static final double REFERENCE_LON = -20.0;

    public HexafoliateEquaArea(int width, int height) {
        this(width, height, 0, 0);
    }

    public HexafoliateEquaArea(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public HexafoliateEquaArea(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 16793602, width, height, xmargin, ymargin, WIDTH_FACTOR, HEIGHT_FACTOR);
        super.setCenter(-20.0, 90.0);
    }

    @Override
    public void setCenter(double lon, double lat) {
        LOGGER.trace("Projection does not support changing center.");
    }

    @Override
    public boolean isRecenterableLon() {
        return false;
    }

    @Override
    public boolean isRecenterableLat() {
        return false;
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double y;
        double x;
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        if (lat > 89.99999) {
            return new Point2D.Double(this.outCenterX_, this.outCenterY_);
        }
        double phiRad = Math.toRadians(lat);
        if (lat >= 0.0) {
            double halfPhiRad = 0.5 * phiRad;
            double cosHalfPhi = Math.cos(halfPhiRad);
            double sinHalfPhi = Math.sin(halfPhiRad);
            double rho = 1.4142135623730951 * (cosHalfPhi - sinHalfPhi);
            double lambdaRad = this.lonToLambdaRad(lon);
            x = rho * Math.sin(lambdaRad);
            y = -rho * Math.cos(lambdaRad);
        } else {
            double lambda = MapUtils.normalize360(this.lonToLambda(lon));
            int lobe = (int)(lambda / 60.0);
            double alphaRad = JOIN_COLAT_RAD + MER_SCALING * (JOIN_LAT_RAD - phiRad);
            double rho = LOBE_SCALING * alphaRad;
            double rotateRad = -(60.0 * (double)lobe + 30.0);
            double xlambdaRad = Math.toRadians(lambda + rotateRad);
            double betaRad = lat < -89.99999 ? 0.0 : PAR_SCALING * xlambdaRad * Math.cos(phiRad) / alphaRad;
            double xx = rho * Math.sin(betaRad);
            double yy = -rho * Math.cos(betaRad);
            double xxx = xx * COS_HALF_LOBE_WIDTH - yy * SIN_HALF_LOBE_WIDTH;
            double yyy = xx * SIN_HALF_LOBE_WIDTH + yy * COS_HALF_LOBE_WIDTH;
            for (int i = 1; i <= lobe; ++i) {
                x = COS_LOBE_WIDTH * xxx - SIN_LOBE_WIDTH * yyy;
                y = SIN_LOBE_WIDTH * xxx + COS_LOBE_WIDTH * yyy;
                xxx = x;
                yyy = y;
            }
            x = xxx;
            y = yyy;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double phi;
        double lambdaRad;
        double phiRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (x == 0.0 && y == 0.0) {
            return this.getCenter();
        }
        double absx = Math.abs(x);
        if (absx > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double xOverRS = absx * this.invRS_;
        double yOverRS = y * this.invRS_;
        double rho = Math.sqrt(xOverRS * xOverRS + yOverRS * yOverRS);
        if (rho <= RHO_JOIN) {
            double z = 2.0 * Math.asin(0.5 * rho);
            double sinZ = Math.sin(z);
            phiRad = 1.5707963267948966 - z;
            lambdaRad = Math.atan2(x * sinZ, -y * sinZ);
        } else {
            double zetaRad;
            for (zetaRad = Math.atan2(absx, -y); zetaRad < 0.0; zetaRad += Math.PI * 2) {
            }
            int lobe = (int)(zetaRad / LOBE_WIDTH_RAD);
            if (lobe > 0) {
                return null;
            }
            double alphaRad = rho * INV_LOBE_SCALING;
            phiRad = JOIN_LAT_RAD - (alphaRad - JOIN_COLAT_RAD) * INV_MER_SCALING;
            if (phiRad < -1.5707963267948966) {
                return null;
            }
            double rotateRad = -(HALF_LOBE_WIDTH_RAD + (double)lobe * LOBE_WIDTH_RAD);
            double cosRotate = Math.cos(rotateRad);
            double sinRotate = Math.sin(rotateRad);
            double xrot = xOverRS * cosRotate - yOverRS * sinRotate;
            double yrot = xOverRS * sinRotate + yOverRS * cosRotate;
            double betaRad = Math.atan2(Math.abs(xrot), -yrot);
            lambdaRad = alphaRad * betaRad * INV_PAR_SCALING / Math.cos(phiRad);
            if (lambdaRad > HALF_LOBE_WIDTH_RAD) {
                return null;
            }
            if (xrot < 0.0) {
                lambdaRad = -lambdaRad;
            }
            lambdaRad -= rotateRad;
        }
        if (x < 0.0) {
            lambdaRad = -lambdaRad;
        }
        if ((phi = Math.toDegrees(phiRad)) < -90.0) {
            return null;
        }
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        HexafoliateEquaArea hexafoliateEquaArea = this;
        synchronized (hexafoliateEquaArea) {
            for (int iiy = this.dyMax_; iiy > -this.dyMax_; --iiy) {
                int iy = -iiy;
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                double y2OverRS2 = yOverRS * yOverRS;
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double lambdaRad;
                    double phiRad;
                    double x = (double)ix + 0.5;
                    double xOverRS = x * this.invRS_;
                    double rho = Math.sqrt(xOverRS * xOverRS + y2OverRS2);
                    if (rho <= RHO_JOIN) {
                        double z = 2.0 * Math.asin(0.5 * rho);
                        double sinZ = Math.sin(z);
                        phiRad = 1.5707963267948966 - z;
                        lambdaRad = Math.atan2(x * sinZ, -y * sinZ);
                    } else {
                        double betaRad;
                        double zetaRad;
                        for (zetaRad = Math.atan2(x, -y); zetaRad < 0.0; zetaRad += Math.PI * 2) {
                        }
                        int lobe = (int)(zetaRad / LOBE_WIDTH_RAD);
                        double rotateRad = -(HALF_LOBE_WIDTH_RAD + (double)lobe * LOBE_WIDTH_RAD);
                        double cosRotate = Math.cos(rotateRad);
                        double sinRotate = Math.sin(rotateRad);
                        double xrot = xOverRS * cosRotate - yOverRS * sinRotate;
                        double yrot = xOverRS * sinRotate + yOverRS * cosRotate;
                        double alphaRad = rho * INV_LOBE_SCALING;
                        phiRad = JOIN_LAT_RAD - (alphaRad - JOIN_COLAT_RAD) * INV_MER_SCALING;
                        if (phiRad < -1.5707963267948966 || (lambdaRad = alphaRad * (betaRad = Math.atan2(Math.abs(xrot), -yrot)) * INV_PAR_SCALING / Math.cos(phiRad)) > HALF_LOBE_WIDTH_RAD) continue;
                        if (xrot < 0.0) {
                            lambdaRad = -lambdaRad;
                        }
                        lambdaRad -= rotateRad;
                    }
                    double lambda = Math.toDegrees(lambdaRad);
                    double phi = Math.toDegrees(phiRad);
                    this.set2SymmetricPoints(ix, iy, lambda, phi);
                }
            }
        }
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        for (int i = 0; i < 6; ++i) {
            double lon1 = this.lambdaC_ + (double)i * 60.0 + 1.0E-5;
            double lon2 = this.lambdaC_ + (double)(i + 1) * 60.0 - 1.0E-5;
            Bezier bcurve = this.makeMeridianBezier(lon1);
            if (bcurve != null) {
                bcurve.draw(g2d);
            }
            if ((bcurve = this.makeMeridianBezier(lon2)) == null) continue;
            bcurve.draw(g2d);
        }
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        if (lat >= 0.0) {
            Point2D.Double dot = this.transformLL2XYIgnoreMargins(this.lambdaC_ + 30.0, lat);
            if (dot == null) {
                return;
            }
            double dx = (double)this.outCenterX_ - dot.x;
            double dy = (double)this.outCenterY_ - dot.y;
            double r = Math.sqrt(dx * dx + dy * dy);
            g2d.translate(this.outCenterX_, this.outCenterY_);
            ProjectionUtils.drawEllipse(g2d, 0.0, 0.0, r, r);
            g2d.translate(-this.outCenterX_, -this.outCenterY_);
        } else {
            for (int i = 0; i < 6; ++i) {
                double lon1 = this.lambdaC_ + (double)i * 60.0 + 1.0E-5;
                double lon2 = this.lambdaC_ + (double)i * 60.0 + 30.0;
                double lon3 = this.lambdaC_ + (double)(i + 1) * 60.0 - 1.0E-5;
                Point2D.Double dot1 = this.transformLL2XYIgnoreMargins(lon1, lat);
                Point2D.Double dot2 = this.transformLL2XYIgnoreMargins(lon2, lat);
                Point2D.Double dot3 = this.transformLL2XYIgnoreMargins(lon3, lat);
                GraphicUtils.drawCircularArc(g2d, dot1.x, dot1.y, dot2.x, dot2.y, dot3.x, dot3.y);
            }
        }
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        for (int i = 0; i < 6; ++i) {
            double lobeCenter = MapUtils.normalizeMP180(this.lambdaC_ + (double)i * 60.0 + 30.0);
            double cdiff = Math.abs(MapUtils.normalizeMP180(lon - lobeCenter));
            if (cdiff > 30.0) continue;
            Point2D.Double dot90S = this.transformLL2XYIgnoreMargins(lon, -90.0);
            if (Math.abs(cdiff) < 1.0E-5) {
                GraphicUtils.drawLine(g2d, this.outCenterX_, this.outCenterY_, dot90S.x, dot90S.y);
                return;
            }
            Point2D.Double dotEq = this.transformLL2XYIgnoreMargins(lon, 0.0);
            GraphicUtils.drawLine(g2d, this.outCenterX_, this.outCenterY_, dotEq.x, dotEq.y);
            if (cdiff > 29.99999) {
                return;
            }
            Bezier bcurve = this.makeMeridianBezier(lon);
            if (bcurve == null) continue;
            bcurve.draw(g2d);
        }
    }

    private Bezier makeMeridianBezier(double lon) {
        Point2D.Double dot;
        ArrayList<Point2D.Double> ptlist = new ArrayList<Point2D.Double>(240);
        for (double lat = -90.0; lat < 0.0; lat += 0.5) {
            dot = this.transformLL2XYIgnoreMargins(lon, lat);
            ptlist.add(new Point2D.Double(dot.x, dot.y));
        }
        dot = this.transformLL2XYIgnoreMargins(lon, 0.0);
        ptlist.add(new Point2D.Double(dot.x, dot.y));
        return new Bezier(false, ptlist);
    }
}

