/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.InterruptedPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class McBrydeThomas3
extends InterruptedPseudocylindric {
    public static final String PROJECTION_NAME = "McBryde-Thomas Flat-Polar Sinusoidal";
    private static final double CONST_K = 0.5;
    private static final double CAP_M = Math.sqrt(0.840148730267336);
    private static final double CONST_N = 1.7853981633974483;
    private static final double INV_M = 1.0 / CAP_M;
    private static final double INV_N = 0.5600991535115574;
    private static final double CSUBX = CAP_M / 3.0;
    private static final double WIDTH_FACTOR = Math.PI * CAP_M;
    private static final double HEIGHT_FACTOR = 1.5707963267948966 * CAP_M;
    private double xFactor0_;

    public McBrydeThomas3(int width, int height) {
        this(width, height, 0, 0);
    }

    public McBrydeThomas3(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public McBrydeThomas3(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x1000008, width, height, xmargin, ymargin, WIDTH_FACTOR, HEIGHT_FACTOR);
        this.finishScaling();
    }

    @Override
    protected final void finishScaling() {
        this.xFactor0_ = this.invRS_ * INV_M;
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double y;
        double x;
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double phiRad = Math.toRadians(lat);
        if (Math.abs(phiRad) < 1.0E-5) {
            x = CSUBX * this.lonToLambdaRad(lon) * 3.0;
            y = 0.0;
        } else {
            double nSinPhi = 1.7853981633974483 * Math.sin(phiRad);
            double alphaRad = phiRad;
            for (int iter = 0; iter < 33; ++iter) {
                double func = 0.5 * alphaRad + Math.sin(alphaRad) - nSinPhi;
                double dfunc = 0.5 + Math.cos(alphaRad);
                double dalphaRad = -func / dfunc;
                alphaRad += dalphaRad;
                if (Math.abs(dalphaRad) < 1.0E-5) break;
            }
            y = alphaRad * CAP_M;
            double alphaTerm = 1.0 + 2.0 * Math.cos(alphaRad);
            if (this.isShowingInterrupted()) {
                double[] gore = this.getGore(lon, lat);
                double clon = gore[1];
                double dlon = MapUtils.normalizeMP180(lon) - clon;
                if (MapUtils.normalizeMP180(lon) > gore[2]) {
                    dlon -= 360.0;
                }
                double dx = CSUBX * Math.toRadians(dlon) * alphaTerm;
                double cx = CSUBX * this.lonToLambdaRad(clon) * 3.0;
                x = cx + dx;
            } else {
                x = CSUBX * this.lonToLambdaRad(lon) * alphaTerm;
            }
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double alphaRad = y * this.invRS_ * INV_M;
        double sinAlpha = Math.sin(alphaRad);
        double phiRad = Math.asin((0.5 * alphaRad + sinAlpha) * 0.5600991535115574);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double xFactor = 1.5 * this.invRS_ * CAP_M / (0.5 + Math.cos(alphaRad));
        double lon = this.getLongitudeForX(x, xFactor, this.xFactor0_, phiRad > 0.0);
        if (Double.isNaN(lon)) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        return new PointLL(lon, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        McBrydeThomas3 mcBrydeThomas3 = this;
        synchronized (mcBrydeThomas3) {
            for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                double alphaRad = yOverRS * INV_M;
                double sinAlpha = Math.sin(alphaRad);
                double phiRad = Math.asin((0.5 * alphaRad + sinAlpha) * 0.5600991535115574);
                if (phiRad < -1.5707963267948966) continue;
                if (phiRad > 1.5707963267948966) break;
                double phi = Math.toDegrees(phiRad);
                double xFactor = 1.5 * this.invRS_ * INV_M / (0.5 + Math.cos(alphaRad));
                for (int ix = -this.dxMax_; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double lon = this.getLongitudeForX(x, xFactor, this.xFactor0_, phi > 0.0);
                    if (Double.isNaN(lon)) continue;
                    this.setPoint(ix, iy, lon, phi);
                }
            }
        }
    }
}

