/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.map.LonLatBounds;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.ModifiedStereographicProjection;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class MillerOblatedStereographic
extends ModifiedStereographicProjection {
    public static final String PROJECTION_NAME = "Miller Oblated Stereographic";
    private static final double WIDTH_FACTOR = 1.1346529025296792;
    private static final double HEIGHT_FACTOR = 1.3151828199346145;
    private static final double PHI1 = 18.0;
    private static final double LAMBDA0 = 20.0;
    private static final double XSHIFT = 0.0;
    private static final double YSHIFT = 0.14255474283588093;
    private static final double A1 = 0.9245;
    private static final double A3 = 0.01943;
    private static final double[] CAP_A = new double[]{0.0, 0.9245, 0.0, 0.01943};
    private static final double[] CAP_B = new double[]{0.0, 0.0, 0.0, 0.0};

    public MillerOblatedStereographic(int width, int height) {
        this(width, height, 0, 0);
    }

    public MillerOblatedStereographic(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public MillerOblatedStereographic(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 1024, width, height, xmargin, ymargin, 1.1346529025296792, 1.3151828199346145, 20.0, 18.0, 0.0, 0.14255474283588093, CAP_A, CAP_B);
    }

    @Override
    public boolean isWithinBounds(double lon, double lat) {
        if (lat > 80.0 || lat < -50.0) {
            return false;
        }
        double xlon = MapUtils.normalizeMP180(lon);
        return !(xlon > 80.0) && !(xlon < -40.0);
    }

    @Override
    public LonLatBounds getBounds() {
        return new LonLatBounds(-40.0, 80.0, 80.0, -50.0);
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        Bezier[] curves;
        for (Bezier curve : curves = this.makeBorderBezier()) {
            if (curve == null) continue;
            curve.draw(g2d);
        }
    }

    private Bezier[] makeBorderBezier() {
        int j;
        ArrayList<Point2D.Double> alist1 = new ArrayList<Point2D.Double>(100);
        ArrayList<Point2D.Double> alist2 = new ArrayList<Point2D.Double>(100);
        ArrayList<Point2D.Double> alist3 = new ArrayList<Point2D.Double>(100);
        ArrayList<Point2D.Double> alist4 = new ArrayList<Point2D.Double>(100);
        int np = 60;
        double dlat = 2.1666666666666665;
        for (j = 0; j <= 60; ++j) {
            double lat = -50.0 + 2.1666666666666665 * (double)j;
            Point2D.Double dot1 = this.transformLL2XY(-39.99999, lat);
            Point2D.Double dot2 = this.transformLL2XY(79.99999, lat);
            alist1.add(new Point2D.Double(dot1.x, dot1.y));
            alist2.add(new Point2D.Double(dot2.x, dot2.y));
        }
        np = 60;
        double dlon = 2.0;
        for (j = 0; j <= 60; ++j) {
            double lon = -40.0 + 2.0 * (double)j;
            Point2D.Double dot3 = this.transformLL2XY(lon, 79.99999);
            Point2D.Double dot4 = this.transformLL2XY(lon, -49.99999);
            alist3.add(new Point2D.Double(dot3.x, dot3.y));
            alist4.add(new Point2D.Double(dot4.x, dot4.y));
        }
        Bezier[] curves = new Bezier[]{new Bezier(false, alist1), new Bezier(false, alist2), new Bezier(false, alist3), new Bezier(false, alist4)};
        return curves;
    }
}

