/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalCylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class MillerPerspectiveCompromise
extends GlobalCylindric {
    public static final String PROJECTION_NAME = "Miller Perspective Compromise";
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = Math.sin(0.7853981633974483) + Math.tan(0.7853981633974483);

    public MillerPerspectiveCompromise(int width, int height) {
        this(width, height, 0, 0);
    }

    public MillerPerspectiveCompromise(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public MillerPerspectiveCompromise(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4, width, height, xmargin, ymargin, Math.PI, HEIGHT_FACTOR);
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double halfPhiRad = 0.5 * Math.toRadians(lat);
        double x = this.lonToLambdaRad(lon);
        double y = Math.sin(halfPhiRad) + Math.tan(halfPhiRad);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double x = xx - (double)this.outCenterX_;
        double lambdaRad = x * this.invRS_;
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double yOverRS = y * this.invRS_;
        double phiRad = 1.5707963267948966 * y / this.ymRS_;
        for (int iter = 0; iter < 33; ++iter) {
            double halfPhiRad = 0.5 * phiRad;
            double cosHalfPhi = Math.cos(halfPhiRad);
            double secHalfPhi = 1.0 / cosHalfPhi;
            double func = Math.sin(halfPhiRad) + Math.tan(halfPhiRad) - yOverRS;
            double dfunc = 0.5 * Math.cos(halfPhiRad) + 0.5 * secHalfPhi * secHalfPhi;
            double dphiRad = -func / dfunc;
            phiRad += dphiRad;
            if (Math.abs(dphiRad) < 1.0E-5) break;
        }
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        double phiRad = 1.0E-5;
        MillerPerspectiveCompromise millerPerspectiveCompromise = this;
        synchronized (millerPerspectiveCompromise) {
            for (int iy = 0; iy < this.dyMax_; ++iy) {
                double x;
                double lambdaRad;
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                phiRad += 1.0E-5;
                for (int iter = 0; iter < 33; ++iter) {
                    double halfPhiRad = 0.5 * phiRad;
                    double cosHalfPhi = Math.cos(halfPhiRad);
                    double secHalfPhi = 1.0 / cosHalfPhi;
                    double func = Math.sin(halfPhiRad) + Math.tan(halfPhiRad) - yOverRS;
                    double dfunc = 0.5 * Math.cos(halfPhiRad) + 0.5 * secHalfPhi * secHalfPhi;
                    double dphiRad = -func / dfunc;
                    phiRad += dphiRad;
                    if (Math.abs(dphiRad) < 1.0E-5) break;
                }
                double phi = Math.toDegrees(phiRad);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * this.invRS_) > Math.PI); ++ix) {
                    this.set4SymmetricPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }
}

