/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.BiSymmetricProjection;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class RaiszHalfEllipsoidal
extends BiSymmetricProjection {
    public static final String PROJECTION_NAME = "Raisz Half Ellipsoidal";
    public static final int PROPERTIES = 256;
    private static final double DEFAULT_TILT = 20.0;
    private static final double MAX_TILT = 90.0;
    private static final double WIDTH_FACTOR = 2.0;
    private static final double HEIGHT_FACTOR = 1.0;
    private double tilt_;
    private double cosTilt_;
    private double sinTilt_;
    private double tanTilt_;
    private double latMin_;
    private double latMax_;
    private double yshift_;
    private double yMin_;
    private double dyMax_;
    private ProjDoubleParameter tiltParam_ = new ProjDoubleParameter("Angle that shape is tilted downward", "Tilt Angle", "\u00b0", 20.0, -90.0, 90.0);
    private Bezier[] borderCurves_;

    public RaiszHalfEllipsoidal(int width, int height) {
        this(width, height, 0, 0);
    }

    public RaiszHalfEllipsoidal(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public RaiszHalfEllipsoidal(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 256, width, height, xmargin, ymargin, 2.0, 1.0);
        this.addParameter(this.tiltParam_);
        this.autoscale();
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p != null && p != this.tiltParam_) {
            throw new IllegalArgumentException("Unknown parameter");
        }
        this.setTiltAngle(this.tiltParam_.getValue());
    }

    public void setTiltAngle(double tilt) {
        if (Math.abs(tilt) > 90.0) {
            throw new IllegalArgumentException("Specified tilt outside valid range");
        }
        this.tilt_ = tilt;
        double tiltRad = Math.toRadians(this.tilt_);
        this.cosTilt_ = Math.cos(tiltRad);
        this.sinTilt_ = Math.sin(tiltRad);
        this.tanTilt_ = Math.tan(tiltRad);
        this.autoscale();
    }

    @Override
    protected void prepareScaling() {
        if (Math.abs(this.tilt_) < 1.0E-5) {
            this.setSizeFactors(2.0, this.cosTilt_);
        } else {
            double y1 = this.tilt_ > 0.0 ? this.cosTilt_ : -this.cosTilt_;
            double cos2T = Math.cos(Math.toRadians(2.0 * this.tilt_));
            double squCotT = (1.0 + cos2T) / (1.0 - cos2T);
            double y2 = -this.sinTilt_ * Math.sqrt(squCotT + 4.0);
            this.setSizeFactors(2.0, 0.5 * Math.abs(y1 - y2));
        }
    }

    @Override
    protected final void finishScaling() {
        if (Math.abs(this.tilt_) < 1.0E-5) {
            this.yshift_ = 0.0;
        } else {
            double y1 = this.tilt_ > 0.0 ? this.cosTilt_ : -this.cosTilt_;
            double cos2T = Math.cos(Math.toRadians(2.0 * this.tilt_));
            double squCotT = (1.0 + cos2T) / (1.0 - cos2T);
            double y2 = -this.sinTilt_ * Math.sqrt(squCotT + 4.0);
            this.yshift_ = -0.5 * (y1 + y2);
        }
        this.latMin_ = this.tilt_ > 0.0 ? this.findLatLimit(0.0) + 0.01 : -90.0;
        this.latMax_ = this.tilt_ < 0.0 ? this.findLatLimit(0.0) - 0.01 : 90.0;
        this.yMin_ = this.transformLL2XYIgnoreMargins((double)this.lambdaC_, (double)this.latMin_).y;
        this.dyMax_ = this.transformLL2XYIgnoreMargins((double)this.lambdaC_, (double)this.latMax_).y;
        this.yMin_ = -(this.yMin_ - (double)this.outCenterY_);
        this.dyMax_ = -(this.dyMax_ - (double)this.outCenterY_);
        this.borderCurves_ = null;
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double lambda = this.lonToLambda(lon);
        double latLimit = this.findLatLimit(lambda);
        if (this.tilt_ > 0.0 && lat < latLimit || this.tilt_ < 0.0 && lat > latLimit) {
            return null;
        }
        double phiRad = Math.toRadians(lat);
        double cosPhi = Math.cos(phiRad);
        double sinPhi = Math.sin(phiRad);
        double halfLambdaRad = 0.5 * Math.toRadians(lambda);
        double x = 2.0 * Math.sin(halfLambdaRad) * cosPhi;
        double y = this.yshift_ + sinPhi * this.cosTilt_ - 2.0 * this.sinTilt_ * cosPhi * Math.cos(halfLambdaRad);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double y = (double)this.outCenterY_ - yy;
        if (y < this.yMin_ || y > this.dyMax_) {
            return null;
        }
        double x = xx - (double)this.outCenterX_;
        double absX = Math.abs(x);
        if (absX > (double)this.dxMax_ || Math.abs(y) > this.dyMax_) {
            return null;
        }
        double phiRad0 = (this.latMin_ + (y - this.yMin_) / (this.dyMax_ - this.yMin_) * (this.latMax_ - this.latMin_)) * (Math.PI / 180);
        double[] llRad = this.iterateXY2LL(absX, y, 2.356194490192345, phiRad0);
        if (llRad == null) {
            return null;
        }
        double lambdaRad = x < 0.0 ? -llRad[0] : llRad[0];
        double lambda = Math.toDegrees(lambdaRad);
        double phi = Math.toDegrees(llRad[1]);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        RaiszHalfEllipsoidal raiszHalfEllipsoidal = this;
        synchronized (raiszHalfEllipsoidal) {
            int iy = -((int)this.dyMax_);
            while ((double)iy < this.dyMax_) {
                double y = (double)iy + 0.5;
                if (!(y < this.yMin_) && !(y > this.dyMax_)) {
                    double x;
                    double[] llRad;
                    double lambdaRad = 1.0E-5;
                    double phiRad = (this.latMin_ + (y - this.yMin_) / (this.dyMax_ - this.yMin_) * (this.latMax_ - this.latMin_)) * (Math.PI / 180);
                    for (int ix = 0; ix < this.dxMax_ && (llRad = this.iterateXY2LL(x = (double)ix + 0.5, y, lambdaRad += 1.0E-5, phiRad += 1.0E-5)) != null; ++ix) {
                        lambdaRad = llRad[0];
                        phiRad = llRad[1];
                        this.set2SymmetricPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                    }
                }
                ++iy;
            }
        }
    }

    private double findLatLimit(double dlambda) {
        double limitRad = -Math.atan(0.5 * Math.cos(0.5 * dlambda * (Math.PI / 180)) / this.tanTilt_);
        return Math.toDegrees(limitRad);
    }

    private double[] iterateXY2LL(double x, double y, double lambdaRad0, double phiRad0) {
        double xOverRS = x * this.invRS_;
        double yOverRS = y * this.invRS_;
        double lambdaRad = lambdaRad0;
        double phiRad = phiRad0;
        boolean found = false;
        for (int iter = 0; iter < 33; ++iter) {
            double halfLambdaRad = 0.5 * lambdaRad;
            double cosHalfLambda = Math.cos(halfLambdaRad);
            double sinHalfLambda = Math.sin(halfLambdaRad);
            double cosPhi = Math.cos(phiRad);
            double sinPhi = Math.sin(phiRad);
            double f1 = 2.0 * sinHalfLambda * cosPhi - xOverRS;
            double f2 = this.yshift_ + sinPhi * this.cosTilt_ - 2.0 * this.sinTilt_ * cosHalfLambda * cosPhi - yOverRS;
            double df1dPhi = -2.0 * sinHalfLambda * sinPhi;
            double df1dLambda = cosHalfLambda * cosPhi;
            double df2dPhi = this.cosTilt_ * cosPhi + 2.0 * this.sinTilt_ * cosHalfLambda * sinPhi;
            double df2dLambda = this.sinTilt_ * sinHalfLambda * cosPhi;
            double denom = df1dPhi * df2dLambda - df2dPhi * df1dLambda;
            double dphi = (f1 * df2dLambda - f2 * df1dLambda) / denom;
            double dlambda = (f2 * df1dPhi - f1 * df2dPhi) / denom;
            phiRad -= dphi;
            lambdaRad -= dlambda;
            if (!(Math.abs(dphi) < 1.0E-5) || !(Math.abs(dlambda) < 1.0E-5)) continue;
            found = true;
            break;
        }
        if (!found) {
            return null;
        }
        if (lambdaRad > Math.PI || lambdaRad < 0.0) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double phiLim = this.findLatLimit(Math.toDegrees(lambdaRad));
        if (this.tilt_ > 0.0 && phi < phiLim || this.tilt_ < 0.0 && phi > phiLim) {
            return null;
        }
        return new double[]{lambdaRad, phiRad};
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        if (this.borderCurves_ == null) {
            this.borderCurves_ = this.makeBorderBezier();
        }
        for (Bezier curve : this.borderCurves_) {
            if (curve == null) continue;
            curve.draw(g2d);
        }
    }

    private Bezier[] makeBorderBezier() {
        if (Math.abs(this.tilt_) < 1.0E-5) {
            return this.makeBorderBezier0();
        }
        ArrayList<Point2D.Double> alist1 = new ArrayList<Point2D.Double>(100);
        ArrayList<Point2D.Double> alist2 = new ArrayList<Point2D.Double>(100);
        ArrayList<Point2D.Double> alist3 = new ArrayList<Point2D.Double>(100);
        ArrayList<Point2D.Double> alist4 = new ArrayList<Point2D.Double>(100);
        int numPt = 90;
        double numPtFact = 2.0;
        double edgeLon = this.lambdaC_ + 180.0;
        Point2D.Double lastDot = null;
        for (int j = 0; j <= 90; ++j) {
            Point2D.Double dot;
            double lat = 90.0 - 2.0 * (double)j;
            if (this.tilt_ < 0.0) {
                lat *= -1.0;
            }
            if ((dot = this.transformLL2XY(edgeLon - 0.05, lat)) == null) break;
            alist1.add(new Point2D.Double(dot.x, dot.y));
            alist2.add(new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, dot.y));
            lastDot = dot;
        }
        if (lastDot != null) {
            alist3.add(new Point2D.Double(lastDot.x, lastDot.y));
            alist4.add(new Point2D.Double(2.0 * (double)this.outCenterX_ - lastDot.x, lastDot.y));
            double subtract = 0.0;
            while (subtract < 180.0) {
                subtract = subtract < 0.75 && this.tilt_ < 0.5 ? (subtract += 0.05) : (subtract < 5.0 ? (subtract += 0.5) : (subtract < 30.0 ? (subtract += 1.0) : (subtract < 60.0 ? (subtract += 2.0) : (subtract += 3.0))));
                double dlon = Math.max(180.0 - subtract, 0.0);
                double latLimit = this.findLatLimit(dlon) + (this.tilt_ > 0.0 ? 0.01 : -0.01);
                Point2D.Double dot = this.transformLL2XY(this.lambdaC_ + dlon - 0.01, latLimit);
                if (dot == null || dot.x > lastDot.x) continue;
                alist3.add(new Point2D.Double(dot.x, dot.y));
                alist4.add(new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, dot.y));
            }
        }
        Bezier[] curves = new Bezier[]{new Bezier(false, alist1), new Bezier(false, alist2), new Bezier(false, alist3), new Bezier(false, alist4)};
        return curves;
    }

    protected Bezier[] makeBorderBezier0() {
        double edgeLon = this.lambdaC_ + 179.99999;
        int numPt = 30;
        double fact = 3.0;
        Point2D.Double[] dotsE = new Point2D.Double[61];
        Point2D.Double[] dotsW = new Point2D.Double[61];
        for (int j = 0; j <= 30; ++j) {
            double jj = 3.0 * (double)j;
            Point2D.Double dot = this.transformLL2XY(edgeLon, jj);
            dotsE[30 - j] = new Point2D.Double(dot.x, dot.y);
            dotsE[30 + j] = new Point2D.Double(dot.x, 2.0 * (double)this.outCenterY_ - dot.y);
            dotsW[30 - j] = new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, dot.y);
            dotsW[30 + j] = new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, 2.0 * (double)this.outCenterY_ - dot.y);
        }
        Bezier[] curves = new Bezier[5];
        curves[0] = new Bezier(false, dotsE);
        curves[1] = new Bezier(false, dotsW);
        return curves;
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        double dlon = MapUtils.normalize360(lon - this.lambdaC_);
        if (Math.abs(dlon - 180.0) < 1.0E-5) {
            return;
        }
        super.drawMeridian(g2d, lon, label);
    }
}

