/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.InterruptedPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class Sinusoidal
extends InterruptedPseudocylindric {
    public static final String PROJECTION_NAME = "Sinusoidal";
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 1.5707963267948966;

    public Sinusoidal(int width, int height) {
        this(width, height, 0, 0);
    }

    public Sinusoidal(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Sinusoidal(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x1000008, width, height, xmargin, ymargin, Math.PI, 1.5707963267948966);
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double x;
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        if (lat == 0.0 && !this.isShowingInterrupted()) {
            double x2 = this.lonToLambdaRad(lon);
            double y = 0.0;
            x2 = (double)this.outCenterX_ + x2 * this.rS_;
            y = (double)this.outCenterY_ - y * this.rS_;
            return new Point2D.Double(x2, y);
        }
        double phiRad = Math.toRadians(lat);
        double cosPhi = Math.cos(phiRad);
        double y = phiRad;
        if (this.isShowingInterrupted()) {
            double[] gore = this.getGore(lon, lat);
            double clon = gore[1];
            double dlon = MapUtils.normalizeMP180(lon) - clon;
            if (MapUtils.normalizeMP180(lon) > gore[2]) {
                dlon -= 360.0;
            }
            double dx = Math.toRadians(dlon) * cosPhi;
            double cx = this.lonToLambdaRad(clon);
            x = cx + dx;
        } else {
            x = this.lonToLambdaRad(lon) * cosPhi;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double phiRad = y * this.invRS_;
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double cosPhi = Math.cos(phiRad);
        double xFactor = cosPhi == 0.0 ? 0.0 : this.invRS_ / cosPhi;
        double lon = this.getLongitudeForX(x, xFactor, this.invRS_, phiRad > 0.0);
        if (Double.isNaN(lon)) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        return new PointLL(lon, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Sinusoidal sinusoidal = this;
        synchronized (sinusoidal) {
            for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double phiRad = y * this.invRS_;
                if (phiRad < -1.5707963267948966) continue;
                if (phiRad > 1.5707963267948966) break;
                double phi = Math.toDegrees(phiRad);
                double cosPhi = Math.cos(phiRad);
                double xFactor = cosPhi == 0.0 ? 0.0 : this.invRS_ / cosPhi;
                for (int ix = -this.dxMax_; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double lon = this.getLongitudeForX(x, xFactor, this.invRS_, phi > 0.0);
                    if (Double.isNaN(lon)) continue;
                    this.setPoint(ix, iy, lon, phi);
                }
            }
        }
    }
}

