/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.AzimuthalProjection;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TiltedPerspective
extends AzimuthalProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Tilted Perspective";
    public static final int PROPERTIES = 0xA00040;
    private static final double DEFAULT_P = 2.0;
    private double pp_;
    private double invP_;
    private double pMinus1_;
    private double pPlus1_;
    private double rhoMaxOverR_;
    private double cosGamma_;
    private double sinGamma_;
    private double cosOmega_;
    private double sinOmega_;
    private ProjDoubleParameter distParam_ = new ProjDoubleParameter("Distance between observer and center of body", "Center Distance", "Radii (P>1)", 2.0, 1.0, Double.POSITIVE_INFINITY, false, true);
    private ProjDoubleParameter azimParam_ = new ProjDoubleParameter("Azimuth angle", "Azimuth angle", "\u00b0", 0.0, 0.0, 360.0, true, true);
    private ProjDoubleParameter tiltParam_ = new ProjDoubleParameter("Tilt-up angle", "Tilt-up angle", "\u00b0", 0.0, -90.0, 90.0, true, false);

    public TiltedPerspective(int width, int height) {
        this(width, height, 0, 0);
    }

    public TiltedPerspective(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public TiltedPerspective(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0xA00040, width, height, xmargin, ymargin, 1.0, 1.0);
        this.addParameter(this.distParam_);
        this.addParameter(this.azimParam_);
        this.addParameter(this.tiltParam_);
        this.setZoomEnabled(true);
        this.setZoom(2.25);
        this.autoscale();
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null) {
            this.setCenterDistance(this.distParam_.getValue());
            this.setAzimuthAngle(this.azimParam_.getValue());
            this.setTiltAngle(this.tiltParam_.getValue());
        } else if (p == this.distParam_) {
            this.setCenterDistance(this.distParam_.getValue());
        } else if (p == this.azimParam_) {
            this.setAzimuthAngle(this.azimParam_.getValue());
        } else if (p == this.getParameter(2)) {
            this.setTiltAngle(this.tiltParam_.getValue());
        } else {
            throw new IllegalArgumentException("Unknown parameter");
        }
    }

    @Override
    public void setEdgeRadius(double r) {
        LOGGER.debug("Radius param not pertinent to this projection");
    }

    @Override
    public void setFillCorners(boolean fill) {
        LOGGER.debug("Fill param not pertinent to this projection");
    }

    public void setCenterDistance(double p) {
        this.pp_ = p;
        this.pMinus1_ = this.pp_ - 1.0;
        this.pPlus1_ = this.pp_ + 1.0;
        this.invP_ = 1.0 / this.pp_;
        this.autoscale();
    }

    public void setTiltAngle(double angle) {
        double omegaRad = Math.toRadians(angle);
        this.cosOmega_ = Math.cos(omegaRad);
        this.sinOmega_ = Math.sin(omegaRad);
        this.autoscale();
    }

    public void setAzimuthAngle(double angle) {
        double gamma = angle;
        double gammaRad = Math.toRadians(gamma);
        this.cosGamma_ = Math.cos(gammaRad);
        this.sinGamma_ = Math.sin(gammaRad);
        this.autoscale();
    }

    @Override
    protected void prepareScaling() {
        this.rhoMaxOverR_ = Math.sqrt(this.pMinus1_ / this.pPlus1_);
        this.setSizeFactor(this.rhoMaxOverR_);
    }

    @Override
    protected final void finishScaling() {
        this.rhoBorder_ = this.xmRS_;
        this.rhoBorder2_ = this.rhoBorder_ * this.rhoBorder_;
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double cosLambda = Math.cos(lambdaRad);
        double phiRad = Math.toRadians(lat);
        double cosPhi = Math.cos(phiRad);
        double sinPhi = Math.sin(phiRad);
        double cosZ = this.sinPhiC_ * sinPhi + this.cosPhiC_ * cosPhi * cosLambda;
        if (cosZ < this.invP_) {
            return null;
        }
        double k = this.pMinus1_ / (this.pp_ - cosZ);
        double x = k * cosPhi * Math.sin(lambdaRad);
        double y = k * (this.cosPhiC_ * sinPhi - this.sinPhiC_ * cosPhi * cosLambda);
        double xpp = x * this.cosGamma_ - y * this.sinGamma_;
        double ypp = y * this.cosGamma_ + x * this.sinGamma_;
        double a = ypp * this.sinOmega_ / this.pMinus1_ + this.cosOmega_;
        double xt = xpp * this.cosOmega_ / a;
        double yt = ypp / a;
        xt *= this.rS_;
        yt *= this.rS_;
        xt = (double)this.outCenterX_ + xt;
        yt = (double)this.outCenterY_ - yt;
        return new Point2D.Double(xt, yt);
    }

    @Override
    protected double getKForCosZ(double cosZ) {
        if (cosZ < this.invP_) {
            return -1.0;
        }
        return this.pMinus1_ / (this.pp_ - cosZ);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double xxx = xx - (double)this.outCenterX_;
        double xt = xxx * this.invRS_;
        double yyy = (double)this.outCenterY_ - yy;
        double yt = yyy * this.invRS_;
        double pMinus1MinusYtSinOmega = this.pMinus1_ - yt * this.sinOmega_;
        double mm = this.pMinus1_ * xt / pMinus1MinusYtSinOmega;
        double qq = this.pMinus1_ * yt * this.cosOmega_ / pMinus1MinusYtSinOmega;
        double x = mm * this.cosGamma_ + qq * this.sinGamma_;
        double y = qq * this.cosGamma_ - mm * this.sinGamma_;
        double rho2 = x * x + y * y;
        double rho = Math.sqrt(rho2);
        if (rho > this.rhoMaxOverR_) {
            return null;
        }
        double z = this.getZForRhoRS(rho);
        double[] lambdaPhi = this.calculateLambdaPhiFromXYRhoZ(x, y, rho, z);
        if (lambdaPhi == null) {
            return null;
        }
        double lambdaRad = lambdaPhi[0];
        double phiRad = lambdaPhi[1];
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        TiltedPerspective tiltedPerspective = this;
        synchronized (tiltedPerspective) {
            if (this.pMinus1_ <= 0.0) {
                return;
            }
            for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double yyy = (double)iy + 0.5;
                double yt = yyy * this.invRS_;
                double pMinus1MinusYtSinOmega = this.pMinus1_ - yt * this.sinOmega_;
                double qq = this.pMinus1_ * yt * this.cosOmega_ / pMinus1MinusYtSinOmega;
                for (int ix = -this.dxMax_; ix < this.dxMax_; ++ix) {
                    double z;
                    double[] lambdaPhi;
                    double xxx = (double)ix + 0.5;
                    double xt = xxx * this.invRS_;
                    double mm = this.pMinus1_ * xt / pMinus1MinusYtSinOmega;
                    double x = mm * this.cosGamma_ + qq * this.sinGamma_;
                    double y = qq * this.cosGamma_ - mm * this.sinGamma_;
                    double rho2 = x * x + y * y;
                    double rho = Math.sqrt(rho2);
                    if (rho > this.rhoMaxOverR_ || (lambdaPhi = this.calculateLambdaPhiFromXYRhoZ(x, y, rho, z = this.getZForRhoRS(rho))) == null) continue;
                    double lambdaRad = lambdaPhi[0];
                    double phiRad = lambdaPhi[1];
                    double phi = Math.toDegrees(phiRad);
                    double lambda = Math.toDegrees(lambdaRad);
                    this.setPoint(ix, iy, this.lambdaC_ + lambda, phi);
                }
            }
        }
    }

    @Override
    protected double getZForRhoRS(double rhoRS) {
        double sqrtCapK = rhoRS / this.pMinus1_;
        double capK = sqrtCapK * sqrtCapK;
        double capKPlus1 = capK + 1.0;
        double capKP = capK * this.pp_;
        double sqrtTerm = capKPlus1 - capKP * this.pp_;
        double cosZ = sqrtTerm > 0.0 ? (capKP + Math.sqrt(capKPlus1 - capKP * this.pp_)) / capKPlus1 : capKP / capKPlus1;
        return Math.acos(cosZ);
    }

    private void setPoint(int ix, int iy, double dlambda, double phi) {
        int srcX;
        int row = this.outCenterY_ - iy - 1;
        int col = this.outCenterX_ + ix;
        if (row < 0 || row >= this.outHeight_ || col < 0 || col >= this.outWidth_) {
            return;
        }
        double lon = dlambda;
        int index = row * this.outWidth_ + col;
        this.invArrayLon_[index] = MapUtils.normalize360(lon);
        this.invArrayLat_[index] = phi;
        int srcY = this.getSrcPixelY(phi);
        if (srcY > -1 && (srcX = this.getSrcPixelX(lon)) > -1) {
            this.invArray_[index] = srcY * this.srcWidth_ + srcX;
        }
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
    }
}

