/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.map.proj.ProjectionUtils;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class ToblerG1
extends GlobalPseudocylindric {
    public static final String PROJECTION_NAME = "Tobler G1";
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = Math.sqrt(1.5707963267948966);
    private ProjDoubleParameter ceaParam_;
    private double ceaWgt_ = 0.5;
    private double sinWgt_ = 1.0 - this.ceaWgt_;

    public ToblerG1(int width, int height) {
        this(width, height, 0, 0);
    }

    public ToblerG1(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public ToblerG1(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, Math.PI, HEIGHT_FACTOR);
        this.ceaParam_ = new ProjDoubleParameter("Weighting of CEA projection", "CEA Wgt", "(0\u2264\u03b1\u22641)", 0.5, 0.0, 1.0, true, true);
        this.addParameter(this.ceaParam_);
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p != null && p != this.ceaParam_) {
            throw new IllegalArgumentException("Unknown parameter");
        }
        this.setCEAWeight(this.ceaParam_.getValue());
    }

    public void setCEAWeight(double ceaWgt) {
        this.ceaWgt_ = ceaWgt;
        this.sinWgt_ = 1.0 - this.ceaWgt_;
        this.autoscale();
    }

    @Override
    protected void prepareScaling() {
        double yfactor = 1.0;
        yfactor = this.ceaWgt_ == 1.0 ? 1.0 : (this.ceaWgt_ == 0.0 ? 1.5707963267948966 : Math.pow(1.5707963267948966, this.sinWgt_));
        this.setSizeFactors(Math.PI, yfactor);
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double x;
        double y;
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        if (Math.abs(lat) < 1.0E-10) {
            y = 0.0;
            x = lambdaRad;
        } else {
            double phiRad = Math.toRadians(lat);
            double absPhiRad = Math.abs(phiRad);
            double sinPhi = Math.sin(absPhiRad);
            double cosPhi = Math.cos(absPhiRad);
            y = Math.pow(absPhiRad, this.sinWgt_) * Math.pow(sinPhi, this.ceaWgt_);
            x = lambdaRad * cosPhi * Math.pow(absPhiRad, this.ceaWgt_) * Math.pow(sinPhi, this.sinWgt_) / (this.sinWgt_ * sinPhi + this.ceaWgt_ * absPhiRad * cosPhi);
        }
        if (lat < 0.0) {
            y = -y;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double absY = Math.abs(y);
        if (Math.abs(x) > (double)this.dxMax_ || absY > (double)this.dyMax_) {
            return null;
        }
        if (absY > this.ymRS_) {
            return null;
        }
        if (absY < 1.0E-5) {
            double phi = 0.0;
            double lambda = Math.toDegrees(x * this.invRS_);
            return new PointLL(this.lambdaC_ + lambda, 0.0);
        }
        double absPhiRad = this.iterateAbsYToPhiRad(absY);
        double sinPhi = Math.sin(absPhiRad);
        double cosPhi = Math.cos(absPhiRad);
        double phiTerm = cosPhi * Math.pow(absPhiRad, this.ceaWgt_) * Math.pow(sinPhi, this.sinWgt_) / (this.sinWgt_ * sinPhi + this.ceaWgt_ * absPhiRad * cosPhi);
        double lambdaRad = x * this.invRS_ / phiTerm;
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phiRad = y > 0.0 ? absPhiRad : -absPhiRad;
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        ToblerG1 toblerG1 = this;
        synchronized (toblerG1) {
            double y;
            double phiRad = 0.0;
            for (int iy = 0; iy < this.dyMax_ && !((y = (double)iy + 0.5) > this.ymRS_) && !((phiRad = this.iterateAbsYToPhiRad(y)) > 1.5707963267948966); ++iy) {
                double x;
                double lambdaRad;
                double phi = Math.toDegrees(phiRad);
                double sinPhi = Math.sin(phiRad);
                double cosPhi = Math.cos(phiRad);
                double phiTerm = cosPhi * Math.pow(phiRad, this.ceaWgt_) * Math.pow(sinPhi, this.sinWgt_) / (this.sinWgt_ * sinPhi + this.ceaWgt_ * phiRad * cosPhi);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * this.invRS_ / phiTerm) > Math.PI); ++ix) {
                    this.set4SymmetricPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }

    private double iterateAbsYToPhiRad(double absY) {
        double yOverRS = absY * this.invRS_;
        if (yOverRS < 1.0E-10) {
            return 0.0;
        }
        double phiRad = 1.5707963267948966 * yOverRS / this.ymRS_;
        if (phiRad > 1.5707963267948966) {
            phiRad = 1.4707963267948965;
        }
        for (int iter = 0; iter < 33; ++iter) {
            double sinPhi = Math.sin(phiRad);
            double left = Math.pow(phiRad, this.sinWgt_);
            double right = Math.pow(sinPhi, this.ceaWgt_);
            double dleft = this.sinWgt_ * Math.pow(phiRad, this.sinWgt_ - 1.0);
            double dright = this.ceaWgt_ * Math.pow(sinPhi, this.ceaWgt_ - 1.0);
            double func = left * right - yOverRS;
            double dfunc = dleft * right + left * dright;
            double dphiRad = -func / dfunc;
            phiRad += dphiRad;
            if (Math.abs(dphiRad) < 1.0E-5) break;
        }
        return phiRad;
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        if (this.ceaWgt_ < 1.0) {
            super.drawBorderLines(g2d);
        } else {
            ProjectionUtils.drawRectBorder(g2d, this.outCenterX_ - this.dxMax_, this.outCenterY_ - this.dyMax_, 2.0 * (double)this.dxMax_, 2.0 * (double)this.dyMax_);
        }
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        if (this.ceaWgt_ < 1.0) {
            super.drawParallel(g2d, lat, label);
        } else {
            double llon = this.lambdaC_ + -179.99999;
            double rlon = this.lambdaC_ + 179.99999;
            Point2D.Double dot1 = this.transformLL2XY(llon, lat);
            Point2D.Double dot2 = this.transformLL2XY(rlon, lat);
            if (dot1 == null || dot2 == null) {
                return;
            }
            GraphicUtils.drawLine(g2d, dot1, dot2);
        }
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        if (this.ceaWgt_ < 1.0) {
            super.drawMeridian(g2d, lon, label);
        } else {
            double dlon = MapUtils.normalize360(lon - this.lambdaC_);
            if (Math.abs(dlon - 180.0) < 1.0E-5) {
                return;
            }
            Point2D.Double dot = this.transformLL2XY(lon, 0.0);
            if (dot == null) {
                return;
            }
            float top = this.outCenterY_ - this.dyMax_;
            float bottom = this.outCenterY_ + this.dyMax_;
            GraphicUtils.drawLine(g2d, dot.x, top, dot.x, bottom);
        }
    }
}

