/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.ProjectionUtils;
import java.awt.Graphics2D;
import java.awt.Insets;

public abstract class TwoHemisphereGlobularProjection
extends AbstractProjection {
    protected double rhoBorder_;
    protected double rhoBorder2_;
    protected int leftCenterX_;
    protected int rightCenterX_;

    public TwoHemisphereGlobularProjection(String name, int properties, int width, int height, int xmargin, int ymargin, double rMaxOverR) {
        super(name, properties, width, height, xmargin, ymargin, 2.04 * rMaxOverR, rMaxOverR);
        this.autoscale();
    }

    @Override
    protected final void finishScaling() {
        this.rhoBorder_ = this.rS_ * 1.5707963267948966;
        this.rhoBorder2_ = this.rhoBorder_ * this.rhoBorder_;
        Insets ins = this.getInsets();
        this.leftCenterX_ = (int)(0.5 * (double)(this.outCenterX_ + ins.left));
        this.rightCenterX_ = (int)(0.5 * (double)(this.outCenterX_ + this.outWidth_ - ins.right));
    }

    protected void setEightPoints(int ix, int iy, double lambdaP, double phiP) {
        this.setPoint(true, ix, iy, this.lambdaC_ + lambdaP, phiP);
        this.setPoint(true, ix, -iy - 1, this.lambdaC_ + lambdaP, -phiP);
        this.setPoint(true, -ix - 1, -iy - 1, this.lambdaC_ - lambdaP, -phiP);
        this.setPoint(true, -ix - 1, iy, this.lambdaC_ - lambdaP, phiP);
        this.setPoint(false, ix, iy, this.lambdaC_ + lambdaP + 180.0, phiP);
        this.setPoint(false, ix, -iy - 1, this.lambdaC_ + lambdaP + 180.0, -phiP);
        this.setPoint(false, -ix - 1, -iy - 1, this.lambdaC_ - lambdaP + 180.0, -phiP);
        this.setPoint(false, -ix - 1, iy, this.lambdaC_ - lambdaP + 180.0, phiP);
    }

    private void setPoint(boolean leftside, int ix, int iy, double dlambda, double phi) {
        int srcX;
        int col = leftside ? this.leftCenterX_ + ix : this.rightCenterX_ + ix;
        int row = this.outCenterY_ - iy - 1;
        if (row < 0 || row >= this.outHeight_ || col < 0 || col >= this.outWidth_) {
            return;
        }
        double lon = dlambda;
        int index = row * this.outWidth_ + col;
        this.invArrayLon_[index] = MapUtils.normalize360(lon);
        this.invArrayLat_[index] = phi;
        int srcY = this.getSrcPixelY(phi);
        if (srcY > -1 && (srcX = this.getSrcPixelX(lon)) > -1) {
            this.invArray_[index] = srcY * this.srcWidth_ + srcX;
        }
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        ProjectionUtils.drawEllipse(g2d, this.leftCenterX_, this.outCenterY_, this.rhoBorder_, this.rhoBorder_);
        ProjectionUtils.drawEllipse(g2d, this.rightCenterX_, this.outCenterY_, this.rhoBorder_, this.rhoBorder_);
    }
}

