/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.shapefile;

import gov.nasa.giss.map.LonLatBounds;
import gov.nasa.giss.map.shapefile.ShapeRecordType;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ShapeRecord {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected ShapeRecordType recordType_ = ShapeRecordType.NULL;
    protected int numParts_;
    protected int numPoints_;
    protected int recNum_ = -1;
    protected double left_;
    protected double top_;
    protected double right_;
    protected double bottom_;

    void readFromBuffer(int recNum, byte[] buffer) {
        this.recNum_ = recNum;
        this.readFromBuffer(buffer);
    }

    abstract void readFromBuffer(byte[] var1);

    public ShapeRecordType getType() {
        return this.recordType_;
    }

    public boolean isNull() {
        return this.recordType_ == ShapeRecordType.NULL;
    }

    public boolean isPoint() {
        return this.recordType_ == ShapeRecordType.POINT || this.recordType_ == ShapeRecordType.POINT_M || this.recordType_ == ShapeRecordType.POINT_Z;
    }

    public boolean isMultiPoint() {
        return this.recordType_ == ShapeRecordType.MULTIPOINT || this.recordType_ == ShapeRecordType.MULTIPOINT_M || this.recordType_ == ShapeRecordType.MULTIPOINT_Z;
    }

    public boolean isPolyline() {
        return this.recordType_ == ShapeRecordType.POLYLINE || this.recordType_ == ShapeRecordType.POLYLINE_M || this.recordType_ == ShapeRecordType.POLYLINE_Z;
    }

    public boolean isPolygon() {
        return this.recordType_ == ShapeRecordType.POLYGON || this.recordType_ == ShapeRecordType.POLYGON_M || this.recordType_ == ShapeRecordType.POLYGON_Z;
    }

    public boolean isMultiPatch() {
        return this.recordType_ == ShapeRecordType.MULTIPATCH;
    }

    public boolean isMeasureType() {
        return this.recordType_ == ShapeRecordType.POINT_M || this.recordType_ == ShapeRecordType.MULTIPOINT_M || this.recordType_ == ShapeRecordType.POLYLINE_M || this.recordType_ == ShapeRecordType.POLYGON_M;
    }

    public boolean isZType() {
        return this.recordType_ == ShapeRecordType.POINT_Z || this.recordType_ == ShapeRecordType.MULTIPOINT_Z || this.recordType_ == ShapeRecordType.POLYLINE_Z || this.recordType_ == ShapeRecordType.POLYGON_Z;
    }

    public int numberOfParts() {
        return this.numParts_;
    }

    public int numberOfPoints() {
        return this.numPoints_;
    }

    public LonLatBounds getBounds() {
        try {
            return new LonLatBounds(this.left_, this.top_, this.right_, this.bottom_);
        }
        catch (Exception exc) {
            LOGGER.debug("LonLatBounds rejected {}, {}, {}, {}", this.left_, this.top_, this.right_, this.bottom_);
            return null;
        }
    }

    public abstract Point2D.Double[] getPoints(int var1);
}

