/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action;

import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.util.PanPlotType;
import gov.nasa.giss.panoply.util.PanProperties;
import java.awt.event.ActionEvent;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanInterpolateAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PanPlotMeta pmeta_;
    private PanPlotType plotType_;
    private JCheckBox interpolateCB_;
    private long last_;
    private boolean busy_;

    public PanInterpolateAction(PanPlotMeta pmeta, JCheckBox interpolateCB) {
        super(PanProperties.MENU_PROPS.getString("interpolate"));
        this.pmeta_ = pmeta;
        this.plotType_ = pmeta.getType();
        this.interpolateCB_ = interpolateCB;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.plotType_.isLinePlot()) {
            return;
        }
        LOGGER.trace("busy {}", (Object)this.busy_);
        if (this.busy_) {
            return;
        }
        this.busy_ = true;
        PanPlotFrame pf = this.pmeta_.getFrame();
        if (pf == null) {
            this.busy_ = false;
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.last_ < 200L && e.getSource() instanceof JCheckBoxMenuItem) {
            LOGGER.debug("Too soon, {}; do nothing", (Object)(now - this.last_));
        } else {
            boolean oldValue = this.pmeta_.getBoolean("interpolate");
            boolean newValue = !oldValue;
            this.interpolateCB_.setSelected(newValue);
            this.pmeta_.setBoolean("interpolate", newValue);
        }
        this.pmeta_.getFrame().refreshMenu("plot-menu");
        this.last_ = now;
        this.busy_ = false;
    }
}

