/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action;

import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.ui.PanStringComboBox;
import gov.nasa.giss.panoply.util.PanActionHash;
import gov.nasa.giss.panoply.util.PanProperties;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class PanLonLatPlotTypeAction
extends AbstractAction {
    private final PanPlotMeta pmeta_;
    private final PanStringComboBox lonlatTypeCombo_;
    private boolean busy_;

    public PanLonLatPlotTypeAction(PanPlotMeta pmeta, PanStringComboBox lonlatTypeCombo) {
        super("Plot Type");
        this.pmeta_ = pmeta;
        this.lonlatTypeCombo_ = lonlatTypeCombo;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean isMap;
        if (this.busy_) {
            return;
        }
        this.busy_ = true;
        PanPlotFrame pf = this.pmeta_.getFrame();
        if (pf == null) {
            this.busy_ = false;
            return;
        }
        PanMenuBar mbar = pf.getPanMenuBar();
        String m1 = PanProperties.MENU_PROPS.getString("plot-type-m1");
        String m2 = PanProperties.MENU_PROPS.getString("plot-type-m2");
        String z1 = PanProperties.MENU_PROPS.getString("plot-type-z1");
        String z2 = PanProperties.MENU_PROPS.getString("plot-type-z2");
        String current = this.pmeta_.getString("lonlat.lltype");
        boolean bl = isMap = current.equalsIgnoreCase(z1) || current.equalsIgnoreCase(z2);
        if (isMap) {
            this.lonlatTypeCombo_.setSelectedItem(m1);
            mbar.getItemByName("plot-menu", "plot-type").setText(z2);
        } else {
            this.lonlatTypeCombo_.setSelectedItem(z1);
            mbar.getItemByName("plot-menu", "plot-type").setText(m2);
        }
        try {
            PanActionHash actionHash = this.pmeta_.getActionHash();
            actionHash.enable("swap-xbounds", !isMap);
        }
        catch (Exception actionHash) {
            // empty catch block
        }
        String becomes = isMap ? m1 : z1;
        this.pmeta_.setString("lonlat.lltype", becomes);
        pf.refresh();
        mbar.refresh();
        this.busy_ = false;
    }
}

