/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action;

import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.util.PanProperties;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class PanTallerPlotAction
extends AbstractAction {
    private static final String ACTION_NAME = PanProperties.MENU_PROPS.getString("show-taller");
    private final PanPlotFrame pframe_;

    public PanTallerPlotAction(PanPlotFrame pframe) {
        super(ACTION_NAME);
        this.pframe_ = pframe;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PanPlotMeta pmeta = this.pframe_.getMeta();
        int oldHF = pmeta.getInt("size.height");
        if (oldHF >= 400) {
            this.setEnabled(false);
        } else if (oldHF < 350) {
            this.setEnabled(true);
            this.pframe_.setHeightFactor(oldHF + 5);
        } else {
            this.setEnabled(true);
            this.pframe_.setHeightFactor(oldHF + 10);
        }
        this.pframe_.refreshMenu("plot-menu");
    }
}

