/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action.dialog;

import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.ui.PanStringComboBox;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanCombinePlotDialog
extends JDialog {
    private final PanSourcesFrame pframe_;
    private PanStringComboBox plotCombo_;
    private JButton combineButton_;
    private JButton cancelButton_;
    private boolean success_;

    public PanCombinePlotDialog(PanSourcesFrame pframe) {
        super(pframe, "Combine Plot", true);
        this.pframe_ = pframe;
        this.setResizable(false);
        this.createLayout();
        this.attachListeners();
    }

    private final void createLayout() {
        JLabel label = new JLabel("In which existing plot should I combine the variable?");
        this.plotCombo_ = PanStringComboBox.create();
        for (PanPlotFrame frame : PanGuiUtils.getPlotFrames()) {
            this.plotCombo_.addItem(frame.getTitle());
        }
        this.combineButton_ = new JButton("Combine");
        this.cancelButton_ = new JButton("Cancel");
        QuickBox buttonBox = PlatformUtils.isMacintosh() ? QuickBox.createRightBox(this.cancelButton_, this.combineButton_) : QuickBox.createRightBox(this.combineButton_, this.cancelButton_);
        JPanel contentPanel = new JPanel();
        FlexingGridLayout fgl = new FlexingGridLayout(2, 5, 0, 8);
        contentPanel.setLayout(fgl);
        contentPanel.setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
        contentPanel.add((Component)label, new FGConstraint(0, 1));
        if (label.getPreferredSize().width > this.plotCombo_.getPreferredSize().width) {
            contentPanel.add((Component)this.plotCombo_, new FGConstraint(0, 2, 0.5));
        } else {
            contentPanel.add((Component)this.plotCombo_, new FGConstraint(0, 2));
        }
        contentPanel.add((Component)buttonBox, new FGConstraint(0, 4, 1.0));
        this.getContentPane().add(contentPanel);
        Dimension d = this.plotCombo_.getPreferredSize();
        if (d.width > 400) {
            d.width = 400;
            this.plotCombo_.setMaximumSize(d);
        }
        this.getRootPane().setDefaultButton(this.combineButton_);
        this.pack();
        Rectangle rr = this.pframe_.getBounds();
        Dimension psize = this.getContentPane().getPreferredSize();
        int x = (rr.width - psize.width) / 2;
        int y = (rr.height - psize.height) / 2;
        this.setLocation(rr.x + x, rr.y + y);
    }

    @Override
    public void setVisible(boolean vis) {
        if (vis) {
            EventQueue.invokeLater(() -> this.combineButton_.requestFocusInWindow());
        }
        super.setVisible(vis);
    }

    private final void attachListeners() {
        this.combineButton_.addActionListener(e -> {
            this.success_ = true;
            this.setVisible(false);
        });
        this.cancelButton_.addActionListener(e -> this.setVisible(false));
    }

    public boolean isSuccessful() {
        return this.success_;
    }

    public String getTarget() {
        return (String)this.plotCombo_.getSelectedItem();
    }
}

