/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.cl;

import gov.nasa.giss.graphics.ColorTableFilenameFilter;
import gov.nasa.giss.graphics.ColorTableResourceList;
import gov.nasa.giss.map.ProjectionFactory;
import gov.nasa.giss.map.overlay.OverlayFilenameFilter;
import gov.nasa.giss.map.overlay.OverlayResourceList;
import gov.nasa.giss.panoply.cl.PCLDataset;
import gov.nasa.giss.panoply.cl.PCLPlot;
import gov.nasa.giss.panoply.cl.PCLPreferences;
import gov.nasa.giss.panoply.cl.PCLVariable;
import gov.nasa.giss.panoply.util.PanLoggingUtils;
import gov.nasa.giss.panoply.util.PanUtils;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PCLFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static PCLFactory getSharedInstance() {
        return Singleton.INSTANCE;
    }

    public PCLPlot createPlot(String ptype, PCLVariable clvar) {
        return this.createPlot(ptype, clvar, new String[]{null});
    }

    public PCLPlot createPlot(String ptype, PCLVariable clvar, String ... axisInfo) {
        if (axisInfo == null || axisInfo.length == 0 || axisInfo[0] == null) {
            return PCLPlot.createGeoreferencedPlot(ptype, clvar);
        }
        if (axisInfo.length == 1) {
            int index = -1;
            try {
                index = Integer.parseInt(axisInfo[0]);
                --index;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (index > -1) {
                return PCLPlot.createLinePlot(ptype, clvar, index);
            }
            return PCLPlot.createLinePlot(ptype, clvar, axisInfo[0]);
        }
        if (axisInfo.length == 2) {
            int xindex = -1;
            int yindex = -1;
            try {
                xindex = Integer.parseInt(axisInfo[0]) - 1;
                yindex = Integer.parseInt(axisInfo[1]) - 1;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (xindex > -1 && yindex > -1) {
                return PCLPlot.createStandard2DPlot(ptype, clvar, xindex, yindex);
            }
            return PCLPlot.createStandard2DPlot(ptype, clvar, axisInfo[0], axisInfo[1]);
        }
        throw new IllegalArgumentException("Too many arguments to create a plot.");
    }

    public void openColorTable(String fpath, boolean importToLib) {
        File f = new File(fpath);
        if (!ColorTableFilenameFilter.isColorTableName(f)) {
            LOGGER.error("File name does not look like a color table.");
            return;
        }
        ColorTableResourceList reslist = PanUtils.getColorTableResourceList();
        reslist.addAlphabetic(null, importToLib, f);
    }

    public PCLDataset openDataset(String address) {
        return new PCLDataset(address);
    }

    public void openOverlay(String fpath, boolean importToLib) {
        File f = new File(fpath);
        if (!OverlayFilenameFilter.isOverlayName(f)) {
            LOGGER.error("File name does not look like an overlay.");
            return;
        }
        OverlayResourceList reslist = PanUtils.getOverlayResourceList();
        reslist.addAlphabetic(null, importToLib, f);
    }

    public void printProjectionList() {
        System.out.println("Projections available for lon-lat map plots are:");
        for (String name : ProjectionFactory.getNormalizedNames()) {
            System.out.println(name);
        }
    }

    public void printProjectionInfo(String pname) {
        try {
            System.out.println(ProjectionFactory.describeProjection(pname));
        }
        catch (Exception exc) {
            if (exc.toString().toLowerCase().contains("unknown")) {
                System.out.println("There is no projection known by that name.");
            }
            System.out.printf("Exception querying for '%s': %s%n", pname, exc.toString());
        }
    }

    public void printColorTableList() {
        System.out.println("Color tables available for plots are:");
        for (String name : PanUtils.getColorTableResourceList().getNames()) {
            System.out.println(name);
        }
    }

    public void printOverlayList() {
        System.out.println("Overlays available for lon-lat plots are:");
        for (String name : PanUtils.getOverlayResourceList().getNames()) {
            System.out.println(name);
        }
    }

    public PCLPreferences getPreferences() {
        return PCLPreferences.getSharedInstance();
    }

    public void printMemory() {
        LOGGER.info("Max memory heap is {} MB", (Object)(Runtime.getRuntime().maxMemory() / 1000L / 1000L));
    }

    public void setLocale(String ... lname) {
        if (lname.length == 1) {
            Locale.setDefault(new Locale(lname[0]));
        } else if (lname.length == 2) {
            Locale.setDefault(new Locale(lname[0], lname[1]));
        } else if (lname.length == 3) {
            Locale.setDefault(new Locale(lname[0], lname[1], lname[2]));
        } else {
            LOGGER.warn("Bad parameter count for specifying locale.");
        }
        this.printLocale();
    }

    public void printLocale() {
        Locale locale = Locale.getDefault();
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance();
        System.out.printf("Locale is '%s'%n", locale.getDisplayName());
        System.out.printf("Locale language is '%s'%n", locale.getDisplayLanguage());
        System.out.printf("Locale country is '%s'%n", locale.getDisplayCountry());
        System.out.printf("Locale variant is '%s'%n", locale.getDisplayVariant());
        System.out.printf("Locale decimal character is '%s'%n", Character.valueOf(symbols.getDecimalSeparator()));
    }

    public void setLogLevel(String level) {
        PanLoggingUtils.setLogLevel(level.toUpperCase());
    }

    private PCLFactory() {
    }

    private static class Singleton {
        private static final PCLFactory INSTANCE = new PCLFactory();

        private Singleton() {
        }
    }
}

