/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.io;

import gov.nasa.giss.data.nc.NcConfig;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcFilenameFilter;
import gov.nasa.giss.graphics.ColorTableFilenameFilter;
import gov.nasa.giss.graphics.ColorTableResourceList;
import gov.nasa.giss.io.FileUtils;
import gov.nasa.giss.io.FtypeInfo;
import gov.nasa.giss.io.FtypeInfoHash;
import gov.nasa.giss.macos.MacNative;
import gov.nasa.giss.map.kml.KMLDataFilenameFilter;
import gov.nasa.giss.map.kml.KMLDataResourceList;
import gov.nasa.giss.map.overlay.OverlayFilenameFilter;
import gov.nasa.giss.map.overlay.OverlayResourceList;
import gov.nasa.giss.panoply.Panoply;
import gov.nasa.giss.panoply.action.task.PanOpenCatalogTask;
import gov.nasa.giss.panoply.action.task.PanOpenDatasetTask;
import gov.nasa.giss.panoply.io.PanGribTableOptionsDialog;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.panoply.ui.PanFrame;
import gov.nasa.giss.panoply.util.PanUtils;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.filechooser.OpenFileChooser;
import gov.nasa.giss.ui.filechooser.SaveFileChooser;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Objects;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanFileUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final PanPreferences PREFS = PanPreferences.getSharedInstance();
    private static final String REMOTE_DATASET_MESSAGE = "Enter the URL of a remote dataset to open:";
    private static final String REMOTE_CATALOG_MESSAGE = "Enter the URL of a remote THREDDS or OpenDAP catalog to open:";
    public static final String DOT = ".";
    private static final String DEFAULT_IMG_EXT = "png";
    private static boolean macosNative_;
    private static FtypeInfoHash inputFtypes_;
    private static FtypeInfoHash outputFtypes_;

    public static File[] showOpenAnyFileChooser(PanFrame pframe) {
        return PanFileUtils.showOpenLocalFileChooser(pframe, "Open", "all", "data", "nc", "hdf", "grib", "gem", "ctab", "act", "cpt", "cwc", "gct", "rgb", "olay", "cno", "shp", "mask", "any");
    }

    public static File[] showOpenDataFileChooser(PanFrame pframe) {
        return PanFileUtils.showOpenLocalFileChooser(pframe, "Open", "data", "nc", "hdf", "grib", "gem");
    }

    public static File[] showOpenColorTableFileChooser(PanFrame pframe) {
        return PanFileUtils.showOpenLocalFileChooser(pframe, "Open Color Table", "ctab", "act", "cpt", "cwc", "gct", "rgb");
    }

    public static File[] showOpenOverlayFileChooser(PanFrame pframe) {
        return PanFileUtils.showOpenLocalFileChooser(pframe, "Open Overlay", "olay", "cno", "shp", "mask");
    }

    public static File[] showOpenKMLFileChooser(PanFrame pframe) {
        return PanFileUtils.showOpenLocalFileChooser(pframe, "Open Ground Overlay", "kml");
    }

    private static File[] showOpenLocalFileChooser(PanFrame pframe, String title, String ... ftypeKeys) {
        String startpath = PREFS.getString("files:open.path");
        String[][] ftypeData = inputFtypes_.toFtypeInfoArray(ftypeKeys);
        File[] ff = null;
        if (macosNative_) {
            MacNative panel = new MacNative();
            String[] paths = panel.showOpenDialog("Open\u2026", ftypeData, startpath, ftypeKeys[0], false, true);
            if (paths == null) {
                return null;
            }
            ff = new File[paths.length];
            for (int i = 0; i < paths.length; ++i) {
                ff[i] = new File(paths[i]);
            }
        } else {
            OpenFileChooser chooser = new OpenFileChooser();
            chooser.setCurrentDirectory(startpath);
            chooser.setDialogTitle(title);
            chooser.addFtypeDataFilters(ftypeData);
            int returnVal = chooser.showOpenDialog(pframe);
            if (returnVal == 0) {
                ff = chooser.getSelectedFiles();
            }
        }
        if (ff == null) {
            return null;
        }
        PREFS.set("files:open.path", ff[0].getParent());
        return ff;
    }

    public static URL showOpenRemoteDatasetDialog(PanFrame pframe) {
        return PanFileUtils.showOpenRemoteDialog(pframe, REMOTE_DATASET_MESSAGE);
    }

    public static URL showOpenRemoteCatalogDialog(PanFrame pframe) {
        return PanFileUtils.showOpenRemoteDialog(pframe, REMOTE_CATALOG_MESSAGE);
    }

    private static URL showOpenRemoteDialog(PanFrame pframe, String loadMessage) {
        JOptionPane loadPane = new JOptionPane("", 3, 0, null, new String[]{"Load", "Cancel"});
        loadPane.setWantsInput(true);
        loadPane.setMessage(loadMessage);
        Dimension d = loadPane.getPreferredSize();
        if (d.width < 540) {
            d.width = 540;
            loadPane.setPreferredSize(d);
            loadPane.setPreferredSize(d);
        }
        loadPane.createDialog(pframe, "Open Remote").setVisible(true);
        Object choice = loadPane.getValue();
        if (choice == null) {
            return null;
        }
        if (!choice.toString().equals("Load")) {
            return null;
        }
        String urlString = loadPane.getInputValue().toString();
        if (urlString == null || urlString.isEmpty()) {
            return null;
        }
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (Exception exc) {
            GuiUtils.showSlowMessage(pframe, "File Error", "The URL appears to be invalid.");
            return null;
        }
        return url;
    }

    public static File showSaveImageFileChooser(PanFrame pframe, String fnameRoot, String fnameExt) {
        String[][] ftypeData = outputFtypes_.toFtypeInfoArray("gif", "jpeg", "pdf", DEFAULT_IMG_EXT, "ps", "tiff");
        String xfnameExt = fnameExt;
        File file = null;
        String dpath = PREFS.getString("files:save.path");
        if (dpath.isEmpty()) {
            dpath = null;
        }
        String fullname = fnameRoot + DOT + xfnameExt;
        if (!((FtypeInfo)outputFtypes_.get("img")).accepts(fullname)) {
            xfnameExt = DEFAULT_IMG_EXT;
            fullname = fnameRoot + DOT + DEFAULT_IMG_EXT;
        }
        if (macosNative_) {
            MacNative panel;
            String result;
            if (dpath.isEmpty()) {
                dpath = null;
            }
            if ((result = (panel = new MacNative()).showSaveDialog("Save image as\u2026", ftypeData, dpath, fullname, xfnameExt)) == null) {
                return null;
            }
            file = new File(result);
        } else {
            SaveFileChooser chooser = new SaveFileChooser(ftypeData);
            if (dpath != null) {
                try {
                    chooser.setCurrentDirectory(new File(dpath));
                }
                catch (Exception result) {
                    // empty catch block
                }
            }
            chooser.setFileName(fullname);
            chooser.setExtension(xfnameExt);
            int returnVal = chooser.showSaveDialog(pframe);
            if (returnVal != 0) {
                return null;
            }
            file = chooser.getSelectedFile();
        }
        if (file == null) {
            return null;
        }
        String fname = file.getName();
        String xfnameRoot = FileUtils.extractFnameRoot(file);
        boolean goodExtension = ((FtypeInfo)outputFtypes_.get("img")).accepts(file);
        if (!goodExtension) {
            xfnameRoot = fname;
            xfnameExt = DEFAULT_IMG_EXT;
            fname = xfnameRoot + DOT + DEFAULT_IMG_EXT;
            file = new File(file.getParent(), fname);
        }
        PREFS.set("files:save.path", file.getParent());
        return file;
    }

    public static File showSingleTypeSaveFileChooser(PanFrame pframe, String title, String ftype, String fnameRoot, String fnameExt) {
        String dotExt;
        String[][] ftypeData = outputFtypes_.toFtypeInfoArray(fnameExt);
        String dpath = PREFS.getString("files:save.path");
        String fullname = fnameRoot + DOT + fnameExt;
        File file = null;
        if (macosNative_) {
            MacNative panel;
            String result;
            if (dpath.isEmpty()) {
                dpath = null;
            }
            if ((result = (panel = new MacNative()).showSaveDialog(title, ftypeData, dpath, fullname, fnameExt)) == null) {
                return null;
            }
            file = new File(result);
        } else {
            SaveFileChooser chooser = new SaveFileChooser(ftypeData);
            if (dpath.length() > 0) {
                try {
                    chooser.setCurrentDirectory(new File(dpath));
                }
                catch (Exception result) {
                    // empty catch block
                }
            }
            chooser.setDialogTitle(title);
            chooser.setFileName(fullname);
            chooser.setExtension(fnameExt);
            int returnVal = chooser.showSaveDialog(pframe);
            if (returnVal != 0) {
                return null;
            }
            file = chooser.getSelectedFile();
        }
        if (file == null) {
            return null;
        }
        PREFS.set("files:save.path", file.getParent());
        String xfnameRoot = FileUtils.extractFnameRoot(file);
        if (xfnameRoot == null) {
            return null;
        }
        String fname = file.getName();
        String lcname = fname.toLowerCase();
        if (!lcname.endsWith(dotExt = DOT + fnameExt.toLowerCase())) {
            file = new File(file.getParent(), fname + dotExt);
        }
        return file;
    }

    public static Object openLocalFiles(PanFrame parent, File ... files) {
        if (files == null) {
            return null;
        }
        ArrayList<File> datasets = new ArrayList<File>(5);
        ArrayList<File> ctables = new ArrayList<File>(5);
        ArrayList<File> overlays = new ArrayList<File>(5);
        ArrayList<File> kmls = new ArrayList<File>(5);
        for (File f : files) {
            if (f == null) continue;
            if (ColorTableFilenameFilter.isColorTableName(f)) {
                ctables.add(f);
                continue;
            }
            if (OverlayFilenameFilter.isOverlayName(f)) {
                overlays.add(f);
                continue;
            }
            if (KMLDataFilenameFilter.isKMLName(f)) {
                kmls.add(f);
                continue;
            }
            datasets.add(f);
        }
        if (!ctables.isEmpty()) {
            ColorTableResourceList reslist = PanUtils.getColorTableResourceList();
            if (PREFS.getBoolean("files:autoimport.colorbars")) {
                reslist.addAlphabetic((Component)parent, true, ctables.toArray(new File[0]));
            } else {
                reslist.addAlphabetic((Component)parent, ctables);
            }
        }
        if (!overlays.isEmpty()) {
            OverlayResourceList olset = PanUtils.getOverlayResourceList();
            if (PREFS.getBoolean("files:autoimport.overlays")) {
                olset.addAlphabetic((Component)parent, true, overlays.toArray(new File[0]));
            } else {
                olset.addAlphabetic((Component)parent, overlays);
            }
        }
        if (!kmls.isEmpty()) {
            KMLDataResourceList kmlset = PanUtils.getUnderlayResourceList();
            kmlset.addAlphabetic((Component)parent, kmls);
        }
        if (!datasets.isEmpty()) {
            Object o = null;
            for (File f : datasets) {
                o = PanFileUtils.openLocalDataset(parent, f);
            }
            return o;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object openLocalDataset(PanFrame parent, File f) {
        Objects.requireNonNull(f, "Address cannot be null.");
        if (!f.exists()) {
            FileUtils.showFileError((Component)parent, f.getName(), "File doesn't seem to exist.");
            return null;
        }
        if (NcFilenameFilter.accept(f)) {
            PanSourcesFrame sourcesFrame;
            PanSourcesFrame panSourcesFrame = sourcesFrame = PanSourcesFrame.getSharedInstance();
            synchronized (panSourcesFrame) {
                PanFileUtils.openDataset(f);
                if (!Panoply.isStarting()) {
                    sourcesFrame.reveal();
                }
            }
            return null;
        }
        if (((FtypeInfo)inputFtypes_.get("gtab")).accepts(f)) {
            PanGribTableOptionsDialog gtod = new PanGribTableOptionsDialog(parent);
            gtod.setVisible(true);
            if (!gtod.isSuccessful()) {
                return null;
            }
            int[] results = gtod.getResponses();
            boolean success = NcConfig.openGrib1Table(f, results[0], results[1], results[2]);
            if (!success) {
                JOptionPane.showMessageDialog(parent, "I was not able to read a GRIBTAB.");
            }
        } else {
            PanSourcesFrame sourcesFrame;
            PanSourcesFrame panSourcesFrame = sourcesFrame = PanSourcesFrame.getSharedInstance();
            synchronized (panSourcesFrame) {
                PanFileUtils.openDataset(f);
                if (!Panoply.isStarting()) {
                    sourcesFrame.reveal();
                }
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object openLocalDataset(PanFrame parent, Object address) {
        Objects.requireNonNull(address, "Address cannot be null.");
        if (!(address instanceof File || address instanceof URI || address instanceof URL)) {
            throw new IllegalArgumentException("Address object must be File, URI or URL.");
        }
        File f = null;
        if (address instanceof File) {
            f = (File)address;
        } else if (address instanceof URI) {
            f = new File((URI)address);
        } else {
            if (address instanceof URL) {
                throw new RuntimeException("Not prepared to create a File object from a URL.");
            }
            throw new IllegalArgumentException("Address object must be File, URI or URL.");
        }
        if (!f.exists()) {
            FileUtils.showFileError((Component)parent, f.getName(), "File doesn't seem to exist.");
            return null;
        }
        if (((FtypeInfo)inputFtypes_.get("gtab")).accepts(f)) {
            PanGribTableOptionsDialog gtod = new PanGribTableOptionsDialog(parent);
            gtod.setVisible(true);
            if (!gtod.isSuccessful()) {
                return null;
            }
            int[] results = gtod.getResponses();
            boolean success = NcConfig.openGrib1Table(f, results[0], results[1], results[2]);
            if (!success) {
                JOptionPane.showMessageDialog(parent, "Not able to read file as a GRIBTAB.");
            }
        } else {
            PanSourcesFrame sourcesFrame;
            PanSourcesFrame panSourcesFrame = sourcesFrame = PanSourcesFrame.getSharedInstance();
            synchronized (panSourcesFrame) {
                PanFileUtils.openDataset(f);
                if (!Panoply.isStarting()) {
                    sourcesFrame.reveal();
                }
            }
        }
        return null;
    }

    public static void openDataset(Object address) {
        PanFrame pf = PanFrame.getActiveFrame();
        pf.addTask(new PanOpenDatasetTask(address));
    }

    public static NcDataset openDatasetCL(Object address) {
        Objects.requireNonNull(address, "Address cannot be null.");
        if (!(address instanceof String || address instanceof File || address instanceof URI || address instanceof URL)) {
            throw new IllegalArgumentException("Address must be String, File, URL or URI.");
        }
        if (address instanceof String) {
            try {
                address = FileUtils.convertStringToAddress((String)address);
            }
            catch (Exception exc) {
                throw new RuntimeException("Address does not look valid.");
            }
        }
        PanOpenDatasetTask task = new PanOpenDatasetTask(address);
        task.openDataset();
        NcDataset ncd = task.getDataset();
        if (ncd == null) {
            String errmsg = task.getErrorMessage();
            LOGGER.debug("Could not create NcDataset from {}: {}", address, (Object)errmsg);
        }
        return ncd;
    }

    public static void openRemoteCatalog(PanFrame jf, Object address) {
        PanFrame pf = jf == null ? PanFrame.getActiveFrame() : jf;
        pf.addTask(new PanOpenCatalogTask(address));
    }

    private static void initInputFtypeInfo() {
        inputFtypes_ = new FtypeInfoHash();
        inputFtypes_.put("nc", new FtypeInfo("netCDF datasets", NcFilenameFilter.getExtensions(NcFilenameFilter.FilterType.NETCDF)));
        inputFtypes_.put("hdf", new FtypeInfo("HDF datasets", NcFilenameFilter.getExtensions(NcFilenameFilter.FilterType.HDF)));
        inputFtypes_.put("grib", new FtypeInfo("GRIB datasets", NcFilenameFilter.getExtensions(NcFilenameFilter.FilterType.GRIB)));
        inputFtypes_.put("gem", new FtypeInfo("GEMPAK datasets", NcFilenameFilter.getExtensions(NcFilenameFilter.FilterType.GEMPAK)));
        inputFtypes_.put("gtab", new FtypeInfo("GRIB-1 tables", "tab"));
        inputFtypes_.put("act", new FtypeInfo("Adobe color tables", "act"));
        inputFtypes_.put("cpt", new FtypeInfo("CPT color tables", "cpt"));
        inputFtypes_.put("cwc", new FtypeInfo("ClarisWorks color tables", "cwc"));
        inputFtypes_.put("ggr", new FtypeInfo("GIMP gradient files", "ggr"));
        inputFtypes_.put("gpl", new FtypeInfo("GIMP palette files", "gpl"));
        inputFtypes_.put("gct", new FtypeInfo("GISS color tables", "gct"));
        inputFtypes_.put("rgb", new FtypeInfo("NCL Graphics color tables", "rgb"));
        inputFtypes_.put("pal", new FtypeInfo("PAL color tables", "pal,pal1,pal2"));
        inputFtypes_.put("cno", new FtypeInfo("CNO overlays", "cno,cnob"));
        inputFtypes_.put("shp", new FtypeInfo("Shapefiles", "shp"));
        inputFtypes_.put("mask", new FtypeInfo("B/W image mask overlays", "gif,png"));
        inputFtypes_.put("kml", new FtypeInfo("KMZ ground overlays", "kmz"));
        inputFtypes_.groupTypes("data", "All recognized datasets", "nc", "hdf", "grib", "gem");
        inputFtypes_.groupTypes("ctab", "All color tables", "act", "cpt", "cwc", "ggr", "gpl", "gct", "pal", "rgb");
        inputFtypes_.groupTypes("olay", "All overlay files", "cno", "shp", "mask");
        inputFtypes_.groupTypes("all", "All recognized files", "data", "ctab", "olay");
        inputFtypes_.put("any", new FtypeInfo("All files", ""));
    }

    private static void initOutputFtypeInfo() {
        outputFtypes_ = new FtypeInfoHash();
        outputFtypes_.put("gif", new FtypeInfo("GIF image", "gif"));
        outputFtypes_.put("jpeg", new FtypeInfo("JPEG image", "jpg,jpeg"));
        outputFtypes_.put(DEFAULT_IMG_EXT, new FtypeInfo("PNG image", DEFAULT_IMG_EXT));
        outputFtypes_.put("tiff", new FtypeInfo("TIFF image", "tif,tiff"));
        outputFtypes_.put("pdf", new FtypeInfo("PDF file", "pdf"));
        outputFtypes_.put("ps", new FtypeInfo("PostScript file", "ps"));
        outputFtypes_.groupTypes("img", "All saveable graphics types", "gif", "jpeg", DEFAULT_IMG_EXT, "tiff", "pdf", "ps");
        outputFtypes_.put("kmz", new FtypeInfo("KMZ ground overlay", "kmz"));
        outputFtypes_.put("pancl", new FtypeInfo("PanoplyCL script", "pancl,pcl,panjs,pjs"));
        outputFtypes_.put("cdl", new FtypeInfo("CDL data file", "cdl"));
        outputFtypes_.put("csv", new FtypeInfo("CSV data file", "csv"));
        outputFtypes_.put("txt", new FtypeInfo("CSV data file", "txt,text"));
        outputFtypes_.put("mp4", new FtypeInfo("MP4 video", "mp4"));
    }

    private PanFileUtils() {
    }

    static {
        if (!PlatformUtils.isHeadless() && PlatformUtils.isMacintosh()) {
            try {
                macosNative_ = MacNative.isLoaded();
            }
            catch (ExceptionInInitializerError err) {
                LOGGER.warn("Failed to load native macOS dylib.");
                LOGGER.warn("Sorry, but you're going to get the standard Java file chooser.");
                macosNative_ = false;
            }
        }
        PanFileUtils.initInputFtypeInfo();
        PanFileUtils.initOutputFtypeInfo();
    }
}

