/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.io;

import de.rototor.pdfbox.graphics2d.PdfBoxGraphics2D;
import gov.nasa.giss.graphics.GPrintable;
import gov.nasa.giss.graphics.PaperSize;
import gov.nasa.giss.graphics.ps.PsDocument;
import gov.nasa.giss.graphics.ps.PsGraphics2D;
import gov.nasa.giss.graphics.ps.PsWriter;
import gov.nasa.giss.img.ImageUtils;
import gov.nasa.giss.math.MathUtils;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.ui.PanDisplayFrame;
import gov.nasa.giss.panoply.util.PanConstants;
import gov.nasa.giss.ui.GuiUtils;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.util.Matrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanImageUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String DOT_GIF = ".gif";
    private static final String DOT_JPG = ".jpg";
    private static final String DOT_JPEG = ".jpeg";
    private static final String DOT_PDF = ".pdf";
    private static final String DOT_PNG = ".png";
    private static final String DOT_PS = ".ps";
    private static final String DOT_TIF = ".tif";
    private static final String DOT_TIFF = ".tiff";
    private static final Object SAVE_LOCK = new Object();

    public static boolean saveImage(File f, PanDisplayFrame df) {
        return PanImageUtils.saveImage(f, df.getPrintable(), df);
    }

    public static boolean saveImage(File f, GPrintable plot, PanDisplayFrame listener) {
        try {
            String lcname = f.getName().toLowerCase();
            if (lcname.endsWith(DOT_GIF)) {
                return ImageUtils.saveAsGif(f, plot);
            }
            if (lcname.endsWith(DOT_JPG) || lcname.endsWith(DOT_JPEG)) {
                return ImageUtils.saveAsJpeg(f, plot);
            }
            if (lcname.endsWith(DOT_PNG)) {
                return ImageUtils.saveAsPng(f, plot);
            }
            if (lcname.endsWith(DOT_TIF) || lcname.endsWith(DOT_TIFF)) {
                return ImageUtils.saveAsTiff(f, plot, PanConstants.SOFTWARE);
            }
            if (lcname.endsWith(DOT_PDF)) {
                return PanImageUtils.saveAsPdf(f, plot);
            }
            if (lcname.endsWith(DOT_PS)) {
                return PanImageUtils.saveAsPs(f, plot);
            }
            throw new RuntimeException("Unknown extension.");
        }
        catch (Exception exc) {
            LOGGER.error("Could not save image to a file.");
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            if (listener != null) {
                GuiUtils.showSlowMessage(listener, "Save Error", "Unable to save image. " + exc.toString());
            }
            return false;
        }
    }

    public static boolean saveAsPdf(File f, GPrintable plot) throws IOException {
        PanPreferences prefs = PanPreferences.getSharedInstance();
        boolean fullyVectorized = prefs.getBoolean("files:save.pspdf.vectorized");
        PaperSize pps = PaperSize.matching(prefs.getString("files:save.pspdf.paper"));
        return PanImageUtils.saveAsPdf(f, plot, fullyVectorized, pps);
    }

    public static boolean saveAsPdf(File f, GPrintable plot, boolean fullyVectorized, String paperSize) throws IOException {
        PaperSize pps = PaperSize.matching(paperSize);
        return PanImageUtils.saveAsPdf(f, plot, fullyVectorized, pps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean saveAsPdf(File f, GPrintable plot, boolean fullyVectorized, PaperSize psize) throws IOException {
        Object object = SAVE_LOCK;
        synchronized (object) {
            LOGGER.trace("vectorized {}", (Object)fullyVectorized);
            Dimension plotSize = plot.getSize();
            PaperSize paperSize = psize == null ? PaperSize.LETTER : psize;
            float ww = paperSize.widthPts();
            float hh = paperSize.heightPts();
            if (plotSize.width > plotSize.height && hh > ww) {
                float tmp = ww;
                ww = hh;
                hh = tmp;
            }
            float scaleX = (float)plotSize.width > ww ? ww / (float)plotSize.width : 1.0f;
            float scaleY = (float)plotSize.height > hh ? hh / (float)plotSize.height : 1.0f;
            float scale = MathUtils.min(1.0f, scaleY, scaleX);
            PDDocument document = new PDDocument();
            PDPage page = new PDPage(new PDRectangle(ww, hh));
            document.addPage(page);
            try {
                PdfBoxGraphics2D g2d = new PdfBoxGraphics2D(document, plotSize.width, plotSize.height);
                g2d.setClip(0, 0, plotSize.width, plotSize.height);
                if (fullyVectorized) {
                    plot.print((Graphics2D)g2d);
                } else {
                    plot.paint((Graphics2D)g2d);
                }
                g2d.dispose();
                PDFormXObject xform = g2d.getXFormObject();
                PDPageContentStream contentStream = new PDPageContentStream(document, page);
                Matrix matrix = new Matrix(scale, 0.0f, 0.0f, scale, 0.5f * (ww - scale * (float)plotSize.width), 0.5f * (hh - scale * (float)plotSize.height));
                contentStream.transform(matrix);
                contentStream.drawForm(xform);
                contentStream.close();
                document.save(f);
                document.close();
            }
            catch (Exception exc) {
                LOGGER.error("Unable to save image as PDF.");
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                if (document != null) {
                    document.close();
                }
                return false;
            }
            return true;
        }
    }

    public static boolean saveAsPs(File f, GPrintable plot) throws IOException {
        PanPreferences prefs = PanPreferences.getSharedInstance();
        boolean fullyVectorized = prefs.getBoolean("files:save.pspdf.vectorized");
        PaperSize pps = PaperSize.matching(prefs.getString("files:save.pspdf.paper"));
        return PanImageUtils.saveAsPs(f, plot, fullyVectorized, pps);
    }

    public static boolean saveAsPs(File f, GPrintable plot, boolean fullyVectorized, String paperSize) throws IOException {
        PaperSize pps = PaperSize.matching(paperSize);
        return PanImageUtils.saveAsPs(f, plot, fullyVectorized, pps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveAsPs(File f, GPrintable plot, boolean fullyVectorized, PaperSize psize) throws IOException {
        Object object = SAVE_LOCK;
        synchronized (object) {
            Dimension plotSize = plot.getSize();
            PaperSize paperSize = psize == null ? PaperSize.LETTER : psize;
            float ww = paperSize.widthPts();
            float hh = paperSize.heightPts();
            if (plotSize.width > plotSize.height && hh > ww) {
                float tmp = ww;
                ww = hh;
                hh = tmp;
            }
            float scaleX = (float)plotSize.width > ww ? ww / (float)plotSize.width : 1.0f;
            float scaleY = (float)plotSize.height > hh ? hh / (float)plotSize.height : 1.0f;
            float scale = Math.min(1.0f, Math.min(scaleY, scaleX));
            Dimension docsize = new Dimension(Math.round(ww), Math.round(hh));
            PsDocument document = null;
            try {
                document = new PsDocument(docsize);
                document.setTitle(PanConstants.SOFTWARE);
                new PsWriter(document, f);
                document.open();
                PsGraphics2D g2d = document.createGraphics(true);
                ((Graphics2D)g2d).translate(0.5f * (ww - scale * (float)plotSize.width), 0.5f * (hh - scale * (float)plotSize.height));
                ((Graphics2D)g2d).scale(scale, scale);
                if (fullyVectorized) {
                    plot.print(g2d);
                } else {
                    plot.paint(g2d);
                }
                ((Graphics)g2d).dispose();
                document.close();
            }
            catch (Exception exc) {
                LOGGER.error("Unable to save image as PS.");
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                return false;
            }
            return true;
        }
    }

    private PanImageUtils() {
    }
}

