/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.graphics.plot.PlotPropertyEvent;
import gov.nasa.giss.graphics.plot.PlotPropertyListener;
import gov.nasa.giss.panoply.action.PanShowPlotControlsTabAction;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanAbstractControlsPanel;
import gov.nasa.giss.panoply.plotui.PanArrayControls;
import gov.nasa.giss.panoply.plotui.PanContourControls;
import gov.nasa.giss.panoply.plotui.PanGridControls1D;
import gov.nasa.giss.panoply.plotui.PanGridControls2D;
import gov.nasa.giss.panoply.plotui.PanLabelControls;
import gov.nasa.giss.panoply.plotui.PanLonLatMapControls;
import gov.nasa.giss.panoply.plotui.PanLonLatNumberlayControls;
import gov.nasa.giss.panoply.plotui.PanLonLatOverlayControls;
import gov.nasa.giss.panoply.plotui.PanLonLatShadingControls;
import gov.nasa.giss.panoply.plotui.PanLonLatTrajectoryControls;
import gov.nasa.giss.panoply.plotui.PanLonLatUnderlayControls;
import gov.nasa.giss.panoply.plotui.PanLonLatZonalControls;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.plotui.PanScaleControls2D;
import gov.nasa.giss.panoply.plotui.PanStrokeControls1D;
import gov.nasa.giss.panoply.plotui.PanVectorControls;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.util.PanLonLatPlotType;
import gov.nasa.giss.panoply.util.PanPlotType;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.menu.GissMenu;
import gov.nasa.giss.ui.tabbedpane.FolderTabbedPane;
import java.awt.Container;
import java.awt.Dimension;
import java.lang.invoke.MethodHandles;
import java.util.Hashtable;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanControlsTabbedPane
extends FolderTabbedPane
implements PlotPropertyListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final PanPlotFrame parent_;
    private final PanPlotMeta pmeta_;
    private final PanMenuBar mbar_;
    private final PanPlotType plotType_;
    private final Hashtable<String, PanAbstractControlsPanel> tabsHash_ = new Hashtable(20);
    private int maxPaneWidth_;

    public PanControlsTabbedPane(PanPlotFrame parent, PanPlotMeta pmeta) {
        this.setFixedButtonWidth(false);
        this.parent_ = parent;
        this.pmeta_ = pmeta;
        this.plotType_ = pmeta.getType();
        this.mbar_ = parent.getPanMenuBar();
        this.prepareTabs();
        this.prepareMenuActions();
        this.attachListeners();
    }

    private final void prepareTabs() {
        PanPreferences prefs = PanPreferences.getSharedInstance();
        PanAbstractControlsPanel cc = new PanArrayControls(this.pmeta_, this.mbar_);
        this.tabsHash_.put("array-controls", cc);
        this.addTab(PanProperties.CONTROL_PROPS.getString("array-controls"), cc);
        if (!this.plotType_.isLinePlot()) {
            cc = new PanScaleControls2D(this.pmeta_, this.mbar_);
            this.tabsHash_.put("scale-controls", cc);
            this.addTab(PanProperties.CONTROL_PROPS.getString("scale-controls"), cc);
        }
        if (this.plotType_ == PanPlotType.LL_TRAJ) {
            cc = new PanLonLatTrajectoryControls(this.pmeta_, this.mbar_);
            this.tabsHash_.put("trajectory-controls", cc);
            this.addTab(PanProperties.CONTROL_PROPS.getString("trajectory-controls"), cc);
        }
        if (this.plotType_ == PanPlotType.LON_LAT || this.plotType_ == PanPlotType.LL_TRAJ) {
            cc = new PanLonLatMapControls(this.pmeta_, this.mbar_);
            this.tabsHash_.put("map-controls", cc);
            cc = new PanLonLatOverlayControls(this.pmeta_, this.mbar_);
            this.tabsHash_.put("overlay-controls", cc);
            cc = new PanLonLatShadingControls(this.pmeta_, this.mbar_);
            this.tabsHash_.put("shading-controls", cc);
            cc = new PanLonLatZonalControls(this.pmeta_, this.mbar_);
            this.tabsHash_.put("grid-controls", cc);
        } else if (this.plotType_.is2D()) {
            cc = new PanGridControls2D(this.pmeta_, this.mbar_);
            this.tabsHash_.put("grid-controls", cc);
            this.addTab(PanProperties.CONTROL_PROPS.getString("grid-controls"), cc);
        } else if (this.plotType_.isLinePlot()) {
            cc = new PanGridControls1D(this.pmeta_, this.mbar_);
            this.tabsHash_.put("grid-controls", cc);
            this.addTab(PanProperties.CONTROL_PROPS.getString("grid-controls"), cc);
        }
        if (this.plotType_.isLinePlot()) {
            LOGGER.trace("Creating PanStrokeControls1D");
            cc = new PanStrokeControls1D(this.pmeta_, this.mbar_);
            this.tabsHash_.put("stroke-controls", cc);
            this.addTab(PanProperties.CONTROL_PROPS.getString("stroke-controls"), cc);
        }
        if (this.plotType_.isColorFill()) {
            cc = new PanContourControls(this.pmeta_, this.mbar_);
            this.tabsHash_.put("contour-controls", cc);
            this.addTab(PanProperties.CONTROL_PROPS.getString("contour-controls"), cc);
        }
        if (this.plotType_.supportsVectorPlots()) {
            cc = new PanVectorControls(this.pmeta_, this.mbar_);
            this.tabsHash_.put("vector-controls", cc);
            this.addTab(PanProperties.CONTROL_PROPS.getString("vector-controls"), cc);
        }
        cc = new PanLabelControls(this.pmeta_, this.mbar_);
        this.tabsHash_.put("label-controls", cc);
        this.addTab(PanProperties.CONTROL_PROPS.getString("label-controls"), cc);
        if (this.plotType_ == PanPlotType.LON_LAT) {
            if (prefs.getBoolean("beta:underlays")) {
                cc = new PanLonLatUnderlayControls(this.pmeta_, this.mbar_);
                this.tabsHash_.put("underlay-controls", cc);
            }
            if (prefs.getBoolean("beta:numberlays")) {
                cc = new PanLonLatNumberlayControls(this.pmeta_, this.mbar_);
                this.tabsHash_.put("numberlay-controls", cc);
                this.addTab(PanProperties.CONTROL_PROPS.getString("numberlay-controls"), cc);
            }
        }
        if (this.plotType_ == PanPlotType.LON_LAT || this.plotType_ == PanPlotType.LL_TRAJ) {
            this.updateLonLatTabs();
        }
        Dimension paneSize = GuiUtils.matchComponentWidths(this.tabsHash_.values());
        this.maxPaneWidth_ = paneSize.width;
    }

    private final void prepareMenuActions() {
        PanShowPlotControlsTabAction a;
        GissMenu viewMenu = this.mbar_.getMenuByName("view-menu");
        GissMenu viewPMenu = (GissMenu)viewMenu.getItemByName("view-plot-menu");
        if (this.tabsHash_.get("array-controls") != null) {
            a = new PanShowPlotControlsTabAction(this.parent_, "show-array-controls", "array-controls");
            viewPMenu.getItemByName("show-array-controls").setAction(a);
        }
        if (this.tabsHash_.get("scale-controls") != null) {
            a = new PanShowPlotControlsTabAction(this.parent_, "show-scale-controls", "scale-controls");
            viewPMenu.getItemByName("show-scale-controls").setAction(a);
        }
        if (this.tabsHash_.get("grid-controls") != null) {
            a = new PanShowPlotControlsTabAction(this.parent_, "show-grid-controls", "grid-controls");
            viewPMenu.getItemByName("show-grid-controls").setAction(a);
        }
        if (this.tabsHash_.get("stroke-controls") != null) {
            a = new PanShowPlotControlsTabAction(this.parent_, "show-stroke-controls", "stroke-controls");
            viewPMenu.getItemByName("show-stroke-controls").setAction(a);
        }
        if (this.tabsHash_.get("overlay-controls") != null) {
            a = new PanShowPlotControlsTabAction(this.parent_, "show-overlay-controls", "overlay-controls");
            viewPMenu.getItemByName("show-overlay-controls").setAction(a);
        }
        if (this.tabsHash_.get("shading-controls") != null) {
            a = new PanShowPlotControlsTabAction(this.parent_, "show-shading-controls", "shading-controls");
            viewPMenu.getItemByName("show-shading-controls").setAction(a);
        }
        if (this.tabsHash_.get("contour-controls") != null) {
            a = new PanShowPlotControlsTabAction(this.parent_, "show-contour-controls", "contour-controls");
            viewPMenu.getItemByName("show-contour-controls").setAction(a);
        }
        if (this.tabsHash_.get("vector-controls") != null) {
            a = new PanShowPlotControlsTabAction(this.parent_, "show-vector-controls", "vector-controls");
            viewPMenu.getItemByName("show-vector-controls").setAction(a);
        }
        if (this.tabsHash_.get("label-controls") != null) {
            a = new PanShowPlotControlsTabAction(this.parent_, "show-label-controls", "label-controls");
            viewPMenu.getItemByName("show-label-controls").setAction(a);
        }
        if (this.tabsHash_.get("underlay-controls") != null) {
            a = new PanShowPlotControlsTabAction(this.parent_, "show-underlay-controls", "underlay-controls");
            viewPMenu.getItemByName("show-underlay-controls").setAction(a);
        }
        if (this.tabsHash_.get("numberlay-controls") != null) {
            a = new PanShowPlotControlsTabAction(this.parent_, "show-numberlay-controls", "numberlay-controls");
            viewPMenu.getItemByName("show-numberlay-controls").setAction(a);
        }
        viewPMenu.refresh();
    }

    private final void attachListeners() {
        this.pmeta_.addPlotPropertyListener(this);
        this.addChangeListener(e -> this.refresh());
    }

    public int getMaxPaneWidth() {
        return this.maxPaneWidth_;
    }

    public void setSelectedComponent(String tabname) {
        PanAbstractControlsPanel acp = this.getComponent(tabname);
        if (acp != null) {
            this.setSelectedComponent(acp);
        }
    }

    public PanAbstractControlsPanel getComponent(String tabname) {
        if (tabname == null) {
            return null;
        }
        if (tabname.equals("array-controls") || tabname.equals(PanProperties.CONTROL_PROPS.getString("array-controls"))) {
            return this.tabsHash_.get("array-controls");
        }
        if (tabname.equals("scale-controls") || tabname.equals(PanProperties.CONTROL_PROPS.getString("scale-controls"))) {
            return this.tabsHash_.get("scale-controls");
        }
        if (tabname.equals("grid-controls") || tabname.equals("map-controls") || tabname.equals(PanProperties.CONTROL_PROPS.getString("grid-controls")) || tabname.equals(PanProperties.CONTROL_PROPS.getString("map-controls"))) {
            if (this.plotType_ == PanPlotType.LON_LAT) {
                int mapIndex;
                PanAbstractControlsPanel llmapcc = this.tabsHash_.get("map-controls");
                PanAbstractControlsPanel zonalcc = this.tabsHash_.get("grid-controls");
                int n = mapIndex = llmapcc == null ? -1 : this.indexOfComponent(llmapcc);
                if (mapIndex > -1) {
                    return llmapcc;
                }
                return zonalcc;
            }
            if (this.plotType_ == PanPlotType.LL_TRAJ) {
                return this.tabsHash_.get("map-controls");
            }
            return this.tabsHash_.get("grid-controls");
        }
        if (tabname.equals("overlay-controls") || tabname.equals(PanProperties.CONTROL_PROPS.getString("overlay-controls"))) {
            return this.tabsHash_.get("overlay-controls");
        }
        if (tabname.equals("shading-controls") || tabname.equals(PanProperties.CONTROL_PROPS.getString("shading-controls"))) {
            return this.tabsHash_.get("shading-controls");
        }
        if (tabname.equals("stroke-controls") || tabname.equals(PanProperties.CONTROL_PROPS.getString("stroke-controls"))) {
            return this.tabsHash_.get("stroke-controls");
        }
        if (tabname.equals("contour-controls") || tabname.equals(PanProperties.CONTROL_PROPS.getString("contour-controls"))) {
            return this.tabsHash_.get("contour-controls");
        }
        if (tabname.equals("vector-controls") || tabname.equals(PanProperties.CONTROL_PROPS.getString("vector-controls"))) {
            return this.tabsHash_.get("vector-controls");
        }
        if (tabname.equals("label-controls") || tabname.equals(PanProperties.CONTROL_PROPS.getString("label-controls"))) {
            return this.tabsHash_.get("label-controls");
        }
        if (tabname.equals("numberlay-controls") || tabname.equals(PanProperties.CONTROL_PROPS.getString("numberlay-controls"))) {
            return this.tabsHash_.get("numberlay-controls");
        }
        return null;
    }

    public void refresh() {
        Container c = this.getTopLevelAncestor();
        if (c == null) {
            return;
        }
        GissMenu viewPMenu = this.mbar_.getMenuByName("view-plot-menu");
        if (viewPMenu == null) {
            return;
        }
        PanAbstractControlsPanel tab = (PanAbstractControlsPanel)this.getSelectedComponent();
        if (tab == null) {
            return;
        }
        tab.refresh();
        JMenuItem item = null;
        item = tab == this.tabsHash_.get("array-controls") ? viewPMenu.getItemByName("show-array-controls") : (tab == this.tabsHash_.get("scale-controls") ? viewPMenu.getItemByName("show-scale-controls") : (tab == this.tabsHash_.get("grid-controls") ? viewPMenu.getItemByName("show-grid-controls") : (tab == this.tabsHash_.get("stroke-controls") ? viewPMenu.getItemByName("show-stroke-controls") : (tab == this.tabsHash_.get("overlay-controls") ? viewPMenu.getItemByName("show-overlay-controls") : (tab == this.tabsHash_.get("shading-controls") ? viewPMenu.getItemByName("show-shading-controls") : (tab == this.tabsHash_.get("contour-controls") ? viewPMenu.getItemByName("show-contour-controls") : (tab == this.tabsHash_.get("vector-controls") ? viewPMenu.getItemByName("show-vector-controls") : (tab == this.tabsHash_.get("label-controls") ? viewPMenu.getItemByName("show-label-controls") : viewPMenu.getItemByName("show-grid-controls")))))))));
        if (item != null) {
            ((JRadioButtonMenuItem)item).setSelected(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        PanControlsTabbedPane panControlsTabbedPane = this;
        synchronized (panControlsTabbedPane) {
            for (String key : this.tabsHash_.keySet()) {
                PanAbstractControlsPanel acp = this.tabsHash_.get(key);
                if (acp == null) continue;
                acp.flush();
            }
            this.tabsHash_.clear();
            if (this.pmeta_ != null) {
                this.pmeta_.flush();
            }
        }
    }

    @Override
    public void plotPropertyChanged(PlotPropertyEvent e) {
        if (e == null) {
            return;
        }
        String pname = e.getMessage();
        if (pname == null) {
            return;
        }
        if (!pname.equals("lonlat.lltype")) {
            return;
        }
        this.updateLonLatTabs();
    }

    private final void updateLonLatTabs() {
        if (this.plotType_ == PanPlotType.LL_TRAJ) {
            this.updateLonLatMapTabs();
        } else if (this.plotType_ == PanPlotType.LON_LAT) {
            String switchTo = this.pmeta_.getString("lonlat.lltype");
            if (PanLonLatPlotType.ZONAL.matches(switchTo)) {
                this.updateLonLatZonalTabs();
            } else {
                this.updateLonLatMapTabs();
            }
        } else {
            return;
        }
        this.doLayout();
        this.repaint();
    }

    private final void updateLonLatMapTabs() {
        Action a;
        PanAbstractControlsPanel cc;
        PanPreferences prefs;
        PanAbstractControlsPanel cc2;
        GissMenu plotMenu = this.mbar_.getMenuByName("plot-menu");
        plotMenu.getItemByName("reverse-scale").setEnabled(true);
        GissMenu viewMenu = this.mbar_.getMenuByName("view-menu");
        GissMenu viewPMenu = (GissMenu)viewMenu.getItemByName("view-plot-menu");
        int tabNum = this.indexOfTab(PanProperties.CONTROL_PROPS.getString("grid-controls"));
        if (tabNum > -1) {
            this.removeTabAt(tabNum);
        }
        int insertNum = 2;
        if (this.plotType_ == PanPlotType.LL_TRAJ) {
            cc2 = this.tabsHash_.get("trajectory-controls");
            this.insertTab(PanProperties.CONTROL_PROPS.getString("trajectory-controls"), null, cc2, null, insertNum++);
        }
        cc2 = this.tabsHash_.get("map-controls");
        this.insertTab(PanProperties.CONTROL_PROPS.getString("map-controls"), null, cc2, null, insertNum++);
        cc2 = this.tabsHash_.get("overlay-controls");
        this.insertTab(PanProperties.CONTROL_PROPS.getString("overlay-controls"), null, cc2, null, insertNum++);
        Action a2 = viewPMenu.getItemActionByName("show-overlay-controls");
        if (a2 != null) {
            a2.setEnabled(true);
        }
        cc2 = this.tabsHash_.get("shading-controls");
        this.insertTab(PanProperties.CONTROL_PROPS.getString("shading-controls"), null, cc2, null, insertNum++);
        a2 = viewPMenu.getItemActionByName("show-shading-controls");
        if (a2 != null) {
            a2.setEnabled(true);
        }
        if (this.plotType_.isColorFill()) {
            cc2 = this.tabsHash_.get("contour-controls");
            this.insertTab(PanProperties.CONTROL_PROPS.getString("contour-controls"), null, cc2, null, insertNum++);
            a2 = viewPMenu.getItemActionByName("show-contour-controls");
            if (a2 != null) {
                a2.setEnabled(true);
            }
        }
        if (this.plotType_.isColorFill()) {
            cc2 = this.tabsHash_.get("vector-controls");
            this.insertTab(PanProperties.CONTROL_PROPS.getString("vector-controls"), null, cc2, null, insertNum++);
            a2 = viewPMenu.getItemActionByName("show-vector-controls");
            if (a2 != null) {
                a2.setEnabled(true);
            }
        }
        if ((prefs = PanPreferences.getSharedInstance()).getBoolean("beta:underlays")) {
            cc = this.tabsHash_.get("underlay-controls");
            this.insertTab(PanProperties.CONTROL_PROPS.getString("underlay-controls"), null, cc, null, insertNum++);
            a = viewPMenu.getItemActionByName("show-underlay-controls");
            if (a != null) {
                a.setEnabled(true);
            }
        }
        if (this.plotType_.isColorFill() && prefs.getBoolean("beta:numberlays")) {
            cc = this.tabsHash_.get("numberlay-controls");
            this.insertTab(PanProperties.CONTROL_PROPS.getString("numberlay-controls"), null, cc, null, insertNum++);
            a = viewPMenu.getItemActionByName("show-numberlay-controls");
            if (a != null) {
                a.setEnabled(true);
            }
        }
        this.tabsHash_.get("map-controls").refresh();
    }

    private final void updateLonLatZonalTabs() {
        Action a;
        GissMenu plotMenu = this.mbar_.getMenuByName("plot-menu");
        plotMenu.getItemByName("reverse-scale").setEnabled(false);
        GissMenu viewMenu = this.mbar_.getMenuByName("view-menu");
        GissMenu viewPMenu = (GissMenu)viewMenu.getItemByName("view-plot-menu");
        PanAbstractControlsPanel cc = this.tabsHash_.get("grid-controls");
        this.insertTab(PanProperties.CONTROL_PROPS.getString("grid-controls"), null, cc, null, 2);
        int tabNum = this.indexOfTab(PanProperties.CONTROL_PROPS.getString("map-controls"));
        if (tabNum > -1) {
            this.removeTabAt(tabNum);
        }
        if ((tabNum = this.indexOfTab(PanProperties.CONTROL_PROPS.getString("overlay-controls"))) > -1) {
            this.removeTabAt(tabNum);
        }
        if ((a = viewPMenu.getItemActionByName("show-overlay-controls")) != null) {
            a.setEnabled(false);
        }
        if ((tabNum = this.indexOfTab(PanProperties.CONTROL_PROPS.getString("shading-controls"))) > -1) {
            this.removeTabAt(tabNum);
        }
        if ((a = viewPMenu.getItemActionByName("show-shading-controls")) != null) {
            a.setEnabled(false);
        }
        if ((tabNum = this.indexOfTab(PanProperties.CONTROL_PROPS.getString("contour-controls"))) > -1) {
            this.removeTabAt(tabNum);
        }
        if ((a = viewPMenu.getItemActionByName("show-contour-controls")) != null) {
            a.setEnabled(false);
        }
        if ((tabNum = this.indexOfTab(PanProperties.CONTROL_PROPS.getString("vector-controls"))) > -1) {
            this.removeTabAt(tabNum);
        }
        if ((a = viewPMenu.getItemActionByName("show-vector-controls")) != null) {
            a.setEnabled(false);
        }
        if ((tabNum = this.indexOfTab(PanProperties.CONTROL_PROPS.getString("numberlay-controls"))) > -1) {
            this.removeTabAt(tabNum);
        }
        if ((a = viewPMenu.getItemActionByName("show-numberlay-controls")) != null) {
            a.setEnabled(false);
        }
        if ((tabNum = this.indexOfTab(PanProperties.CONTROL_PROPS.getString("underlay-controls"))) > -1) {
            this.removeTabAt(tabNum);
        }
        if ((a = viewPMenu.getItemActionByName("show-underlay-controls")) != null) {
            a.setEnabled(false);
        }
    }
}

