/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.map.SymbolID;
import gov.nasa.giss.map.overlay.MapOverlay;
import gov.nasa.giss.map.overlay.OverlayResourceList;
import gov.nasa.giss.map.overlay.ShapefileOverlay;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.overlay.PanMaskOverlay;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanAbstractControlsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanColorComboBox;
import gov.nasa.giss.panoply.ui.PanEnumComboBox;
import gov.nasa.giss.panoply.ui.PanFloatComboBox;
import gov.nasa.giss.panoply.ui.PanGuiConstants;
import gov.nasa.giss.panoply.ui.PanGuiSize;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.ui.PanOverlayComboBox;
import gov.nasa.giss.panoply.util.PanParameterKeys;
import gov.nasa.giss.panoply.util.PanPlotType;
import gov.nasa.giss.panoply.util.PanStrokeStyle;
import gov.nasa.giss.panoply.util.PanUtils;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.util.ResourceListDataEvent;
import gov.nasa.giss.util.ResourceListDataListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.lang.invoke.MethodHandles;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFrame;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanLonLatOverlayControls
extends PanAbstractControlsPanel
implements ResourceListDataListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private JComponent[] overlayRow_;
    private PanOverlayComboBox[] overlayCombo_;
    private PanColorComboBox[] overlayColorCombo_;
    private PanLabel[] overlayWeightLabel_;
    private PanIntSpinner[] overlayWeightSpinner_;
    private PanCheckBox[] overlayMaskInvertCB_;
    private PanEnumComboBox[] overlayStyleCombo_;
    private PanEnumComboBox[] overlaySymbolCombo_;
    private PanFloatComboBox[] overlaySymbolSizeCombo_;
    private JComponent[] overlayNameBox_;
    private JComponent[] overlayColorBox_;
    private JComponent[] overlayWeightBox_;
    private JComponent[] overlayMaskBox_;
    private JComponent[] overlayStrokeBox_;
    private JComponent[] overlaySymbolBox_;
    private boolean refreshing_;

    public PanLonLatOverlayControls(PanPlotMeta pmeta, PanMenuBar mbar) {
        super("overlay-controls", pmeta, mbar);
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private final void createLayout() {
        this.overlayRow_ = new JComponent[3];
        this.overlayCombo_ = new PanOverlayComboBox[3];
        this.overlayColorCombo_ = new PanColorComboBox[3];
        this.overlayWeightLabel_ = new PanLabel[3];
        this.overlayWeightSpinner_ = new PanIntSpinner[3];
        this.overlayMaskInvertCB_ = new PanCheckBox[3];
        this.overlayStyleCombo_ = new PanEnumComboBox[3];
        this.overlaySymbolCombo_ = new PanEnumComboBox[3];
        this.overlaySymbolSizeCombo_ = new PanFloatComboBox[3];
        this.overlayNameBox_ = new JComponent[3];
        this.overlayColorBox_ = new JComponent[3];
        this.overlayWeightBox_ = new JComponent[3];
        this.overlayMaskBox_ = new JComponent[3];
        this.overlayStrokeBox_ = new JComponent[3];
        this.overlaySymbolBox_ = new JComponent[3];
        FlexingGridLayout fgl = new FlexingGridLayout(2, 4, 0, 2);
        fgl.setPadBottom(true);
        this.setLayout(fgl);
        this.setBorder(PanGuiConstants.STD_BORDER);
        for (int i = 0; i < 3; ++i) {
            this.overlayRow_[i] = this.createRow(i);
            this.add((Component)this.overlayRow_[i], new FGConstraint(0, i));
        }
    }

    private JComponent createRow(int row) {
        PanLabel oLabel = PanLabel.createSmall("Overlay " + (row + 1) + ":");
        this.overlayCombo_[row] = new PanOverlayComboBox(PanGuiSize.SMALL, true);
        this.overlayNameBox_[row] = QuickBox.createLeftBox(oLabel, this.overlayCombo_[row]);
        PanLabel oColorLabel = PanLabel.createSmall(", Color:");
        this.overlayColorCombo_[row] = PanColorComboBox.createSmallRainbow(PanParameterKeys.LON_LAT_OVERLAY_COLOR[row]);
        this.overlayColorBox_[row] = QuickBox.createLeftBox(oColorLabel, this.overlayColorCombo_[row]);
        this.overlayWeightLabel_[row] = PanLabel.createSmall(", Weight:");
        this.overlayWeightSpinner_[row] = PanIntSpinner.createSmallWeight(PanParameterKeys.LON_LAT_OVERLAY_WEIGHT[row], this.pmeta_.getInt(PanParameterKeys.LON_LAT_OVERLAY_WEIGHT[row]), 200);
        PanLabel oPctLabel = PanLabel.createSmall("%");
        this.overlayWeightBox_[row] = QuickBox.createLeftBox(this.overlayWeightLabel_[row], this.overlayWeightSpinner_[row], oPctLabel);
        PanLabel oMaskLabel = PanLabel.createSmall(", ");
        this.overlayMaskInvertCB_[row] = PanCheckBox.createSmall(PanParameterKeys.LON_LAT_OVERLAY_INVERT[row], "Invert");
        this.overlayMaskBox_[row] = QuickBox.createLeftBox(oMaskLabel, this.overlayMaskInvertCB_[row]);
        PanLabel oStyleLabel = PanLabel.createSmall("; Style:");
        this.overlayStyleCombo_[row] = PanEnumComboBox.createSmall(PanParameterKeys.LON_LAT_OVERLAY_STYLE[row], PanStrokeStyle.class);
        this.overlayStrokeBox_[row] = QuickBox.createLeftBox(oStyleLabel, this.overlayStyleCombo_[row]);
        PanLabel oSymbolLabel = PanLabel.createSmall("; Pt. Symbol:");
        PanLabel oSymbolSizeLabel = PanLabel.createSmall(", Size:");
        this.overlaySymbolCombo_[row] = PanEnumComboBox.createSmall(PanParameterKeys.LON_LAT_OVERLAY_SYMBOL_ID[row], SymbolID.class);
        this.overlaySymbolCombo_[row].removeItem(SymbolID.NONE);
        this.overlaySymbolSizeCombo_[row] = PanFloatComboBox.createSmall(PanParameterKeys.LON_LAT_OVERLAY_SYMBOL_SIZE[row], 3.0f, 8.0f);
        this.overlaySymbolBox_[row] = QuickBox.createLeftBox(oSymbolLabel, this.overlaySymbolCombo_[row], oSymbolSizeLabel, this.overlaySymbolSizeCombo_[row]);
        MapOverlay oo = (MapOverlay)this.pmeta_.get(PanParameterKeys.LON_LAT_OVERLAY_NAME[row]);
        this.overlayCombo_[row].setSelectedItem(oo);
        this.overlayMaskInvertCB_[row].setSelected(this.pmeta_.getBoolean(PanParameterKeys.LON_LAT_OVERLAY_INVERT[row]));
        this.overlayStyleCombo_[row].setSelectedItem(this.pmeta_.getString(PanParameterKeys.LON_LAT_OVERLAY_STYLE[row]));
        this.overlayColorCombo_[row].setSelectedColor(this.pmeta_.getColor(PanParameterKeys.LON_LAT_OVERLAY_COLOR[row]));
        this.overlaySymbolCombo_[row].setSelectedItem(this.pmeta_.getString(PanParameterKeys.LON_LAT_OVERLAY_SYMBOL_ID[row]));
        this.overlaySymbolSizeCombo_[row].setValue(this.pmeta_.getFloat(PanParameterKeys.LON_LAT_OVERLAY_SYMBOL_SIZE[row]));
        return QuickBox.createLeftBox(this.overlayNameBox_[row], this.overlayColorBox_[row], this.overlayMaskBox_[row], this.overlayStrokeBox_[row], this.overlayWeightBox_[row], this.overlaySymbolBox_[row]);
    }

    private final void attachListeners() {
        int ii = 0;
        while (ii < 3) {
            int i = ii++;
            this.overlayCombo_[i].addItemListener(e -> {
                if (e.getStateChange() != 1) {
                    return;
                }
                MapOverlay oo = this.overlayCombo_[i].getOverlay();
                this.pmeta_.put(PanParameterKeys.LON_LAT_OVERLAY_NAME[i], (Object)oo);
                this.refreshPrivate();
            });
            this.overlayMaskInvertCB_[i].addItemListener(e -> this.pmeta_.setBoolean(PanParameterKeys.LON_LAT_OVERLAY_INVERT[i], this.overlayMaskInvertCB_[i].isSelected()));
            this.overlayStyleCombo_[i].addItemListener(e -> {
                if (e.getStateChange() != 1) {
                    return;
                }
                this.pmeta_.put(PanParameterKeys.LON_LAT_OVERLAY_STYLE[i], (Object)this.overlayStyleCombo_[i].getStringValue());
            });
            this.overlayColorCombo_[i].addItemListener(e -> {
                Color cold;
                if (e.getStateChange() != 1) {
                    return;
                }
                Color cnew = this.overlayColorCombo_[i].getSelectedColor();
                if (!cnew.equals(cold = this.pmeta_.getColor(PanParameterKeys.LON_LAT_OVERLAY_COLOR[i]))) {
                    this.pmeta_.setColor(PanParameterKeys.LON_LAT_OVERLAY_COLOR[i], cnew);
                }
            });
            this.overlayWeightSpinner_[i].addChangeListener(e -> this.pmeta_.setInt(PanParameterKeys.LON_LAT_OVERLAY_WEIGHT[i], this.overlayWeightSpinner_[i].getIntValue()));
            this.overlaySymbolCombo_[i].addItemListener(e -> {
                if (e.getStateChange() != 1) {
                    return;
                }
                this.pmeta_.set(PanParameterKeys.LON_LAT_OVERLAY_SYMBOL_ID[i], this.overlaySymbolCombo_[i].getStringValue());
            });
            this.overlaySymbolSizeCombo_[i].addItemListener(e -> {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (this.refreshing_) {
                    return;
                }
                this.pmeta_.setFloat(PanParameterKeys.LON_LAT_OVERLAY_SYMBOL_SIZE[i], this.overlaySymbolSizeCombo_[i].getValue());
            });
        }
        PanUtils.getOverlayResourceList().addListDataListener(this);
    }

    @Override
    public void contentsChanged(ResourceListDataEvent e) {
        LOGGER.debug("Not implemented.");
    }

    @Override
    public void intervalAdded(ResourceListDataEvent e) {
        Object source;
        if (e == null) {
            return;
        }
        Component cc = e.getComponent();
        if (cc == null) {
            return;
        }
        JFrame jf = null;
        if (cc instanceof JFrame) {
            jf = (JFrame)cc;
        } else if (cc instanceof JComponent) {
            jf = GuiUtils.getParentFrame((JComponent)cc);
        } else {
            return;
        }
        JFrame pframe = GuiUtils.getParentFrame(this);
        if (jf == pframe && (source = e.getSource()) instanceof OverlayResourceList) {
            MapOverlay olay = (MapOverlay)PanUtils.getOverlayResourceList().getBackingObject(e.getIndex0());
            EventQueue.invokeLater(() -> this.overlayCombo_[0].setSelectedItem(olay));
        }
    }

    @Override
    public void intervalRemoved(ResourceListDataEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        PanLonLatOverlayControls panLonLatOverlayControls = this;
        synchronized (panLonLatOverlayControls) {
            for (int i = 0; i < 3; ++i) {
                this.overlayCombo_[i].flush();
                this.overlayCombo_[i] = null;
            }
            super.flush();
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private final void refreshPrivate() {
        boolean isZonalLinePlot = false;
        PanPlotType plotType = (PanPlotType)this.pmeta_.get("type");
        if (plotType.equals(PanPlotType.LON_LAT)) {
            isZonalLinePlot = this.pmeta_.getString("lonlat.lltype").toLowerCase().contains("zon");
        }
        if (isZonalLinePlot) {
            for (int i = 0; i < 3; ++i) {
                this.overlayCombo_[i].setEnabled(false);
                this.overlayColorCombo_[i].setEnabled(false);
                this.overlayMaskInvertCB_[i].setEnabled(false);
                this.overlayStyleCombo_[i].setEnabled(false);
                this.overlayWeightSpinner_[i].setEnabled(false);
                this.overlaySymbolCombo_[i].setEnabled(false);
                this.overlaySymbolSizeCombo_[i].setEnabled(false);
            }
        } else {
            for (int i = 0; i < 3; ++i) {
                MapOverlay oo = this.overlayCombo_[i].getOverlay();
                boolean isMask = oo instanceof PanMaskOverlay;
                boolean isShapefile = oo instanceof ShapefileOverlay;
                this.overlayRow_[i].removeAll();
                this.overlayRow_[i].add(this.overlayNameBox_[i]);
                this.overlayRow_[i].add(this.overlayColorBox_[i]);
                if (isMask) {
                    this.overlayRow_[i].add(this.overlayWeightBox_[i]);
                    this.overlayRow_[i].add(this.overlayMaskBox_[i]);
                    this.overlayWeightLabel_[i].setText(", Mask Opacity:");
                } else {
                    this.overlayRow_[i].add(this.overlayStrokeBox_[i]);
                    this.overlayRow_[i].add(this.overlayWeightBox_[i]);
                    this.overlayWeightLabel_[i].setText(", Weight:");
                    if (isShapefile) {
                        this.overlayRow_[i].add(this.overlaySymbolBox_[i]);
                    }
                }
                this.overlayRow_[i].add(Box.createHorizontalGlue());
                this.overlayCombo_[i].setEnabled(true);
                this.overlayColorCombo_[i].setEnabled(oo != null);
                this.overlayWeightSpinner_[i].setEnabled(oo != null);
                this.overlayMaskInvertCB_[i].setEnabled(isMask);
                this.overlayStyleCombo_[i].setEnabled(oo != null && !isMask);
                this.overlaySymbolCombo_[i].setEnabled(isShapefile);
                this.overlaySymbolSizeCombo_[i].setEnabled(isShapefile);
            }
        }
        this.invalidate();
        this.validate();
        this.repaint();
    }
}

