/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.map.kml.KMLData;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanAbstractControlsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanEnumComboBox;
import gov.nasa.giss.panoply.ui.PanGuiConstants;
import gov.nasa.giss.panoply.ui.PanGuiSize;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.ui.PanUnderlayComboBox;
import gov.nasa.giss.panoply.util.PanAlphaMethod;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import java.awt.Component;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanLonLatUnderlayControls
extends PanAbstractControlsPanel {
    private PanCheckBox ulayVisCB_;
    private PanUnderlayComboBox underlayCombo_;
    private PanEnumComboBox mainAlphaCombo_;
    private PanIntSpinner[] mainAlphaSpinners_ = new PanIntSpinner[2];
    private PanCheckBox mainKnockoutCB_;

    public PanLonLatUnderlayControls(PanPlotMeta pmeta, PanMenuBar mbar) {
        super("underlay-controls", pmeta, mbar);
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private final void createLayout() {
        PanLabel line1Label1 = PanLabel.createSmall("Underlay: ");
        this.ulayVisCB_ = PanCheckBox.createSmall("lonlat.underlay.vis", "Enabled", this.pmeta_.getBoolean("lonlat.underlay.vis"));
        QuickBox line1Box = QuickBox.createLeftBox(line1Label1, this.ulayVisCB_);
        PanLabel line2Label1 = PanLabel.createSmall("Name: ");
        this.underlayCombo_ = new PanUnderlayComboBox(PanGuiSize.SMALL);
        this.underlayCombo_.setSelectedItem(this.pmeta_.get("lonlat.underlay.name"));
        QuickBox line2Box = QuickBox.createLeftBox(line2Label1, this.underlayCombo_);
        PanLabel line3Label1 = PanLabel.createSmall("Main Layer: ");
        PanLabel line3Label2 = PanLabel.createSmall("Alpha Method: ");
        this.mainAlphaCombo_ = PanEnumComboBox.createSmall("main.alpha.method", PanAlphaMethod.class);
        if (this.pmeta_.isLonLatTrajectory()) {
            this.mainAlphaCombo_.stripDown(PanAlphaMethod.CONSTANT);
        } else {
            this.mainAlphaCombo_.setSelectedItem(PanAlphaMethod.matching(this.pmeta_.getString("main.alpha.method")));
        }
        QuickBox line3Box = QuickBox.createLeftBox(line3Label1, line3Label2, this.mainAlphaCombo_);
        PanLabel line4Label1 = PanLabel.createSmall(" ");
        PanLabel line4Label2 = PanLabel.createSmall("Min: ");
        PanLabel line4Label3 = PanLabel.createSmall("%");
        PanLabel line4Label4 = PanLabel.createSmall(", Max:");
        PanLabel line4Label5 = PanLabel.createSmall("%");
        this.mainAlphaSpinners_[0] = PanIntSpinner.createSmallPct("main.alpha.1", this.pmeta_.getInt("main.alpha.1"));
        this.mainAlphaSpinners_[1] = PanIntSpinner.createSmallPct("main.alpha.2", this.pmeta_.getInt("main.alpha.2"));
        QuickBox line4Box = QuickBox.createLeftBox(line4Label1, line4Label2, this.mainAlphaSpinners_[0], line4Label3, line4Label4, this.mainAlphaSpinners_[1], line4Label5);
        PanLabel line5Label1 = PanLabel.createSmall(" ");
        this.mainKnockoutCB_ = PanCheckBox.createSmall("main.alpha.knockout", "Invalids are completely transparent", this.pmeta_.getBoolean("main.alpha.knockout"));
        QuickBox line5Box = QuickBox.createLeftBox(line5Label1, this.mainKnockoutCB_);
        GuiUtils.matchLabelWidths(line1Label1, line2Label1, line3Label1, line4Label1, line5Label1);
        FlexingGridLayout fgl = new FlexingGridLayout(2, 5, 0, 2);
        fgl.setRigidWidth(true);
        fgl.setRigidHeight(true);
        fgl.setPadBottom(true);
        this.setLayout(fgl);
        this.setBorder(PanGuiConstants.STD_BORDER);
        this.add((Component)line1Box, new FGConstraint(0, 0));
        this.add((Component)line2Box, new FGConstraint(0, 1));
        this.add((Component)line3Box, new FGConstraint(0, 2));
        this.add((Component)line4Box, new FGConstraint(0, 3));
        if (this.pmeta_.isColorFillMap()) {
            this.add((Component)line5Box, new FGConstraint(0, 4));
        }
    }

    private final void attachListeners() {
        this.ulayVisCB_.addItemListener(e -> {
            this.pmeta_.setBoolean("lonlat.underlay.vis", e.getStateChange() == 1);
            this.refresh();
        });
        this.underlayCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            KMLData underlay = this.underlayCombo_.getUnderlay();
            this.pmeta_.put("lonlat.underlay.name", (Object)underlay);
            this.refresh();
        });
        this.mainAlphaCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            PanAlphaMethod amethod = (PanAlphaMethod)this.mainAlphaCombo_.getSelectedItem();
            this.pmeta_.put("main.alpha.method", (Object)amethod.name());
            this.refresh();
        });
        this.mainAlphaSpinners_[0].addChangeListener(e -> {
            int ival = this.mainAlphaSpinners_[0].getIntValue();
            this.pmeta_.setInt("main.alpha.1", ival);
        });
        this.mainAlphaSpinners_[1].addChangeListener(e -> {
            int ival = this.mainAlphaSpinners_[1].getIntValue();
            this.pmeta_.setInt("main.alpha.2", ival);
        });
        if (this.mainKnockoutCB_ != null) {
            this.mainKnockoutCB_.addItemListener(e -> this.pmeta_.setBoolean("main.alpha.knockout", e.getStateChange() == 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        PanLonLatUnderlayControls panLonLatUnderlayControls = this;
        synchronized (panLonLatUnderlayControls) {
            this.underlayCombo_.flush();
            this.underlayCombo_ = null;
            super.flush();
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private final void refreshPrivate() {
        boolean cbenabled = this.ulayVisCB_.isSelected();
        KMLData underlay = this.underlayCombo_.getUnderlay();
        boolean enabled = cbenabled && underlay != null;
        PanAlphaMethod amethod = (PanAlphaMethod)this.mainAlphaCombo_.getSelectedItem();
        int acount = amethod.getAlphaCount();
        this.underlayCombo_.setEnabled(this.ulayVisCB_.isSelected());
        this.mainAlphaCombo_.setEnabled(enabled);
        this.mainAlphaSpinners_[0].setEnabled(enabled);
        if (this.pmeta_.isColorFillMap()) {
            this.mainAlphaSpinners_[1].setEnabled(enabled && acount > 1);
            if (this.mainKnockoutCB_ != null) {
                this.mainKnockoutCB_.setEnabled(enabled);
            }
        } else {
            this.mainAlphaSpinners_[1].setEnabled(false);
            if (this.mainKnockoutCB_ != null) {
                this.mainKnockoutCB_.setEnabled(false);
            }
        }
        this.repaint();
    }
}

