/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArray1D;
import gov.nasa.giss.data.nc.array.NcArray2D;
import gov.nasa.giss.graphics.GPrintable;
import gov.nasa.giss.panoply.action.PanCancelAnimationAction;
import gov.nasa.giss.panoply.action.PanChangeCombinationAction;
import gov.nasa.giss.panoply.action.PanExportAnimationAction;
import gov.nasa.giss.panoply.action.PanExportKmzAction;
import gov.nasa.giss.panoply.data.PanData;
import gov.nasa.giss.panoply.io.PanNcUtils;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanLonLatPlot;
import gov.nasa.giss.panoply.plot.PanPlot;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plot.PanProjectionMeta;
import gov.nasa.giss.panoply.plotui.PanAnimationNote;
import gov.nasa.giss.panoply.plotui.PanArrayControls;
import gov.nasa.giss.panoply.plotui.PanArrayDataPanel;
import gov.nasa.giss.panoply.plotui.PanControlsTabbedPane;
import gov.nasa.giss.panoply.plotui.PanPlotDropTargetListener;
import gov.nasa.giss.panoply.plotui.PanPlotGlass;
import gov.nasa.giss.panoply.plotui.PanPlotHolder;
import gov.nasa.giss.panoply.plotui.PanPlotMouseListener;
import gov.nasa.giss.panoply.plotui.PanPlotMouseListenerLonLat;
import gov.nasa.giss.panoply.plotui.PanPlotScrollPane;
import gov.nasa.giss.panoply.plotui.PanPlotTabbedPane;
import gov.nasa.giss.panoply.ui.PanContentPanel;
import gov.nasa.giss.panoply.ui.PanDisplayFrame;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.util.PanActionHash;
import gov.nasa.giss.panoply.util.PanCombinationType;
import gov.nasa.giss.panoply.util.PanPlotType;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.menu.GissMenu;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanPlotFrame
extends PanDisplayFrame
implements Printable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final int MAX_FRAMES = 8;
    private static int frameCount_;
    private PanPlotMeta pmeta_;
    private PanPlotType plotType_;
    private PanData data_;
    private PanPlot plot_;
    private PanPlotHolder plotHolder_;
    private PanPlotScrollPane plotHolderSP_;
    private JPanel contentBox_;
    private PanPlotTabbedPane topTabPane_;
    private PanControlsTabbedPane controlsTabPane_;
    private PanArrayDataPanel[] adataPanels_ = new PanArrayDataPanel[2];
    private PanPlotMouseListener mouseAdapter_;
    private PanAnimationNote controlsCover_;
    private JComponent statusBar_;
    private ArrayList<Action> hiddenActions_;
    private boolean closing_;

    public PanPlotFrame(PanPlotMeta pmeta) {
        super("Plot Frame");
        Objects.requireNonNull(pmeta, "pmeta is null.");
        this.setResizable(false);
        pmeta.setFrame(this);
        this.pmeta_ = pmeta;
        this.plotType_ = pmeta.getType();
        this.data_ = pmeta.getData();
        this.plot_ = pmeta.getPlot();
        if (this.data_ == null) {
            throw new RuntimeException("Data is null.");
        }
        if (this.plot_ == null) {
            throw new RuntimeException("Plot is null.");
        }
        this.setName("plot frame #" + frameCount_++);
        String vname = this.data_.getArray(0).getShortName().replace(' ', '_');
        String dname = this.data_.getArray(0).getDataset().getNameRoot().replace(' ', '_');
        if (vname.length() > 28) {
            vname = vname.substring(0, 28);
        }
        if (dname.length() > 42) {
            dname = dname.substring(0, 42);
        }
        for (int ix = 1; ix < 9999; ++ix) {
            StringBuilder sb = new StringBuilder(vname).append(" in ").append(dname);
            if (ix > 1) {
                sb.append(' ').append(ix);
            }
            String ftitle = sb.toString();
            boolean matched = false;
            for (PanPlotFrame frame : PanGuiUtils.getPlotFrames()) {
                if (!frame.isVisible() || !frame.getTitle().equalsIgnoreCase(ftitle)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            this.setTitle(ftitle);
            break;
        }
        this.createPlotHolder();
        this.attachNonMenuKeyActions();
        this.attachMenuBarAndActions();
        this.createLayout();
        this.refreshPrivate();
        this.attachGlass();
        this.attachListeners();
        this.setDefaultCloseOperation(0);
        this.resizeToFitDisplay();
        this.setMinimumSize(new Dimension(540, 570));
        Rectangle rr = GuiUtils.getActiveScreenBounds();
        Dimension psize = this.getPreferredSize();
        if (rr == null) {
            this.setLocation(25, 25);
        } else if (PlatformUtils.isMacintosh()) {
            this.setLocation(rr.x + (rr.width - psize.width) / 2, rr.y + 20 + (rr.height - psize.height) / 4);
        } else {
            this.setLocation(rr.x + (rr.width - psize.width) / 2, rr.y + (rr.height - psize.height) / 4);
        }
    }

    private final void attachListeners() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                if (PanPlotFrame.this.needsResizeToFitDisplay()) {
                    PanPlotFrame.this.resizeToFitDisplay();
                }
            }
        });
    }

    private final void createPlotHolder() {
        this.plotHolder_ = new PanPlotHolder(this.plot_);
        this.mouseAdapter_ = this.plotType_ == PanPlotType.LON_LAT || this.plotType_ == PanPlotType.LL_TRAJ ? new PanPlotMouseListenerLonLat(this, this.pmeta_) : new PanPlotMouseListener(this);
        this.plotHolder_.setRequestFocusEnabled(true);
        this.plotHolder_.addMouseListener(this.mouseAdapter_);
        this.plotHolder_.addMouseMotionListener(this.mouseAdapter_);
        this.plotHolder_.addKeyListener(this.mouseAdapter_);
        this.plotHolderSP_ = new PanPlotScrollPane(this.plotHolder_);
        PanPlotDropTargetListener pdtl = new PanPlotDropTargetListener(this, this.plotHolderSP_);
        new DropTarget(this.plotHolder_, pdtl);
    }

    private final void attachNonMenuKeyActions() {
        int shortcutMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        boolean metaIsShortcut = shortcutMask == 4;
        InputMap im = this.getRootPane().getInputMap(2);
        ActionMap am = this.getRootPane().getActionMap();
        PanCancelAnimationAction action = new PanCancelAnimationAction(this);
        KeyStroke ks = KeyStroke.getKeyStroke("ESCAPE");
        im.put(ks, action.getValue("Name"));
        am.put(action.getValue("Name"), action);
        ks = metaIsShortcut ? KeyStroke.getKeyStroke("meta PERIOD") : KeyStroke.getKeyStroke("ctrl PERIOD");
        im.put(ks, action.getValue("Name"));
        am.put(action.getValue("Name"), action);
        PanChangeCombinationAction a = new PanChangeCombinationAction(this, PanCombinationType.A1_MINUS_A2);
        ks = metaIsShortcut ? KeyStroke.getKeyStroke("meta shift alt M") : KeyStroke.getKeyStroke("ctrl shift alt M");
        im.put(ks, a.getValue("Name"));
        am.put(a.getValue("Name"), a);
        a = new PanChangeCombinationAction(this, PanCombinationType.A2_MINUS_A1);
        ks = metaIsShortcut ? KeyStroke.getKeyStroke("meta shift alt N") : KeyStroke.getKeyStroke("ctrl shift alt N");
        im.put(ks, a.getValue("Name"));
        am.put(a.getValue("Name"), a);
        a = new PanChangeCombinationAction(this, PanCombinationType.A1_TIMES_A2);
        ks = metaIsShortcut ? KeyStroke.getKeyStroke("meta shift alt X") : KeyStroke.getKeyStroke("ctrl shift alt X");
        im.put(ks, a.getValue("Name"));
        am.put(a.getValue("Name"), a);
        a = new PanChangeCombinationAction(this, PanCombinationType.AVERAGE);
        ks = metaIsShortcut ? KeyStroke.getKeyStroke("meta shift alt Y") : KeyStroke.getKeyStroke("ctrl shift alt Y");
        im.put(ks, a.getValue("Name"));
        am.put(a.getValue("Name"), a);
        a = new PanChangeCombinationAction(this, PanCombinationType.MERGE);
        ks = metaIsShortcut ? KeyStroke.getKeyStroke("meta shift alt B") : KeyStroke.getKeyStroke("ctrl shift alt B");
        im.put(ks, a.getValue("Name"));
        am.put(a.getValue("Name"), a);
        a = new PanChangeCombinationAction(this, PanCombinationType.VECTOR);
        ks = metaIsShortcut ? KeyStroke.getKeyStroke("meta shift alt V") : KeyStroke.getKeyStroke("ctrl shift alt V");
        im.put(ks, a.getValue("Name"));
        am.put(a.getValue("Name"), a);
    }

    private final void attachMenuBarAndActions() {
        AbstractAction a;
        PanMenuBar mbar = new PanMenuBar(this);
        this.setPanMenuBar(mbar);
        GissMenu fileMenu = mbar.getMenuByName("file-menu");
        GissMenu plotMenu = mbar.getMenuByName("plot-menu");
        if (this.plotType_ == PanPlotType.LON_LAT) {
            a = new PanExportKmzAction(this);
            fileMenu.getItemByName("export-kmz").setAction(a);
            a.setEnabled(true);
            this.pmeta_.putAction("export-kmz", a);
        }
        a = new PanExportAnimationAction(this);
        fileMenu.getItemByName("export-animation").setAction(a);
    }

    private final void createLayout() {
        this.topTabPane_ = new PanPlotTabbedPane(this);
        this.topTabPane_.setLowerBorder(true);
        this.topTabPane_.addTab("Plot", this.plotHolderSP_);
        this.updateArrayDataPanel(0);
        this.controlsTabPane_ = new PanControlsTabbedPane(this, this.pmeta_);
        this.statusBar_ = this.getStatusBar();
        this.contentBox_ = new PanContentPanel(4);
        this.contentBox_.setLayout(new BoxLayout(this.contentBox_, 1));
        this.contentBox_.add(this.topTabPane_);
        this.contentBox_.add(this.controlsTabPane_);
        this.contentBox_.add(this.statusBar_);
        this.getContentPane().add(this.contentBox_);
    }

    private final void attachGlass() {
        PanPlotGlass glass = new PanPlotGlass(this);
        this.setGlassPane(glass);
        glass.setVisible(false);
    }

    public Component findComponentNamed(String pname) {
        return PanPlotFrame.findComponentNamed(this, pname);
    }

    private static Component findComponentNamed(Container parent, String pname) {
        Component[] children = parent.getComponents();
        if (children == null) {
            return null;
        }
        for (Component child : children) {
            Component c;
            if (child.getName() != null && child.getName().equals(pname)) {
                return child;
            }
            if (!(child instanceof Container) || (c = PanPlotFrame.findComponentNamed((Container)child, pname)) == null) continue;
            return c;
        }
        return null;
    }

    public PanPlotMeta getMeta() {
        return this.pmeta_;
    }

    public PanData getData() {
        return this.data_;
    }

    public PanPlot getPlot() {
        return this.plot_;
    }

    public PanPlotHolder getPlotHolder() {
        return this.plotHolder_;
    }

    public PanPlotTabbedPane getTopTabbedPane() {
        return this.topTabPane_;
    }

    public PanControlsTabbedPane getControlsTabbedPane() {
        return this.controlsTabPane_;
    }

    public PanArrayDataPanel[] getArrayDataPanels() {
        return this.adataPanels_;
    }

    public void addVariable(NcVariable ncv) {
        try {
            NcArray nca = PanNcUtils.createCompatibleArray(ncv, this.pmeta_);
            this.addArray(nca);
        }
        catch (Exception exc) {
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            String errmsg = exc.toString().replaceFirst(".*Exception\\: ", "");
            GuiUtils.showSlowMessage(this, "Data Error", "There was an error preparing the data: " + errmsg);
        }
        this.refreshPrivate();
    }

    public void addArray(NcArray nca) {
        this.toFront();
        if (this.data_.getArray(1) == null) {
            this.setArray(1, nca);
        } else {
            this.showReplaceArrayDialog(nca);
        }
    }

    private final void setArray(int vindex, NcArray nca) {
        this.toFront();
        if (this.plotType_.isLinePlot()) {
            NcArray1D nca1D = (NcArray1D)nca;
            NcArray1D nca1D0 = (NcArray1D)this.data_.getArray(0);
            boolean equal = nca1D.getAxis().equals(nca1D0.getAxis());
            if (!equal) {
                GuiUtils.showSlowMessage(this, "Plot Warning", "The new variable's axis does not appear to be the same as the plot's axis. The combination will be canceled.");
                return;
            }
        } else if (this.plotType_ != PanPlotType.LON_LAT && this.plotType_ != PanPlotType.LL_TRAJ) {
            NcArray2D nca2D = (NcArray2D)nca;
            NcArray2D nca2D0 = (NcArray2D)this.data_.getArray(0);
            if (this.plotType_ == PanPlotType.LAT_VERT || this.plotType_ == PanPlotType.LON_VERT || this.plotType_ == PanPlotType.TIME_VERT) {
                boolean compat = nca2D.getYAxis().isCompatible(nca2D0.getYAxis());
                boolean equal = nca2D.getYAxis().equals(nca2D0.getYAxis());
                if (!compat && !equal) {
                    GuiUtils.showSlowMessage(this, "Plot Warning", "The variable's vertical axis does not appear to be compatible with the plot's vertical axis. The combination will be canceled.");
                    return;
                }
            } else if (this.plotType_ == PanPlotType.LAT_TIME || this.plotType_ == PanPlotType.LON_TIME) {
                boolean compat = nca2D.getYAxis().isCompatible(nca2D0.getYAxis());
                boolean equal = nca2D.getYAxis().equals(nca2D0.getYAxis());
                if (!compat && !equal) {
                    GuiUtils.showSlowMessage(this, "Plot Warning", "The variable's time axis does not appear to be compatible with the plot's time axis. The combination will be canceled.");
                    return;
                }
            } else if (this.plotType_ == PanPlotType.TIME_LAT || this.plotType_ == PanPlotType.TIME_VERT) {
                boolean compat = nca2D.getXAxis().isCompatible(nca2D0.getXAxis());
                boolean equal = nca2D.getXAxis().equals(nca2D0.getXAxis());
                if (!compat && !equal) {
                    GuiUtils.showSlowMessage(this, "Plot Warning", "The variable's time axis does not appear to be compatible with the plot's time axis. The combination will be canceled.");
                    return;
                }
            } else {
                LOGGER.trace("Did not match any plot types.");
            }
        }
        if (vindex < 0 || vindex > 1) {
            LOGGER.warn("Cannot set array at index {}", (Object)vindex);
            return;
        }
        LOGGER.trace("{}", (Object)vindex);
        this.pmeta_.setNcArray(vindex, nca, null);
    }

    public final void updateArrayDataPanel(int idx) {
        int tabIndex = idx + 1;
        if (this.adataPanels_[idx] != null) {
            this.topTabPane_.removeTabAt(tabIndex);
        }
        this.adataPanels_[idx] = new PanArrayDataPanel(this.plotType_, this.data_, idx);
        this.adataPanels_[idx].setName("Array " + tabIndex);
        this.topTabPane_.add((Component)this.adataPanels_[idx], tabIndex);
        Component c = this.findComponentNamed("array-controls");
        if (c != null) {
            ((PanArrayControls)c).updateSlicePanel(idx);
        }
        this.refreshActions();
        this.refreshPrivate();
        this.topTabPane_.repaint();
        this.topTabPane_.refresh();
    }

    public void setAnimationInProgress(boolean hide) {
        EventQueue.invokeLater(() -> {
            if (this.closing_) {
                return;
            }
            if (hide) {
                if (this.controlsCover_ == null) {
                    this.controlsCover_ = new PanAnimationNote();
                    Dimension d = this.controlsTabPane_.getSize();
                    this.controlsCover_.setPreferredSize(d);
                    this.controlsCover_.setMinimumSize(d);
                }
                this.contentBox_.remove(this.controlsTabPane_);
                this.contentBox_.remove(this.statusBar_);
                this.contentBox_.add(this.controlsCover_);
                this.contentBox_.add(this.statusBar_);
            } else {
                this.setResizable(true);
                this.contentBox_.remove(this.controlsCover_);
                this.contentBox_.remove(this.statusBar_);
                this.contentBox_.add(this.controlsTabPane_);
                this.contentBox_.add(this.statusBar_);
                this.setResizable(false);
            }
            this.contentBox_.invalidate();
            this.contentBox_.validate();
            this.repaint();
            if (hide) {
                this.disableActions();
            } else {
                this.enableActions();
            }
        });
    }

    private final void enableActions() {
        for (Action a : this.hiddenActions_) {
            if (a == null) continue;
            a.setEnabled(true);
        }
    }

    private final void disableActions() {
        JMenuItem jmi;
        Action a;
        this.hiddenActions_ = new ArrayList(75);
        PanMenuBar mbar = this.getPanMenuBar();
        GissMenu fileMenu = mbar.getMenuByName("file-menu");
        this.hiddenActions_.add(fileMenu.getItemActionByName("save-image"));
        this.hiddenActions_.add(fileMenu.getItemActionByName("save-image-as"));
        this.hiddenActions_.add(fileMenu.getItemActionByName("export-cl-script"));
        Action a2 = fileMenu.getItemByName("export-kmz").getAction();
        if (a2 != null && a2.isEnabled()) {
            this.hiddenActions_.add(a2);
        }
        this.hiddenActions_.add(fileMenu.getItemActionByName("export-animation"));
        this.hiddenActions_.add(fileMenu.getItemActionByName("print"));
        GissMenu viewPMenu = mbar.getMenuByName("view-plot-menu");
        for (Component c : viewPMenu.getMenuComponents()) {
            JMenuItem jmi2;
            Action a3;
            if (!(c instanceof JMenuItem) || c instanceof JMenu || c instanceof JSeparator || (a3 = (jmi2 = (JMenuItem)c).getAction()) == null || !a3.isEnabled()) continue;
            this.hiddenActions_.add(a3);
        }
        GissMenu plotMenu = mbar.getMenuByName("plot-menu");
        GissMenu sizeMenu = mbar.getMenuByName("plot-size-menu");
        GissMenu widthMenu = mbar.getMenuByName("plot-width-menu");
        GissMenu heightMenu = mbar.getMenuByName("plot-height-menu");
        for (Component c : plotMenu.getMenuComponents()) {
            if (!(c instanceof JMenuItem) || c instanceof JMenu || c instanceof JSeparator || (a = (jmi = (JMenuItem)c).getAction()) == null || !a.isEnabled()) continue;
            this.hiddenActions_.add(a);
        }
        for (Component c : sizeMenu.getMenuComponents()) {
            if (!(c instanceof JMenuItem) || c instanceof JMenu || c instanceof JSeparator || (a = (jmi = (JMenuItem)c).getAction()) == null || !a.isEnabled()) continue;
            this.hiddenActions_.add(a);
        }
        for (Component c : widthMenu.getMenuComponents()) {
            if (!(c instanceof JMenuItem) || c instanceof JMenu || c instanceof JSeparator || (a = (jmi = (JMenuItem)c).getAction()) == null || !a.isEnabled()) continue;
            this.hiddenActions_.add(a);
        }
        for (Component c : heightMenu.getMenuComponents()) {
            if (!(c instanceof JMenuItem) || c instanceof JMenu || c instanceof JSeparator || (a = (jmi = (JMenuItem)c).getAction()) == null || !a.isEnabled()) continue;
            this.hiddenActions_.add(a);
        }
        for (Action a4 : this.hiddenActions_) {
            a4.setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void refreshActions() {
        PanPlotFrame panPlotFrame = this;
        synchronized (panPlotFrame) {
            PanMenuBar mbar = this.getPanMenuBar();
            GissMenu plotMenu = mbar.getMenuByName("plot-menu");
            Action a = plotMenu.getItemActionByName("link-dimensions");
            if (a != null) {
                Component c = this.findComponentNamed("array-controls");
                if (c != null) {
                    a.setEnabled(((PanArrayControls)c).canLinkDimensions());
                } else {
                    a.setEnabled(false);
                }
            }
        }
    }

    private final void showReplaceArrayDialog(NcArray nca) {
        EventQueue.invokeLater(() -> {
            Object[] options = new String[]{"Replace Var 2", "Replace Var 1", "Cancel"};
            int choice = JOptionPane.showOptionDialog(this, "This plot already has two variables assigned\nto it. Should I replace one?", null, 1, 3, null, options, options[0]);
            if (choice == 0) {
                this.setArray(1, nca);
            } else if (choice == 1) {
                this.setArray(0, nca);
            } else if (choice == 2) {
                // empty if block
            }
            this.refreshActions();
        });
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private final void refreshPrivate() {
        PanMenuBar mbar;
        GissMenu viewPMenu;
        Action a;
        this.getPreferredSize();
        if (this.topTabPane_ != null) {
            this.topTabPane_.refresh();
        }
        if (this.controlsTabPane_ != null) {
            this.controlsTabPane_.refresh();
        }
        if (this.adataPanels_[0] != null) {
            this.adataPanels_[0].refresh();
        }
        if (this.adataPanels_[1] != null) {
            this.adataPanels_[1].refresh();
        }
        if ((a = (viewPMenu = (mbar = this.getPanMenuBar()).getMenuByName("view-plot-menu")).getItemByName("show-array-2").getAction()) != null) {
            boolean enabled = this.adataPanels_[1] != null;
            a.setEnabled(enabled);
        }
        if (this.plot_ instanceof PanLonLatPlot) {
            PanLonLatPlot llp = (PanLonLatPlot)this.plot_;
            boolean isMap = llp.isMap();
            PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
            try {
                PanActionHash actionHash = this.pmeta_.getActionHash();
                actionHash.enable("export-kmz", isMap);
                actionHash.enable("zoom-plot-in", isMap && projmeta.canZoomIn());
                actionHash.enable("zoom-plot-out", isMap && projmeta.canZoomOut());
                actionHash.enable("swap-xbounds", !isMap);
                actionHash.enable("include-axes", !isMap);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void close() {
        this.closing_ = true;
        this.setVisible(false);
        if (this.contentBox_ != null) {
            this.contentBox_.removeAll();
        }
        if (this.mouseAdapter_ != null) {
            this.mouseAdapter_.flush();
        }
        if (this.plotHolder_ != null) {
            this.plotHolder_.flush();
        }
        if (this.pmeta_ != null) {
            this.pmeta_.flush();
        }
        if (this.topTabPane_ != null) {
            this.topTabPane_.removeAll();
        }
        if (this.plot_ != null) {
            this.plot_.flush();
        }
        if (this.controlsTabPane_ != null) {
            this.controlsTabPane_.flush();
            this.controlsTabPane_.removeAll();
        }
        this.removeAll();
        this.controlsTabPane_ = null;
        this.pmeta_ = null;
        this.plotType_ = null;
        this.data_ = null;
        this.plot_ = null;
        this.contentBox_ = null;
        this.mouseAdapter_ = null;
        this.plotHolder_ = null;
        this.adataPanels_[0] = null;
        this.adataPanels_[1] = null;
        for (WindowListener windowListener : this.getWindowListeners()) {
            this.removeWindowListener(windowListener);
        }
        for (EventListener eventListener : this.getWindowFocusListeners()) {
            this.removeWindowFocusListener((WindowFocusListener)eventListener);
        }
        this.setPanMenuBar(null);
        this.dispose();
    }

    @Override
    public int print(Graphics g, PageFormat pf, int page) {
        if (page > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        double scaleY = pf.getImageableWidth() / (double)this.plot_.getHeight();
        double scaleX = pf.getImageableHeight() / (double)this.plot_.getWidth();
        double scale = Math.min(scaleY, scaleX);
        double tranX = 0.5 * (pf.getImageableWidth() + scale * (double)this.plot_.getHeight());
        g2d.translate(pf.getImageableX() + tranX, pf.getImageableY());
        g2d.rotate(1.5707963267948966);
        g2d.scale(scale, scale);
        this.plot_.print(g2d);
        return 0;
    }

    @Override
    public GPrintable getPrintable() {
        return this.plot_;
    }

    public int getSizeFactor() {
        return this.pmeta_.getInt("size.factor");
    }

    public void setSizeFactor(int sfactor) {
        LOGGER.trace("{}", (Object)sfactor);
        this.pmeta_.setInt("size.factor", sfactor);
        this.resizeToFitDisplay();
    }

    public int getWidthFactor() {
        int wf = this.pmeta_.getInt("size.width");
        return wf;
    }

    public void setWidthFactor(int wfactor) {
        this.pmeta_.setInt("size.width", wfactor);
        this.resizeToFitDisplay();
    }

    public int getHeightFactor() {
        return this.pmeta_.getInt("size.height");
    }

    public void setHeightFactor(int hfactor) {
        this.pmeta_.setInt("size.height", hfactor);
        this.resizeToFitDisplay();
    }

    @Override
    public final void resizeToFitDisplay() {
        PanPlotGlass glass = (PanPlotGlass)this.getGlassPane();
        if (glass != null) {
            glass.setVisible(false);
            glass.setContentType(PanPlotGlass.ContentType.NONE);
        }
        Dimension psize = (Dimension)this.pmeta_.getLayout().getParam("size.pixels");
        this.plotHolder_.setPreferredSize(null);
        Dimension phsize = this.plotHolder_.getPreferredSize();
        int www = this.controlsTabPane_.getMaxPaneWidth();
        if (phsize.width < www) {
            phsize.width = www;
        }
        Insets vpins = this.plotHolderSP_.getViewportBorder().getBorderInsets(this.plotHolderSP_.getViewport());
        Dimension vpsize = new Dimension(vpins.left + phsize.width + vpins.right, vpins.top + phsize.height + vpins.bottom);
        Rectangle rr = this.isVisible() ? GuiUtils.getFrameScreenBounds(this) : GuiUtils.getActiveScreenBounds();
        Insets ins = this.isVisible() ? GuiUtils.getFrameScreenInsets(this) : GuiUtils.getActiveScreenInsets();
        int insW = Math.max(24, ins.left + ins.right);
        int insH = Math.max(24, ins.top + ins.bottom);
        int availW = rr.width - insW;
        int availH = rr.height - insH;
        Dimension spsize = new Dimension(vpsize.width, vpsize.height);
        spsize.width = Math.min(spsize.width, availW - 100);
        spsize.height = Math.min(spsize.height, availH - 300);
        spsize.width = Math.max(spsize.width, www);
        this.plotHolderSP_.setMinimumSize(spsize);
        this.plotHolderSP_.setMaximumSize(spsize);
        this.plotHolderSP_.setPreferredSize(spsize);
        this.plotHolderSP_.getViewport().setViewSize(vpsize);
        int pleft = (phsize.width - psize.width) / 2;
        int ptop = (phsize.height - psize.height) / 2;
        this.plot_.setLocation(pleft, ptop);
        for (PanArrayDataPanel panel : this.adataPanels_) {
            if (panel == null) continue;
            panel.setPreferredSize(spsize);
            panel.setMinimumSize(spsize);
            panel.setMaximumSize(new Dimension(4000, spsize.height));
        }
        Dimension tpsize = this.topTabPane_.getPreferredSize();
        this.controlsTabPane_.setPreferredSize(null);
        Dimension cpsize = this.controlsTabPane_.getPreferredSize();
        if (cpsize.width > tpsize.width) {
            cpsize.width = tpsize.width;
            this.controlsTabPane_.setPreferredSize(cpsize);
        }
        this.contentBox_.invalidate();
        this.contentBox_.validate();
        this.pack();
        this.repaint();
    }

    public void selectControlsTab(String tabName) {
        if (this.controlsTabPane_ == null) {
            return;
        }
        this.controlsTabPane_.setSelectedComponent(tabName);
    }
}

