/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanAbstractControlsPanel;
import gov.nasa.giss.panoply.ui.PanCaptionListener;
import gov.nasa.giss.panoply.ui.PanColorComboBox;
import gov.nasa.giss.panoply.ui.PanEnumComboBox;
import gov.nasa.giss.panoply.ui.PanGuiConstants;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.ui.PanRadioButton;
import gov.nasa.giss.panoply.ui.PanTextField;
import gov.nasa.giss.panoply.util.PanCombinationType;
import gov.nasa.giss.panoply.util.PanParameterKeys;
import gov.nasa.giss.panoply.util.PanStrokeStyle;
import gov.nasa.giss.ui.QuickBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.ButtonGroup;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanStrokeControls1D
extends PanAbstractControlsPanel {
    private PanColorComboBox s1ColorCombo_;
    private PanEnumComboBox s1StyleCombo_;
    private PanIntSpinner s1WeightSpinner_;
    private PanRadioButton dfltS1CapButton_;
    private PanRadioButton userS1CapButton_;
    private PanTextField s1CaptionTF_;
    private PanColorComboBox s2ColorCombo_;
    private PanEnumComboBox s2StyleCombo_;
    private PanIntSpinner s2WeightSpinner_;
    private PanRadioButton dfltS2CapButton_;
    private PanRadioButton userS2CapButton_;
    private PanTextField s2CaptionTF_;

    public PanStrokeControls1D(PanPlotMeta pmeta, PanMenuBar mbar) {
        super("stroke-controls", pmeta, mbar);
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private final void createLayout() {
        PanLabel s1Label = PanLabel.createSmall("Stroke 1: ");
        PanLabel s1StyleLabel = PanLabel.createSmall("Style: ");
        this.s1StyleCombo_ = PanEnumComboBox.createSmall(PanParameterKeys.STROKE_STYLE[0], PanStrokeStyle.class);
        this.s1StyleCombo_.removeItem(PanStrokeStyle.NONE);
        this.s1StyleCombo_.setSelectedItem(this.pmeta_.getString(PanParameterKeys.STROKE_STYLE[0]));
        PanLabel s1ColorLabel = PanLabel.createSmall("Color: ");
        this.s1ColorCombo_ = PanColorComboBox.createSmallRainbow(PanParameterKeys.STROKE_COLOR[0]);
        this.s1ColorCombo_.setSelectedColor(this.pmeta_.getColor(PanParameterKeys.STROKE_COLOR[0]));
        PanLabel s1WeightLabel = PanLabel.createSmall(", Weight: ");
        this.s1WeightSpinner_ = PanIntSpinner.createSmallWeightX5(PanParameterKeys.STROKE_WEIGHT[0], this.pmeta_.getInt(PanParameterKeys.STROKE_WEIGHT[0]), 500);
        PanLabel s1PctLabel = PanLabel.createSmall("%");
        QuickBox s1StrokeBox = QuickBox.createLeftBox(s1StyleLabel, this.s1StyleCombo_);
        QuickBox s1ColorBox = QuickBox.createLeftBox(s1ColorLabel, this.s1ColorCombo_, s1WeightLabel, this.s1WeightSpinner_, s1PctLabel);
        PanLabel s1CapLabel = PanLabel.createSmall("Caption: ");
        this.dfltS1CapButton_ = PanRadioButton.createSmall(PanParameterKeys.STROKE_LABEL_CUSTOM[0], "Default", !this.pmeta_.getBoolean(PanParameterKeys.STROKE_LABEL_CUSTOM[0]));
        this.userS1CapButton_ = PanRadioButton.createSmall(PanParameterKeys.STROKE_LABEL_CUSTOM[0], "Other:", this.pmeta_.getBoolean(PanParameterKeys.STROKE_LABEL_CUSTOM[0]));
        ButtonGroup s1CapChoices = new ButtonGroup();
        s1CapChoices.add(this.dfltS1CapButton_);
        s1CapChoices.add(this.userS1CapButton_);
        this.s1CaptionTF_ = PanTextField.createSmall(PanParameterKeys.STROKE_LABEL_TEXT[0], this.pmeta_.getString(PanParameterKeys.STROKE_LABEL_TEXT[0]), 20);
        QuickBox s1CaptionBox = QuickBox.createLeftBox(s1CapLabel, this.dfltS1CapButton_, this.userS1CapButton_, this.s1CaptionTF_);
        PanLabel s2Label = PanLabel.createSmall("Stroke 2: ");
        PanLabel s2StyleLabel = PanLabel.createSmall("Style: ");
        this.s2StyleCombo_ = PanEnumComboBox.createSmall(PanParameterKeys.STROKE_STYLE[1], PanStrokeStyle.class);
        this.s2StyleCombo_.removeItem(PanStrokeStyle.NONE);
        this.s2StyleCombo_.setSelectedItem(this.pmeta_.getString(PanParameterKeys.STROKE_STYLE[1]));
        PanLabel s2ColorLabel = PanLabel.createSmall("Color: ");
        this.s2ColorCombo_ = PanColorComboBox.createSmallRainbow(PanParameterKeys.STROKE_COLOR[1]);
        this.s2ColorCombo_.setSelectedColor(this.pmeta_.getColor(PanParameterKeys.STROKE_COLOR[1]));
        PanLabel s2WeightLabel = PanLabel.createSmall(", Weight: ");
        this.s2WeightSpinner_ = PanIntSpinner.createSmallWeightX5(PanParameterKeys.STROKE_WEIGHT[1], this.pmeta_.getInt(PanParameterKeys.STROKE_WEIGHT[1]), 500);
        PanLabel s2PctLabel = PanLabel.createSmall("%");
        QuickBox s2StrokeBox = QuickBox.createLeftBox(s2StyleLabel, this.s2StyleCombo_);
        QuickBox s2ColorBox = QuickBox.createLeftBox(s2ColorLabel, this.s2ColorCombo_, s2WeightLabel, this.s2WeightSpinner_, s2PctLabel);
        PanLabel s2CapLabel = PanLabel.createSmall("Caption: ");
        this.dfltS2CapButton_ = PanRadioButton.createSmall(null, "Default", !this.pmeta_.getBoolean(PanParameterKeys.STROKE_LABEL_CUSTOM[1]));
        this.userS2CapButton_ = PanRadioButton.createSmall(PanParameterKeys.STROKE_LABEL_CUSTOM[1], "Other:", this.pmeta_.getBoolean(PanParameterKeys.STROKE_LABEL_CUSTOM[1]));
        ButtonGroup s2CapChoices = new ButtonGroup();
        s2CapChoices.add(this.dfltS2CapButton_);
        s2CapChoices.add(this.userS2CapButton_);
        this.s2CaptionTF_ = PanTextField.createSmall(PanParameterKeys.STROKE_LABEL_TEXT[1], this.pmeta_.getString(PanParameterKeys.STROKE_LABEL_TEXT[1]), 20);
        QuickBox s2CaptionBox = QuickBox.createLeftBox(s2CapLabel, this.dfltS2CapButton_, this.userS2CapButton_, this.s2CaptionTF_);
        int tfh = this.s1CaptionTF_.getPreferredSize().height;
        this.s1CaptionTF_.setMinimumSize(new Dimension(150, tfh));
        this.s1CaptionTF_.setPreferredSize(new Dimension(225, tfh));
        this.s1CaptionTF_.setMaximumSize(new Dimension(1000, tfh));
        this.s2CaptionTF_.setMinimumSize(new Dimension(150, tfh));
        this.s2CaptionTF_.setPreferredSize(new Dimension(225, tfh));
        this.s2CaptionTF_.setMaximumSize(new Dimension(1000, tfh));
        FlexingGridLayout fgl = new FlexingGridLayout(4, 3, 0, 2);
        fgl.setColumnWeight(1, 9999.0f);
        fgl.setColumnWeight(3, 9999.0f);
        fgl.setRigidHeight(true);
        fgl.setPadBottom(true);
        this.setLayout(fgl);
        this.setBorder(PanGuiConstants.STD_BORDER);
        this.add((Component)s1Label, new FGConstraint(0, 0));
        this.add((Component)s1StrokeBox, new FGConstraint(1, 0));
        this.add((Component)s1ColorBox, new FGConstraint(1, 1));
        this.add((Component)s1CaptionBox, new FGConstraint(1, 2));
        this.add((Component)s2Label, new FGConstraint(2, 0));
        this.add((Component)s2StrokeBox, new FGConstraint(3, 0));
        this.add((Component)s2ColorBox, new FGConstraint(3, 1));
        this.add((Component)s2CaptionBox, new FGConstraint(3, 2));
    }

    private final void attachListeners() {
        this.s1ColorCombo_.addItemListener(e -> {
            Color cold;
            if (e.getStateChange() != 1) {
                return;
            }
            int index = this.s1ColorCombo_.getSelectedIndex();
            if (index < 0 || index >= this.s1ColorCombo_.getItemCount()) {
                return;
            }
            Color cnew = this.s1ColorCombo_.getSelectedColor();
            if (!cnew.equals(cold = this.pmeta_.getColor(PanParameterKeys.STROKE_COLOR[0]))) {
                this.pmeta_.setColor(PanParameterKeys.STROKE_COLOR[0], cnew);
            }
        });
        this.s1StyleCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            this.pmeta_.set(PanParameterKeys.STROKE_STYLE[0], this.s1StyleCombo_.getStringValue());
        });
        this.s1WeightSpinner_.addChangeListener(e -> this.pmeta_.setInt(PanParameterKeys.STROKE_WEIGHT[0], this.s1WeightSpinner_.getIntValue()));
        this.dfltS1CapButton_.addActionListener(e -> this.pmeta_.setBoolean(PanParameterKeys.STROKE_LABEL_CUSTOM[0], this.userS1CapButton_.isSelected()));
        this.userS1CapButton_.addActionListener(e -> this.pmeta_.setBoolean(PanParameterKeys.STROKE_LABEL_CUSTOM[0], this.userS1CapButton_.isSelected()));
        this.s1CaptionTF_.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (PanStrokeControls1D.this.s1CaptionTF_ == null || PanStrokeControls1D.this.pmeta_ == null) {
                    return;
                }
                PanStrokeControls1D.this.pmeta_.setString(PanParameterKeys.STROKE_LABEL_TEXT[0], PanStrokeControls1D.this.s1CaptionTF_.getText());
            }
        });
        this.s1CaptionTF_.addActionListener(e -> this.pmeta_.setString(PanParameterKeys.STROKE_LABEL_TEXT[0], this.s1CaptionTF_.getText()));
        this.s2ColorCombo_.addItemListener(e -> {
            Color cold;
            if (e.getStateChange() != 1) {
                return;
            }
            int index = this.s2ColorCombo_.getSelectedIndex();
            if (index < 0 || index >= this.s2ColorCombo_.getItemCount()) {
                return;
            }
            Color cnew = this.s2ColorCombo_.getSelectedColor();
            if (!cnew.equals(cold = this.pmeta_.getColor(PanParameterKeys.STROKE_COLOR[1]))) {
                this.pmeta_.setColor(PanParameterKeys.STROKE_COLOR[1], cnew);
            }
        });
        this.s2StyleCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            this.pmeta_.set(PanParameterKeys.STROKE_STYLE[1], this.s2StyleCombo_.getStringValue());
        });
        this.s2WeightSpinner_.addChangeListener(e -> this.pmeta_.setInt(PanParameterKeys.STROKE_WEIGHT[1], this.s2WeightSpinner_.getIntValue()));
        this.dfltS2CapButton_.addActionListener(e -> this.pmeta_.setBoolean(PanParameterKeys.STROKE_LABEL_CUSTOM[1], this.userS2CapButton_.isSelected()));
        this.userS2CapButton_.addActionListener(e -> this.pmeta_.setBoolean(PanParameterKeys.STROKE_LABEL_CUSTOM[1], this.userS2CapButton_.isSelected()));
        this.s2CaptionTF_.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (PanStrokeControls1D.this.s2CaptionTF_ == null || PanStrokeControls1D.this.pmeta_ == null) {
                    return;
                }
                PanStrokeControls1D.this.pmeta_.setString(PanParameterKeys.STROKE_LABEL_TEXT[1], PanStrokeControls1D.this.s2CaptionTF_.getText());
            }
        });
        this.s2CaptionTF_.addActionListener(e -> this.pmeta_.setString(PanParameterKeys.STROKE_LABEL_TEXT[1], this.s2CaptionTF_.getText()));
        this.s1CaptionTF_.getDocument().addDocumentListener(new PanCaptionListener(this.s1CaptionTF_, this.pmeta_, PanParameterKeys.STROKE_LABEL_TEXT[0]));
        this.s2CaptionTF_.getDocument().addDocumentListener(new PanCaptionListener(this.s2CaptionTF_, this.pmeta_, PanParameterKeys.STROKE_LABEL_TEXT[1]));
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private final void refreshPrivate() {
        PanCombinationType ctype = PanCombinationType.matching(this.pmeta_.getString("combination"));
        boolean enableS1 = true;
        boolean enableS2 = false;
        if (ctype == PanCombinationType.COMPARE) {
            enableS2 = true;
        } else if (ctype == PanCombinationType.A2_ONLY) {
            enableS1 = false;
            enableS2 = true;
        }
        this.s1ColorCombo_.setEnabled(enableS1);
        this.s1StyleCombo_.setEnabled(enableS1);
        this.s1WeightSpinner_.setEnabled(enableS1);
        this.dfltS1CapButton_.setEnabled(enableS1);
        this.userS1CapButton_.setEnabled(enableS1);
        this.s1CaptionTF_.setEnabled(enableS1);
        this.s2ColorCombo_.setEnabled(enableS2);
        this.s2StyleCombo_.setEnabled(enableS2);
        this.s2WeightSpinner_.setEnabled(enableS2);
        this.dfltS2CapButton_.setEnabled(enableS2);
        this.userS2CapButton_.setEnabled(enableS2);
        this.s2CaptionTF_.setEnabled(enableS2);
    }
}

