/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefs;

import gov.nasa.giss.panoply.prefs.PanColorTableInfo;
import gov.nasa.giss.panoply.prefs.PanFavoritesEvent;
import gov.nasa.giss.panoply.prefs.PanFavoritesListener;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import javax.swing.event.EventListenerList;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanColorTablePrefs {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ArrayList<PanColorTableInfo> ctinfo_;
    private final EventListenerList listenerList_ = new EventListenerList();

    public static PanColorTablePrefs getSharedInstance() {
        return Singleton.INSTANCE;
    }

    private PanColorTablePrefs() {
    }

    private final void initList() {
    }

    public void reset() {
        this.ctinfo_ = null;
        this.initList();
    }

    public void printList() {
        if (this.ctinfo_ == null) {
            this.initList();
        }
        for (PanColorTableInfo item : this.ctinfo_) {
            System.out.println(item.getName());
        }
    }

    public PanColorTableInfo[] getInfoArray() {
        if (this.ctinfo_ == null) {
            this.initList();
        }
        return this.ctinfo_.toArray(new PanColorTableInfo[0]);
    }

    public String[] getAllNames() {
        if (this.ctinfo_ == null) {
            this.initList();
        }
        ArrayList<String> v = new ArrayList<String>(this.ctinfo_.size());
        for (PanColorTableInfo item : this.ctinfo_) {
            v.add(item.getName());
        }
        return v.toArray(new String[0]);
    }

    public String[] getFavorites() {
        if (this.ctinfo_ == null) {
            this.initList();
        }
        ArrayList<String> v = new ArrayList<String>(this.ctinfo_.size());
        for (PanColorTableInfo item : this.ctinfo_) {
            if (!item.isFavorite()) continue;
            v.add(item.getName());
        }
        return v.toArray(new String[0]);
    }

    void initColorTableFromElement(Element elem) {
        String elemName = elem.getName();
        if (!elemName.equals("ctable")) {
            LOGGER.warn("Does not appear to be a ctable element: {}", (Object)elemName);
            return;
        }
        Attribute nameA = elem.getAttribute("name");
        if (nameA == null) {
            return;
        }
        String lname = nameA.getValue();
        if (lname == null || lname.isEmpty()) {
            return;
        }
        String isFavorite = "true";
        Attribute faveA = elem.getAttribute("favorite");
        if (faveA == null) {
            faveA = elem.getAttribute("visible");
        }
        if (faveA != null && (isFavorite = faveA.getValue()) == null) {
            isFavorite = "true";
        }
        this.setFavorite(lname, isFavorite);
    }

    public boolean isFavorite(String pname) {
        if (this.ctinfo_ == null) {
            this.initList();
        }
        for (PanColorTableInfo item : this.ctinfo_) {
            if (!item.getName().equalsIgnoreCase(pname)) continue;
            return item.isFavorite();
        }
        return false;
    }

    public void setFavorite(String pname, String s) {
        this.setFavorite(pname, Boolean.valueOf(s));
    }

    public void setFavorite(String pname, boolean b) {
        if (pname.toLowerCase().indexOf("equirect") == 0) {
            return;
        }
        PanColorTableInfo info = this.getInfo(pname);
        if (info != null) {
            info.setFavorite(b);
            this.fireStatusChanged(info);
        }
    }

    private PanColorTableInfo getInfo(String ctname) {
        if (this.ctinfo_ == null) {
            this.initList();
        }
        for (PanColorTableInfo item : this.ctinfo_) {
            if (!item.getName().equalsIgnoreCase(ctname)) continue;
            return item;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFavoritesListener(PanFavoritesListener l) {
        PanColorTablePrefs panColorTablePrefs = this;
        synchronized (panColorTablePrefs) {
            this.listenerList_.add(PanFavoritesListener.class, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFavoritesListener(PanFavoritesListener l) {
        PanColorTablePrefs panColorTablePrefs = this;
        synchronized (panColorTablePrefs) {
            this.listenerList_.remove(PanFavoritesListener.class, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFavoritesListeners() {
        PanColorTablePrefs panColorTablePrefs = this;
        synchronized (panColorTablePrefs) {
            for (PanFavoritesListener listener : (PanFavoritesListener[])this.listenerList_.getListeners(PanFavoritesListener.class)) {
                this.removeFavoritesListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireStatusChanged(PanColorTableInfo item) {
        PanFavoritesEvent e = new PanFavoritesEvent(item);
        PanColorTablePrefs panColorTablePrefs = this;
        synchronized (panColorTablePrefs) {
            for (PanFavoritesListener listener : (PanFavoritesListener[])this.listenerList_.getListeners(PanFavoritesListener.class)) {
                listener.statusChanged(e);
            }
        }
    }

    private static class Singleton {
        private static final PanColorTablePrefs INSTANCE = new PanColorTablePrefs();

        private Singleton() {
        }
    }
}

