/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.prefsui.PanCommonPrefsTable;
import gov.nasa.giss.panoply.prefsui.PanPrefsTableScrollPane;
import gov.nasa.giss.panoply.prefsui.PanProjectionTableModel;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.label.MultiLineLabel;
import java.awt.Component;
import javax.swing.JButton;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanProjectionPrefsPanel
extends PanAbstractPrefsPanel {
    private PanProjectionTableModel pmodel_;
    private PanPrefsTableScrollPane ppanel_;
    private JButton checkAllButton_;
    private JButton checkMinButton_;

    public PanProjectionPrefsPanel() {
        this.createLayout();
        this.attachListeners();
    }

    private final void createLayout() {
        MultiLineLabel tText = new MultiLineLabel("Projections checked as favorites are included in the projection combobox\nin lon-lat map plot controls. Unchecked projections are omitted.", 0);
        this.pmodel_ = new PanProjectionTableModel();
        PanCommonPrefsTable table = new PanCommonPrefsTable(this.pmodel_);
        this.ppanel_ = new PanPrefsTableScrollPane(table);
        this.checkMinButton_ = new JButton("Check Minimal");
        this.checkAllButton_ = new JButton("Check All");
        FlexingGridLayout fgl = new FlexingGridLayout(2, 5, 12, 2);
        fgl.setRowWeight(1, 9999.0f);
        this.setLayout(fgl);
        this.setBorder(GuiUtils.createPaddedTitleBorder("Map Projections"));
        this.add((Component)tText, new FGConstraint(0, 0, 2, 1, 0.5, 0.5));
        this.add((Component)this.ppanel_, new FGConstraint(0, 1, 2, 1, true));
        this.add((Component)this.checkMinButton_, new FGConstraint(0, 2, 1.0));
        this.add((Component)this.checkAllButton_, new FGConstraint(1, 2));
    }

    private final void attachListeners() {
        this.checkAllButton_.addActionListener(e -> this.pmodel_.checkUncheckAll(true));
        this.checkMinButton_.addActionListener(e -> this.pmodel_.checkUncheckAll(false));
    }

    @Override
    public void refresh() {
        this.refreshing_ = true;
        this.pmodel_.fireTableDataChanged();
        this.refreshing_ = false;
    }
}

