/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.graphics.AbstractColorTable;
import gov.nasa.giss.graphics.ColorTableOutlierShape;
import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanColorComboBox;
import gov.nasa.giss.panoply.ui.PanColorTableComboBox;
import gov.nasa.giss.panoply.ui.PanEnumComboBox;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.util.PanColorbarOutlierGap;
import gov.nasa.giss.panoply.util.PanColorbarOutlierSide;
import gov.nasa.giss.panoply.util.PanScaleCaptionLocation;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.color.PaletteType;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanScaleColorbarPrefsPanel
extends PanAbstractPrefsPanel {
    private PanColorTableComboBox ctableCombo_;
    private PanCheckBox reversedCB_;
    private PanIntSpinner widthSpinner_;
    private PanEnumComboBox outlierShapeCombo_;
    private PanEnumComboBox outlierSideCombo_;
    private PanEnumComboBox outlierGapCombo_;
    private PanEnumComboBox scaleCapPlaceCombo_;
    private PanColorComboBox invalidsCombo_;

    public PanScaleColorbarPrefsPanel() {
        this.setBorder(GuiUtils.createPaddedTitleBorder("Scale Colorbar Defaults"));
        this.setOpaque(false);
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private final void createLayout() {
        PanLabel topText = PanLabel.create("When creating a color-fill plot, set\u2026");
        this.ctableCombo_ = PanColorTableComboBox.create(true);
        this.ctableCombo_.setToolTipText("Select a default color table to apply to new plots");
        Dimension d = this.ctableCombo_.getPreferredSize();
        if (d.width > 320) {
            d.width = 320;
            this.ctableCombo_.setPreferredSize(d);
            this.ctableCombo_.setMaximumSize(d);
        }
        this.reversedCB_ = PanCheckBox.create("Reverse color table");
        this.widthSpinner_ = PanIntSpinner.create(60, 50, 100, 5);
        this.outlierShapeCombo_ = PanEnumComboBox.create(ColorTableOutlierShape.class);
        this.outlierSideCombo_ = PanEnumComboBox.create(PanColorbarOutlierSide.class);
        this.outlierGapCombo_ = PanEnumComboBox.create(PanColorbarOutlierGap.class);
        this.scaleCapPlaceCombo_ = PanEnumComboBox.create(PanScaleCaptionLocation.class);
        this.invalidsCombo_ = PanColorComboBox.create(PaletteType.GRAYSCALE);
        FlexingGridLayout fgl = new FlexingGridLayout(4, 9, 0, 2);
        fgl.setColumnWeight(3, 9999.0f);
        this.setLayout(fgl);
        int row = 0;
        this.add((Component)topText, new FGConstraint(0, row, 4, 1));
        this.add(Box.createVerticalStrut(4), new FGConstraint(0, ++row));
        this.add((Component)PanLabel.create("Color Table: "), new FGConstraint(0, ++row));
        this.add((Component)this.ctableCombo_, new FGConstraint(1, row));
        this.add((Component)this.reversedCB_, new FGConstraint(1, ++row));
        this.add((Component)PanLabel.create("Bar Width: "), new FGConstraint(0, ++row));
        this.add((Component)QuickBox.createLeftBox(this.widthSpinner_, PanLabel.create("%")), new FGConstraint(1, row));
        this.add((Component)PanLabel.create("Fill Color: "), new FGConstraint(0, ++row));
        this.add((Component)QuickBox.createLeftBox(this.invalidsCombo_), new FGConstraint(1, row));
        this.add((Component)PanLabel.create("Outliers: "), new FGConstraint(0, ++row));
        this.add((Component)QuickBox.createLeftBox(PanLabel.create("On: "), this.outlierSideCombo_), new FGConstraint(1, row));
        this.add((Component)QuickBox.createLeftBox(PanLabel.create("Shape: "), this.outlierShapeCombo_, PanLabel.create(", Gap: "), this.outlierGapCombo_), new FGConstraint(1, ++row));
        this.add((Component)PanLabel.create("Caption: "), new FGConstraint(0, ++row));
        this.add((Component)this.scaleCapPlaceCombo_, new FGConstraint(1, row));
        this.widthSpinner_.setMaximumSize(this.widthSpinner_.getPreferredSize());
        this.outlierShapeCombo_.setMaximumSize(this.outlierShapeCombo_.getPreferredSize());
        this.outlierGapCombo_.setMaximumSize(this.outlierGapCombo_.getPreferredSize());
    }

    private final void attachListeners() {
        this.ctableCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            if (this.refreshing_) {
                return;
            }
            prefs_.set("plot:scale.colorbar", (AbstractColorTable)this.ctableCombo_.getSelectedItem());
        });
        this.reversedCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setBoolean("plot:scale.reverse", this.reversedCB_.isSelected());
        });
        this.widthSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setInt("plot:scale.width", this.widthSpinner_.getIntValue());
        });
        this.outlierSideCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            if (this.refreshing_) {
                return;
            }
            prefs_.set("plot:scale.outlier.side", this.outlierSideCombo_.getStringValue());
        });
        this.outlierShapeCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            if (this.refreshing_) {
                return;
            }
            prefs_.set("plot:scale.outlier.shape", this.outlierShapeCombo_.getStringValue());
        });
        this.outlierGapCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            if (this.refreshing_) {
                return;
            }
            prefs_.set("plot:scale.outlier.gap", this.outlierGapCombo_.getStringValue());
        });
        this.scaleCapPlaceCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            if (this.refreshing_) {
                return;
            }
            prefs_.set("plot:scale.label.location", this.scaleCapPlaceCombo_.getStringValue());
        });
        this.invalidsCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            if (this.refreshing_) {
                return;
            }
            prefs_.set("plot:scale.invalids", this.invalidsCombo_.getSelectedColor());
        });
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private final void refreshPrivate() {
        this.refreshing_ = true;
        this.ctableCombo_.setSelectedItem(prefs_.get("plot:scale.colorbar"));
        this.reversedCB_.setSelected(prefs_.getBoolean("plot:scale.reverse"));
        this.widthSpinner_.setValue(prefs_.getInt("plot:scale.width"));
        this.outlierShapeCombo_.setSelectedItem(prefs_.getString("plot:scale.outlier.shape"));
        this.outlierSideCombo_.setSelectedItem(prefs_.getString("plot:scale.outlier.side"));
        this.outlierGapCombo_.setSelectedItem(prefs_.getString("plot:scale.outlier.gap"));
        this.invalidsCombo_.setSelectedColor(prefs_.getColor("plot:scale.invalids"));
        this.scaleCapPlaceCombo_.setSelectedItem(prefs_.getString("plot:scale.label.location"));
        this.refreshing_ = false;
    }
}

