/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.map.kml.KMLDataResourceList;
import gov.nasa.giss.panoply.util.PanUtils;
import gov.nasa.giss.util.ResourceListDataEvent;
import gov.nasa.giss.util.ResourceListDataListener;
import java.lang.invoke.MethodHandles;
import javax.swing.table.DefaultTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanUnderlayTableModel
extends DefaultTableModel
implements ResourceListDataListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final KMLDataResourceList reslist_ = PanUtils.getUnderlayResourceList();

    public PanUnderlayTableModel() {
        this.reslist_.addListDataListener(this);
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        if (this.reslist_ == null) {
            return 0;
        }
        return this.reslist_.getSize();
    }

    public Class<String> getColumnClass(int col) {
        return String.class;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Status";
            }
        }
        return "Error";
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                Object oo = this.reslist_.getBackingObject(row);
                if (oo == null) {
                    return "null!";
                }
                return oo.toString();
            }
            case 1: {
                switch (this.reslist_.getLocType(row)) {
                    case INCODE: 
                    case JAR: {
                        return "Built-in";
                    }
                    case USERLIB: {
                        return "Library";
                    }
                }
                return "Session";
            }
        }
        return "Error";
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
    }

    @Override
    public void contentsChanged(ResourceListDataEvent e) {
        LOGGER.debug("Not implemented.");
    }

    @Override
    public void intervalAdded(ResourceListDataEvent e) {
        int index0 = e.getIndex0();
        int index1 = e.getIndex1();
        this.fireTableRowsInserted(index0, index1);
    }

    @Override
    public void intervalRemoved(ResourceListDataEvent e) {
        int index0 = e.getIndex0();
        int index1 = e.getIndex1();
        this.fireTableRowsDeleted(index0, index1);
    }
}

